/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.runnable.command;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlCorePlugin;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJob;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatus;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatusMap;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStreamsProxy;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManagerControl;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;
import org.eclipse.ptp.rmsystem.IJobStatus;

public class CommandJobStatus
implements ICommandJobStatus {
    private final String rmUniqueName;
    private final IJAXBResourceManagerControl control;
    private final ICommandJob open;
    private String jobId;
    private String owner;
    private String queue;
    private ILaunchConfiguration launchConfig;
    private String state;
    private String stateDetail;
    private String remoteOutputPath;
    private String remoteErrorPath;
    private ICommandJobStreamsProxy proxy;
    private IRemoteProcess process;
    private boolean initialized;
    private boolean waitEnabled;
    private boolean dirty;
    private boolean fFilesChecked;
    private long lastRequestedUpdate;

    public CommandJobStatus(String rmUniqueName, ICommandJob open, IJAXBResourceManagerControl control) {
        this(rmUniqueName, null, "UNDETERMINED", open, control);
    }

    public CommandJobStatus(String rmUniqueName, String jobId, String state, ICommandJob open, IJAXBResourceManagerControl control) {
        this.rmUniqueName = rmUniqueName;
        this.jobId = jobId;
        this.setState(state);
        this.open = open;
        this.control = control;
        this.waitEnabled = true;
        this.lastRequestedUpdate = 0L;
        this.initialized = false;
        this.dirty = false;
        this.fFilesChecked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        CommandJobStatus commandJobStatus = this;
        synchronized (commandJobStatus) {
            block9: {
                block8: {
                    block7: {
                        if (this.getStateRank(this.stateDetail) <= 4) break block7;
                        return false;
                    }
                    if (this.open == null) break block8;
                    this.open.terminate();
                    this.open.getJobStatus().setState("CANCELED");
                    return true;
                }
                this.waitEnabled = false;
                this.notifyAll();
                if (this.process == null || this.process.isCompleted()) break block9;
                this.process.destroy();
                if (this.proxy != null) {
                    this.proxy.close();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelWait() {
        CommandJobStatus commandJobStatus = this;
        synchronized (commandJobStatus) {
            this.waitEnabled = false;
            this.notifyAll();
        }
    }

    public IJAXBResourceManagerControl getControl() {
        return this.control;
    }

    public String getErrorPath() {
        return this.remoteErrorPath;
    }

    public synchronized String getJobId() {
        return this.jobId;
    }

    public synchronized long getLastUpdateRequest() {
        return this.lastRequestedUpdate;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfig;
    }

    public String getOutputPath() {
        return this.remoteOutputPath;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getQueueName() {
        return this.queue;
    }

    public String getRmUniqueName() {
        return this.rmUniqueName;
    }

    public synchronized String getState() {
        if (this.stateDetail != "CANCELED") {
            this.checkProcessStateForTermination();
        }
        return this.state;
    }

    public synchronized String getStateDetail() {
        if (this.stateDetail != "CANCELED") {
            this.checkProcessStateForTermination();
        }
        return this.stateDetail;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.proxy;
    }

    public void initialize(String jobId) {
        if (this.initialized) {
            return;
        }
        this.jobId = jobId;
        String path = null;
        this.remoteOutputPath = null;
        this.remoteErrorPath = null;
        IVariableMap rmVarMap = this.control.getEnvironment();
        Object o = rmVarMap.get("stdout_remote_path");
        if (o != null) {
            if (o instanceof PropertyType) {
                path = (String)((PropertyType)o).getValue();
            } else if (o instanceof AttributeType) {
                path = (String)((PropertyType)o).getValue();
            }
            if (path != null && !"".equals(path)) {
                this.remoteOutputPath = rmVarMap.getString(jobId, path);
            }
        }
        if ((o = rmVarMap.get("stderr_remote_path")) != null) {
            if (o instanceof PropertyType) {
                path = (String)((PropertyType)o).getValue();
            } else if (o instanceof AttributeType) {
                path = (String)((AttributeType)o).getValue();
            }
            if (path != null && !"".equals(path)) {
                this.remoteErrorPath = rmVarMap.getString(jobId, path);
            }
        }
        this.initialized = true;
    }

    public boolean isInteractive() {
        return this.process != null;
    }

    public void maybeWaitForHandlerFiles(int blockForSecs, IProgressMonitor monitor) {
        if (this.fFilesChecked) {
            return;
        }
        FileReadyChecker tout = null;
        FileReadyChecker terr = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (this.remoteOutputPath != null) {
            tout = this.checkForReady(this.remoteOutputPath, blockForSecs, (IProgressMonitor)progress.newChild(5));
        }
        if (this.remoteErrorPath != null) {
            terr = this.checkForReady(this.remoteErrorPath, blockForSecs, (IProgressMonitor)progress.newChild(5));
        }
        if (tout == null && terr == null) {
            this.fFilesChecked = true;
            return;
        }
        if (tout != null) {
            try {
                tout.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (terr != null) {
            try {
                terr.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if ((tout == null || tout.ready) && (terr == null || terr.ready)) {
            this.setState("JOB_OUTERR_READY");
        }
        this.fFilesChecked = true;
    }

    public void setLaunchConfig(ILaunchConfiguration launchConfig) {
        this.launchConfig = launchConfig;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setProcess(IRemoteProcess process) {
        this.process = process;
    }

    public void setProxy(ICommandJobStreamsProxy proxy) {
        this.proxy = proxy;
    }

    public void setQueueName(String name) {
        this.queue = name;
    }

    public synchronized void setState(String state) {
        if (!this.canUpdateState(state)) {
            return;
        }
        this.dirty = false;
        String previousDetail = this.stateDetail;
        if ("UNDETERMINED".equals(state)) {
            this.state = "UNDETERMINED";
            this.stateDetail = "UNDETERMINED";
        } else if ("SUBMITTED".equals(state)) {
            this.state = "SUBMITTED";
            this.stateDetail = "SUBMITTED";
        } else if ("RUNNING".equals(state)) {
            this.state = "RUNNING";
            this.stateDetail = "RUNNING";
        } else if ("SUSPENDED".equals(state)) {
            this.state = "SUSPENDED";
            this.stateDetail = "SUSPENDED";
        } else if ("COMPLETED".equals(state)) {
            this.state = "COMPLETED";
            this.stateDetail = "COMPLETED";
        } else if ("QUEUED_ACTIVE".equals(state)) {
            this.state = "SUBMITTED";
            this.stateDetail = "QUEUED_ACTIVE";
        } else if ("SYSTEM_ON_HOLD".equals(state)) {
            this.state = "SUBMITTED";
            this.stateDetail = "SYSTEM_ON_HOLD";
        } else if ("USER_ON_HOLD".equals(state)) {
            this.state = "SUBMITTED";
            this.stateDetail = "USER_ON_HOLD";
        } else if ("USER_SYSTEM_ON_HOLD".equals(state)) {
            this.state = "SUBMITTED";
            this.stateDetail = "USER_SYSTEM_ON_HOLD";
        } else if ("SYSTEM_SUSPENDED".equals(state)) {
            this.state = "SUSPENDED";
            this.stateDetail = "SYSTEM_SUSPENDED";
        } else if ("USER_SUSPENDED".equals(state)) {
            this.state = "SUSPENDED";
            this.stateDetail = "USER_SUSPENDED";
        } else if ("USER_SYSTEM_SUSPENDED".equals(state)) {
            this.state = "SUSPENDED";
            this.stateDetail = "USER_SYSTEM_SUSPENDED";
        } else if ("FAILED".equals(state)) {
            this.state = "COMPLETED";
            this.stateDetail = "FAILED";
        } else if ("CANCELED".equals(state)) {
            this.state = "COMPLETED";
            this.stateDetail = "CANCELED";
        } else if ("JOB_OUTERR_READY".equals(state)) {
            this.state = "COMPLETED";
            this.stateDetail = "JOB_OUTERR_READY";
        }
        if (previousDetail == null || !previousDetail.equals(this.stateDetail)) {
            this.dirty = true;
        }
    }

    public synchronized void setUpdateRequestTime(long update) {
        this.lastRequestedUpdate = update;
    }

    public synchronized boolean stateChanged() {
        boolean changed = this.dirty && !"UNDETERMINED".equals(this.state);
        this.dirty = false;
        return changed;
    }

    public String toString() {
        ArrayList<String> s = new ArrayList<String>();
        s.add(this.jobId);
        s.add(this.owner);
        s.add(this.queue);
        s.add(this.state);
        s.add(this.stateDetail);
        s.add(this.remoteOutputPath);
        s.add(this.remoteErrorPath);
        return ((Object)s).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void waitForJobId(String uuid, String waitUntil, ICommandJobStatusMap map, IProgressMonitor monitor) throws CoreException {
        env = this.control.getEnvironment();
        if (env != null) ** GOTO lbl33
        return;
lbl-1000:
        // 1 sources

        {
            var6_6 = this;
            synchronized (var6_6) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException v0) {}
            }
            if (this.isInteractive()) {
                try {
                    exit = this.process.exitValue();
                    if (exit != 0) {
                        throw CoreExceptionUtils.newException((String)(String.valueOf(uuid) + ":" + " " + "FAILED"), null);
                    }
                }
                catch (Throwable v2) {}
            }
            if ((p = (PropertyType)env.get(uuid)) == null) continue;
            this.jobId = p.getName();
            v = (String)p.getValue();
            if (v != null) {
                this.setState(v);
            }
            if (this.jobId == null) {
                if (this.stateDetail != "FAILED") continue;
                throw CoreExceptionUtils.newException((String)(String.valueOf(uuid) + ":" + " " + "FAILED"), null);
            }
            if (!this.stateChanged()) continue;
            env.put(this.jobId, (Object)p);
            if (map.addJobStatus(this.jobId, this)) continue;
            this.control.jobStateChanged(this.jobId, (IJobStatus)this);
lbl33:
            // 6 sources

            ** while (!monitor.isCanceled() && this.waitEnabled && (this.jobId == null || !this.isReached((String)this.state, (String)waitUntil)))
        }
lbl34:
        // 1 sources

    }

    private boolean canUpdateState(String newState) {
        int currRank;
        int prevRank = this.getStateRank(this.stateDetail);
        if (prevRank >= (currRank = this.getStateRank(newState))) {
            if (prevRank == 0) {
                return true;
            }
            if (prevRank != 4 || currRank != 3) {
                return false;
            }
        }
        return true;
    }

    private FileReadyChecker checkForReady(String path, int block, IProgressMonitor monitor) {
        FileReadyChecker t = new FileReadyChecker(path);
        t.block = block;
        t.path = path;
        t.callerMonitor = monitor;
        t.schedule();
        return t;
    }

    private void checkProcessStateForTermination() {
        if (this.process != null && this.process.isCompleted()) {
            this.setState(this.process.exitValue() == 0 ? "COMPLETED" : "FAILED");
        }
    }

    private int getStateRank(String state) {
        if ("SUBMITTED".equals(state)) {
            return 1;
        }
        if ("RUNNING".equals(state)) {
            return 4;
        }
        if ("SUSPENDED".equals(state)) {
            return 3;
        }
        if ("COMPLETED".equals(state)) {
            return 5;
        }
        if ("QUEUED_ACTIVE".equals(state)) {
            return 2;
        }
        if ("SYSTEM_ON_HOLD".equals(state)) {
            return 3;
        }
        if ("USER_ON_HOLD".equals(state)) {
            return 3;
        }
        if ("USER_SYSTEM_ON_HOLD".equals(state)) {
            return 3;
        }
        if ("SYSTEM_SUSPENDED".equals(state)) {
            return 3;
        }
        if ("USER_SUSPENDED".equals(state)) {
            return 3;
        }
        if ("USER_SYSTEM_SUSPENDED".equals(state)) {
            return 3;
        }
        if ("FAILED".equals(state)) {
            return 6;
        }
        if ("CANCELED".equals(state)) {
            return 6;
        }
        if ("JOB_OUTERR_READY".equals(state)) {
            return 7;
        }
        return 0;
    }

    private boolean isReached(String state, String waitUntil) {
        int j;
        int i = this.getStateRank(state);
        return i >= (j = this.getStateRank(waitUntil));
    }

    private class FileReadyChecker
    extends Job {
        private boolean ready;
        private int block;
        private String path;
        private IProgressMonitor callerMonitor;

        public FileReadyChecker(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.ready = false;
            long timeout = this.block * 1000;
            RemoteServicesDelegate d = null;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)120);
            try {
                d = CommandJobStatus.this.control.getRemoteServicesDelegate((IProgressMonitor)progress.newChild(20));
                if (d.getRemoteFileManager() == null) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
            }
            catch (CoreException ce) {
                IStatus iStatus = CoreExceptionUtils.getErrorStatus((String)ce.getMessage(), (Throwable)ce);
                return iStatus;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
            long start = System.currentTimeMillis();
            long last = 0L;
            long elapsed = 0L;
            double increment = 0.0;
            do {
                try {
                    this.ready = RemoteServicesDelegate.isStable((IRemoteFileManager)d.getRemoteFileManager(), (String)this.path, (int)3, (IProgressMonitor)progress.newChild(20));
                }
                catch (Throwable t) {
                    JAXBControlCorePlugin.log(t);
                }
                if (this.ready || (elapsed = System.currentTimeMillis() - start) >= timeout) break;
                increment = (double)(elapsed - last) / (double)timeout * 100.0;
                last = elapsed;
                progress.worked((int)increment);
            } while (!progress.isCanceled() && !this.callerMonitor.isCanceled());
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

