/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.utils;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.rm.jaxb.core.JAXBCorePlugin;
import org.eclipse.ptp.rm.jaxb.core.JAXBRMPreferenceConstants;

public class TokenizerLogger {
    private static TokenizerLogger instance;
    private PrintWriter out;
    private final boolean segment = Preferences.getBoolean((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.SEGMENT_PATTERN);
    private final boolean match = Preferences.getBoolean((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.MATCH_STATUS);
    private final boolean action = Preferences.getBoolean((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.ACTIONS);
    private final boolean properties = Preferences.getBoolean((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.CREATED_PROPERTIES);

    public static synchronized TokenizerLogger getLogger() {
        if (instance == null) {
            TokenizerLogger.initialize();
        }
        return instance;
    }

    public static synchronized void initialize() {
        instance = new TokenizerLogger();
    }

    private TokenizerLogger() {
        String path = Preferences.getString((String)JAXBCorePlugin.getUniqueIdentifier(), (String)JAXBRMPreferenceConstants.LOG_FILE);
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
        if (path != null && !"".equals(path)) {
            try {
                this.out = new PrintWriter(path);
            }
            catch (FileNotFoundException t) {
                JAXBCorePlugin.log((Throwable)t);
                this.out = new PrintWriter(System.out);
            }
        } else {
            this.out = new PrintWriter(System.out);
        }
    }

    public void logActionInfo(String message) {
        if (this.action) {
            this.out.println(message);
            this.out.flush();
        }
    }

    public void logMatchInfo(String message) {
        if (this.match) {
            this.out.println(message);
            this.out.flush();
        }
    }

    public void logPropertyInfo(String message) {
        if (this.properties) {
            this.out.println(message);
            this.out.flush();
        }
    }

    public void logSegmentInfo(String message) {
        if (this.segment) {
            this.out.println(message);
            this.out.flush();
        }
    }
}

