/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.core.elements.listeners.IMachineChildListener;
import org.eclipse.ptp.core.elements.listeners.IMachineListener;
import org.eclipse.ptp.internal.core.elements.Parent;
import org.eclipse.ptp.internal.core.elements.events.ChangedNodeEvent;
import org.eclipse.ptp.internal.core.elements.events.MachineChangeEvent;
import org.eclipse.ptp.internal.core.elements.events.NewNodeEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveNodeEvent;
import org.eclipse.ptp.rmsystem.IResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMachine
extends Parent
implements IPMachine {
    private final ListenerList elementListeners = new ListenerList();
    private final ListenerList childListeners = new ListenerList();
    private final IResourceManager fResourceManager;

    public PMachine(String id, IResourceManager rm, IPElement parent, IAttribute<?, ?, ?>[] attrs) {
        super(id, parent, attrs);
        IntegerAttribute numNodes;
        this.fResourceManager = rm;
        IAttribute machineState = (EnumeratedAttribute)this.getAttribute(MachineAttributes.getStateAttributeDefinition());
        if (machineState == null) {
            machineState = MachineAttributes.getStateAttributeDefinition().create();
            this.addAttribute(machineState);
        }
        if ((numNodes = (IntegerAttribute)this.getAttribute(MachineAttributes.getNumNodesAttributeDefinition())) == null) {
            try {
                numNodes = MachineAttributes.getNumNodesAttributeDefinition().create(0);
            }
            catch (IllegalValueException e) {
                throw new RuntimeException(e);
            }
            this.addAttribute(numNodes);
        }
    }

    @Override
    public void addChildListener(IMachineChildListener listener) {
        this.childListeners.add((Object)listener);
    }

    @Override
    public void addElementListener(IMachineListener listener) {
        this.elementListeners.add((Object)listener);
    }

    @Override
    public void addNodeAttributes(Collection<IPNode> nodes, IAttribute<?, ?, ?>[] attrs) {
        for (IPNode node : nodes) {
            node.addAttributes(attrs);
        }
        this.fireChangedNodes(nodes);
    }

    @Override
    public void addNodes(Collection<IPNode> nodes) {
        for (IPNode node : nodes) {
            this.addChild(node);
        }
        try {
            ((IntegerAttribute)this.getAttribute(MachineAttributes.getNumNodesAttributeDefinition())).setValue(this.getChildren().length);
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
        this.fireNewNodes(nodes);
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
        this.fireChangedMachine(attrs);
    }

    private void fireChangedMachine(AttributeManager attrs) {
        MachineChangeEvent e = new MachineChangeEvent(this, attrs);
        Object[] objectArray = this.elementListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMachineListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireChangedNodes(Collection<IPNode> nodes) {
        ChangedNodeEvent e = new ChangedNodeEvent(this, nodes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMachineChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireNewNodes(Collection<IPNode> nodes) {
        NewNodeEvent e = new NewNodeEvent(this, nodes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMachineChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireRemoveNodes(Collection<IPNode> nodes) {
        RemoveNodeEvent e = new RemoveNodeEvent(this, nodes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMachineChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    @Override
    public IPNode getNodeById(String id) {
        IPElement element = this.findChild(id);
        if (element != null) {
            return (IPNode)element;
        }
        return null;
    }

    @Override
    public IPNode[] getNodes() {
        IPElement[] children = this.getChildren();
        ArrayList<IPNode> nodes = new ArrayList<IPNode>(children.length);
        IPElement[] iPElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPElement element = iPElementArray[n2];
            nodes.add((IPNode)element);
            ++n2;
        }
        return nodes.toArray(new IPNode[nodes.size()]);
    }

    @Override
    public IResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    @Override
    public MachineAttributes.State getState() {
        return (MachineAttributes.State)((Object)((EnumeratedAttribute)this.getAttribute(MachineAttributes.getStateAttributeDefinition())).getValue());
    }

    @Override
    public void removeChildListener(IMachineChildListener listener) {
        this.childListeners.remove((Object)listener);
    }

    @Override
    public void removeElementListener(IMachineListener listener) {
        this.elementListeners.remove((Object)listener);
    }

    @Override
    public void removeNodes(Collection<IPNode> nodes) {
        for (IPNode node : nodes) {
            this.removeChild(node);
        }
        try {
            ((IntegerAttribute)this.getAttribute(MachineAttributes.getNumNodesAttributeDefinition())).setValue(this.getChildren().length);
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
        this.fireRemoveNodes(nodes);
    }

    @Override
    public int totalNodes() {
        try {
            ((IntegerAttribute)this.getAttribute(MachineAttributes.getNumNodesAttributeDefinition())).setValue(this.getChildren().length);
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
        return this.size();
    }
}

