/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SDMPage
extends AbstractLaunchConfigurationTab {
    protected static final String EMPTY_STRING = "";
    private IResourceManager resourceManager = null;
    protected Combo fSDMBackendCombo = null;
    protected Text fRMDebuggerPathText = null;
    protected Text fRMDebuggerAddressText = null;
    protected Button fRMDebuggerBrowseButton = null;

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        try {
            this.fSDMBackendCombo.setText(workingCopy.getAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND", Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE)));
            this.fRMDebuggerAddressText.setText(this.getAddress(workingCopy));
            this.fRMDebuggerPathText.setText(workingCopy.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", EMPTY_STRING));
        }
        catch (CoreException coreException) {}
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(comp, 0);
        label.setText(Messages.SDMPage_11);
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fSDMBackendCombo = new Combo(comp, 8);
        this.fSDMBackendCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSDMBackendCombo.setItems(SDMDebugCorePlugin.getDefault().getDebuggerBackends());
        this.fSDMBackendCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.SDMPage_0);
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fRMDebuggerPathText = new Text(comp, 2052);
        this.fRMDebuggerPathText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fRMDebuggerPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fRMDebuggerBrowseButton = this.createPushButton(comp, Messages.SDMPage_1, null);
        this.fRMDebuggerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file = SDMPage.this.browseFile();
                if (file != null) {
                    SDMPage.this.fRMDebuggerPathText.setText(file);
                }
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.SDMPage_2);
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fRMDebuggerAddressText = new Text(comp, 2052);
        this.fRMDebuggerAddressText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fRMDebuggerAddressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDMPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.setControl((Control)parent);
    }

    public String getName() {
        return Messages.SDMPage_3;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String rmId = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", EMPTY_STRING);
            this.resourceManager = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmId);
            this.fSDMBackendCombo.setText(configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND", Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE)));
            this.fRMDebuggerAddressText.setText(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", EMPTY_STRING));
            this.fRMDebuggerPathText.setText(configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", EMPTY_STRING));
        }
        catch (CoreException coreException) {}
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.getFieldContent(this.fRMDebuggerAddressText.getText()) == null) {
            this.setErrorMessage(Messages.SDMPage_4);
        } else if (this.getFieldContent(this.fRMDebuggerPathText.getText()) == null) {
            this.setErrorMessage(Messages.SDMPage_5);
        }
        return this.getErrorMessage() == null;
    }

    public boolean canSave() {
        this.setErrorMessage(null);
        if (this.getFieldContent(this.fRMDebuggerAddressText.getText()) == null) {
            this.setErrorMessage(Messages.SDMPage_7);
        } else if (this.getFieldContent(this.fRMDebuggerPathText.getText()) == null) {
            this.setErrorMessage(Messages.SDMPage_8);
        }
        return this.getErrorMessage() == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isValid((ILaunchConfiguration)configuration)) {
            configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND", this.getFieldContent(this.fSDMBackendCombo.getText()));
            configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", this.getFieldContent(this.fRMDebuggerPathText.getText()));
            configuration.setAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", this.getFieldContent(this.fRMDebuggerAddressText.getText()));
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_SDM_BACKEND", Preferences.getString((String)SDMDebugCorePlugin.getUniqueIdentifier(), (String)SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE));
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", EMPTY_STRING);
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", this.getAddress(configuration));
    }

    private String browseFile() {
        IRemoteUIServices remoteUISrv = this.getRemoteUIServices(this.resourceManager);
        if (remoteUISrv != null) {
            IRemoteUIFileManager fileManager = remoteUISrv.getUIFileManager();
            if (fileManager != null) {
                fileManager.setConnection(this.getRemoteConnection(this.resourceManager));
                return fileManager.browseFile(this.getShell(), Messages.SDMPage_10, this.fRMDebuggerPathText.getText(), 0);
            }
        } else {
            FileDialog dialog = new FileDialog(this.getShell());
            dialog.setText(Messages.SDMPage_10);
            dialog.setFileName(this.fRMDebuggerPathText.getText());
            return dialog.open();
        }
        return null;
    }

    private String getAddress(ILaunchConfigurationWorkingCopy configuration) {
        String rmId;
        String address;
        try {
            address = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", EMPTY_STRING);
            rmId = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", EMPTY_STRING);
        }
        catch (CoreException coreException) {
            return EMPTY_STRING;
        }
        IResourceManager rm = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmId);
        if (rm != null && this.resourceManager != rm) {
            this.resourceManager = rm;
            IRemoteResourceManagerConfiguration config = this.getRemoteResourceManagerConfiguration();
            if (config != null) {
                if (config.testOption(2)) {
                    return "localhost";
                }
                return config.getLocalAddress();
            }
            return "localhost";
        }
        return address;
    }

    private IRemoteResourceManagerConfiguration getRemoteResourceManagerConfiguration() {
        IResourceManagerConfiguration rmConfig;
        if (this.resourceManager != null && (rmConfig = this.resourceManager.getConfiguration()) instanceof IRemoteResourceManagerConfiguration) {
            return (IRemoteResourceManagerConfiguration)rmConfig;
        }
        return null;
    }

    private IRemoteServices getRemoteServices(IResourceManager rm) {
        if (rm != null) {
            IResourceManagerComponentConfiguration rmConfig = rm.getControlConfiguration();
            return PTPRemoteUIPlugin.getDefault().getRemoteServices(rmConfig.getRemoteServicesId(), (IRunnableContext)this.getLaunchConfigurationDialog());
        }
        return null;
    }

    private IRemoteUIServices getRemoteUIServices(IResourceManager rm) {
        IRemoteServices rsrv = this.getRemoteServices(rm);
        if (rsrv != null) {
            return PTPRemoteUIPlugin.getDefault().getRemoteUIServices(rsrv);
        }
        return null;
    }

    private IRemoteConnection getRemoteConnection(IResourceManager rm) {
        IRemoteConnectionManager mgr;
        String connName;
        IRemoteServices rsrv = this.getRemoteServices(rm);
        if (rsrv != null && (connName = rm.getControlConfiguration().getConnectionName()) != null && (mgr = rsrv.getConnectionManager()) != null) {
            IRemoteUIConnectionManager connMgr;
            IRemoteUIServices uiServices;
            IRemoteConnection conn = mgr.getConnection(connName);
            if (conn != null && !conn.isOpen() && (uiServices = this.getRemoteUIServices(rm)) != null && (connMgr = uiServices.getUIConnectionManager()) != null) {
                connMgr.openConnectionWithProgress(this.getShell(), null, conn);
            }
            return conn;
        }
        return null;
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }
}

