/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.git.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.ptp.rdt.sync.git.core.CommandRunner;
import org.eclipse.ptp.rdt.sync.git.core.EclipseGitProgressTransformer;
import org.eclipse.ptp.rdt.sync.git.core.RemoteExecutionException;
import org.eclipse.ptp.rdt.sync.git.core.RemoteSyncException;
import org.eclipse.ptp.rdt.sync.git.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.git.core.messages.Messages;
import org.eclipse.ptp.remote.core.AbstractRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitRemoteSyncConnection {
    private final int MAX_FILES = 100;
    private static final String remoteProjectName = "eclipse_auto";
    private static final String commitMessage = Messages.GRSC_CommitMessage;
    public static final String gitDir = ".ptp-sync";
    private static final String gitCommand = "git --git-dir=.ptp-sync --work-tree=.";
    private static final String remotePushBranch = "ptp-push";
    private final IRemoteConnection connection;
    private final SyncFileFilter fileFilter;
    private final String localDirectory;
    private final String remoteDirectory;
    private Git git;
    private TransportGitSsh transport;

    public GitRemoteSyncConnection(IRemoteConnection conn, String localDir, String remoteDir, SyncFileFilter filter, IProgressMonitor monitor) throws RemoteSyncException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.connection = conn;
            this.fileFilter = filter;
            this.localDirectory = localDir;
            this.remoteDirectory = remoteDir;
            try {
                this.buildRepo((IProgressMonitor)subMon.newChild(10));
            }
            catch (IOException e) {
                throw new RemoteSyncException(e);
            }
            catch (RemoteExecutionException e) {
                throw new RemoteSyncException(e);
            }
            RemoteConfig remoteConfig = this.buildRemoteConfig(this.git.getRepository().getConfig());
            this.buildTransport(remoteConfig);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private RemoteConfig buildRemoteConfig(StoredConfig config) {
        RemoteConfig rconfig = null;
        try {
            rconfig = new RemoteConfig((Config)config, remoteProjectName);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        RefSpec refSpecFetch = new RefSpec("+refs/heads/master:refs/remotes/eclipse_auto/master");
        RefSpec refSpecPush = new RefSpec("+master:ptp-push");
        rconfig.addFetchRefSpec(refSpecFetch);
        rconfig.addPushRefSpec(refSpecPush);
        return rconfig;
    }

    private Git buildRepo(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMon.subTask(Messages.GitRemoteSyncConnection_building_repo);
        try {
            File localDir = new File(this.localDirectory);
            FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
            File gitDirFile = new File(String.valueOf(this.localDirectory) + File.separator + gitDir);
            FileRepository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)repoBuilder.setWorkTree(localDir)).setGitDir(gitDirFile)).build();
            this.git = new Git((Repository)repository);
            if (!gitDirFile.exists()) {
                repository.create(false);
                this.doCommit();
            }
            try {
                CommandRunner.createRemoteDirectory(this.connection, this.remoteDirectory, (IProgressMonitor)subMon.newChild(5));
            }
            catch (CoreException e) {
                throw new RemoteSyncException(e);
            }
            boolean existingGitRepo = this.doRemoteInit((IProgressMonitor)subMon.newChild(5));
            boolean needToCommitRemote = this.prepareRemoteForCommit((IProgressMonitor)subMon.newChild(90), !existingGitRepo);
            if (needToCommitRemote) {
                this.commitRemoteFiles((IProgressMonitor)subMon.newChild(5));
            }
            Git git = this.git;
            return git;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean doRemoteInit(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            String command = "git --git-dir=.ptp-sync init";
            CommandRunner.CommandResults commandResults = null;
            try {
                commandResults = CommandRunner.executeRemoteCommand(this.connection, command, this.remoteDirectory, (IProgressMonitor)subMon.newChild(10));
            }
            catch (InterruptedException e) {
                throw new RemoteExecutionException(e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteExecutionException(e);
            }
            if (commandResults.getExitCode() != 0) {
                throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitInitFailure) + commandResults.getStderr());
            }
            return commandResults.getStdout().contains("existing");
            {
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean prepareRemoteForCommit(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException {
        return this.prepareRemoteForCommit(monitor, false);
    }

    private boolean prepareRemoteForCommit(IProgressMonitor monitor, boolean includeUntrackedFiles) throws IOException, RemoteExecutionException, RemoteSyncException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            HashSet<String> filesToAdd = new HashSet<String>();
            HashSet<String> filesToDelete = new HashSet<String>();
            boolean needToCommit = false;
            this.getRemoteFileStatus(filesToAdd, filesToDelete, (IProgressMonitor)subMon.newChild(5), includeUntrackedFiles);
            for (String fileName : filesToDelete) {
                if (!filesToAdd.contains(fileName)) continue;
                filesToAdd.remove(fileName);
            }
            if (filesToAdd.size() > 0) {
                this.addRemoteFiles(filesToAdd, (IProgressMonitor)subMon.newChild(90));
                needToCommit = true;
            }
            if (filesToDelete.size() > 0) {
                this.deleteRemoteFiles(filesToDelete, (IProgressMonitor)subMon.newChild(5));
                needToCommit = true;
            }
            boolean bl = needToCommit;
            return bl;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void commitRemoteFiles(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        subMon.subTask(Messages.GitRemoteSyncConnection_committing_remote);
        try {
            String command = "git --git-dir=.ptp-sync --work-tree=. commit -m \"" + commitMessage + "\"";
            CommandRunner.CommandResults commandResults = null;
            try {
                commandResults = CommandRunner.executeRemoteCommand(this.connection, command, this.remoteDirectory, (IProgressMonitor)subMon.newChild(10));
            }
            catch (InterruptedException e) {
                throw new RemoteExecutionException(e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteExecutionException(e);
            }
            if (commandResults.getExitCode() != 0) {
                throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitCommitFailure) + commandResults.getStderr());
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void deleteRemoteFiles(Set<String> filesToDelete, IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            List<String> command = this.stringToList("git --git-dir=.ptp-sync --work-tree=. rm");
            for (String fileName : filesToDelete) {
                command.add(fileName);
            }
            CommandRunner.CommandResults commandResults = null;
            try {
                commandResults = CommandRunner.executeRemoteCommand(this.connection, command, this.remoteDirectory, (IProgressMonitor)subMon.newChild(10));
            }
            catch (InterruptedException e) {
                throw new RemoteExecutionException(e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteExecutionException(e);
            }
            if (commandResults.getExitCode() != 0) {
                throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitRmFailure) + commandResults.getStderr());
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private List<String> stringToList(String command) {
        return new ArrayList<String>(Arrays.asList(command.split(" ")));
    }

    private void addRemoteFiles(Set<String> filesToAdd, IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)filesToAdd.size());
        subMon.subTask(Messages.GitRemoteSyncConnection_adding_files);
        try {
            while (!filesToAdd.isEmpty()) {
                List<String> commandList = this.stringToList("git --git-dir=.ptp-sync --work-tree=. add");
                int count = 1;
                String[] stringArray = filesToAdd.toArray(new String[0]);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    if (count++ % 100 == 0) break;
                    commandList.add(fileName);
                    filesToAdd.remove(fileName);
                    ++n2;
                }
                CommandRunner.CommandResults commandResults = null;
                try {
                    commandResults = CommandRunner.executeRemoteCommand(this.connection, commandList, this.remoteDirectory, (IProgressMonitor)subMon.newChild(10));
                }
                catch (InterruptedException e) {
                    throw new RemoteExecutionException(e);
                }
                catch (RemoteConnectionException e) {
                    throw new RemoteExecutionException(e);
                }
                if (commandResults.getExitCode() != 0) {
                    throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitAddFailure) + commandResults.getStderr());
                }
                monitor.worked(count);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void getRemoteFileStatus(Set<String> filesToAdd, Set<String> filesToDelete, IProgressMonitor monitor, boolean includeUntrackedFiles) throws IOException, RemoteExecutionException, RemoteSyncException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        subMon.subTask(Messages.GitRemoteSyncConnection_getting_remote_file_status);
        try {
            String command = includeUntrackedFiles ? "git --git-dir=.ptp-sync --work-tree=. ls-files -t --modified --others --deleted" : "git --git-dir=.ptp-sync --work-tree=. ls-files -t --modified --deleted";
            CommandRunner.CommandResults commandResults = null;
            try {
                commandResults = CommandRunner.executeRemoteCommand(this.connection, command, this.remoteDirectory, (IProgressMonitor)subMon.newChild(10));
            }
            catch (InterruptedException e) {
                throw new RemoteExecutionException(e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteExecutionException(e);
            }
            if (commandResults.getExitCode() != 0) {
                throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitLsFilesFailure) + commandResults.getStdout());
            }
            BufferedReader statusReader = new BufferedReader(new StringReader(commandResults.getStdout()));
            String line = null;
            while ((line = statusReader.readLine()) != null) {
                if (line.charAt(0) == ' ' || line.charAt(1) != ' ' || line.charAt(2) == ' ') continue;
                char status = line.charAt(0);
                String fn = line.substring(2);
                if (status == 'R') {
                    filesToDelete.add(fn);
                    continue;
                }
                if (this.fileFilter.shouldIgnore(fn)) continue;
                filesToAdd.add(fn);
            }
            statusReader.close();
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void getFileStatus(Set<String> filesToAdd, Set<String> filesToDelete, boolean includeUntrackedFiles) throws RemoteSyncException {
        StatusCommand statusCommand = this.git.status();
        try {
            Status status = statusCommand.call();
            filesToAdd.addAll(status.getAdded());
            filesToAdd.addAll(status.getModified());
            if (includeUntrackedFiles) {
                filesToAdd.addAll(status.getUntracked());
            }
            filesToDelete.addAll(status.getMissing());
        }
        catch (NoWorkTreeException e) {
            throw new RemoteSyncException(e);
        }
        catch (IOException e) {
            throw new RemoteSyncException(e);
        }
        HashSet<String> filesToBeIgnored = new HashSet<String>();
        for (String fileName : filesToAdd) {
            if (!this.fileFilter.shouldIgnore(fileName)) continue;
            filesToBeIgnored.add(fileName);
        }
        filesToAdd.removeAll(filesToBeIgnored);
    }

    private void buildTransport(RemoteConfig remoteConfig) {
        URIish uri = this.buildURI();
        try {
            this.transport = (TransportGitSsh)Transport.open((Repository)this.git.getRepository(), (URIish)uri);
        }
        catch (NotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (TransportException e) {
            throw new RuntimeException(e);
        }
        this.transport.setSshSessionFactory(new SshSessionFactory(){

            public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
                return new PTPSession(uri);
            }
        });
        this.transport.applyConfig(remoteConfig);
    }

    private URIish buildURI() {
        return new URIish().setHost("none").setScheme("ssh").setPath(String.valueOf(this.remoteDirectory) + "/" + gitDir);
    }

    public void close() {
        this.transport.close();
    }

    private void doCommit() throws RemoteSyncException {
        HashSet<String> filesToAdd = new HashSet<String>();
        HashSet<String> filesToRemove = new HashSet<String>();
        this.getFileStatus(filesToAdd, filesToRemove, true);
        try {
            if (!filesToAdd.isEmpty()) {
                AddCommand addCommand = this.git.add();
                for (String fileName : filesToAdd) {
                    addCommand.addFilepattern(fileName);
                }
                addCommand.call();
            }
            if (!filesToRemove.isEmpty()) {
                RmCommand rmCommand = this.git.rm();
                for (String fileName : filesToRemove) {
                    rmCommand.addFilepattern(fileName);
                }
                rmCommand.call();
            }
            CommitCommand commitCommand = this.git.commit();
            commitCommand.setMessage(commitMessage);
            commitCommand.call();
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException(e);
        }
        catch (UnmergedPathException e) {
            throw new RemoteSyncException(e);
        }
    }

    public IRemoteConnection getConnection() {
        return this.connection;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void syncLocalToRemote(IProgressMonitor monitor) throws RemoteSyncException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        subMon.subTask(Messages.GitRemoteSyncConnection_sync_local_to_remote);
        try {
            this.doCommit();
            try {
                this.transport.push((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMon.newChild(5)), null);
                CommandRunner.CommandResults mergeResults = CommandRunner.executeRemoteCommand(this.connection, "git --git-dir=.ptp-sync --work-tree=. merge ptp-push", this.remoteDirectory, (IProgressMonitor)subMon.newChild(5));
                if (mergeResults.getExitCode() != 0) {
                    throw new RemoteSyncException(new RemoteExecutionException(String.valueOf(Messages.GRSC_GitMergeFailure) + mergeResults.getStdout()));
                }
            }
            catch (IOException e) {
                throw new RemoteSyncException(e);
            }
            catch (InterruptedException e) {
                throw new RemoteSyncException(e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteSyncException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void syncRemoteToLocal(IProgressMonitor monitor) throws RemoteSyncException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        subMon.subTask(Messages.GitRemoteSyncConnection_sync_remote_to_local);
        try {
            try {
                this.prepareRemoteForCommit((IProgressMonitor)subMon.newChild(5));
                this.transport.fetch((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMon.newChild(5)), null);
                Ref masterRef = this.git.getRepository().getRef("refs/remotes/eclipse_auto/master");
                MergeCommand mergeCommand = this.git.merge().include(masterRef);
                mergeCommand.call();
            }
            catch (IOException e) {
                throw new RemoteSyncException(e);
            }
            catch (GitAPIException e) {
                throw new RemoteSyncException(e);
            }
            catch (RemoteExecutionException e) {
                throw new RemoteSyncException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public class PTPSession
    implements RemoteSession {
        private final URIish uri;

        public PTPSession(URIish uri) {
            this.uri = uri;
        }

        public Process exec(String command, int timeout) throws TransportException {
            LinkedList<String> commandList = new LinkedList<String>();
            commandList.add("sh");
            commandList.add("-c");
            commandList.add(command);
            try {
                if (!GitRemoteSyncConnection.this.connection.isOpen()) {
                    GitRemoteSyncConnection.this.connection.open(null);
                }
                return (AbstractRemoteProcess)GitRemoteSyncConnection.this.connection.getRemoteServices().getProcessBuilder(GitRemoteSyncConnection.this.connection, commandList).start();
            }
            catch (IOException e) {
                throw new TransportException(this.uri, e.getMessage(), (Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new TransportException(this.uri, e.getMessage(), (Throwable)e);
            }
        }

        public void disconnect() {
        }
    }
}

