/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.dependence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.photran.internal.core.analysis.dependence.Messages;
import org.eclipse.photran.internal.core.analysis.loops.GenericASTVisitorWithLoops;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.analysis.dependence.DependenceTestFailure;
import org.eclipse.rephraserengine.core.analysis.dependence.IVariableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableReference
implements IVariableReference {
    public final IASTNode node;
    public final String variable;
    public final LinearFunction[] indices;
    protected final boolean isWrite;

    private VariableReference(IASTNode node, String array, LinearFunction[] indices, boolean isWrite) {
        this.node = node;
        this.variable = array;
        this.indices = indices;
        this.isWrite = isWrite;
    }

    public static VariableReference fromLHS(ASTAssignmentStmtNode node) {
        String lhsVar = PhotranVPG.canonicalizeIdentifier(node.getLhsVariable().getName().getText());
        LinearFunction[] lhsIndices = null;
        if (node.getLhsExprList() != null) {
            lhsIndices = LinearFunction.fromList(node.getLhsExprList());
        } else if (node.getLhsNameList() != null) {
            lhsIndices = LinearFunction.fromList(node.getLhsNameList());
        }
        return new VariableReference(node, lhsVar, lhsIndices, true);
    }

    public static Collection<VariableReference> fromRHS(ASTAssignmentStmtNode node) {
        if (node.getRhs() == null) {
            throw new DependenceTestFailure(Messages.bind((String)Messages.VariableReference_AssignmentStmtCannotBeProcessed, (Object)node.toString().trim()));
        }
        return VariableReference.fromExpr(node.getRhs(), false);
    }

    public static Collection<VariableReference> fromExpr(IExpr expr, final boolean isWrite) {
        final ArrayList<VariableReference> result = new ArrayList<VariableReference>();
        expr.accept(new GenericASTVisitorWithLoops(){

            public void visitASTVarOrFnRefNode(ASTVarOrFnRefNode node) {
                if (node.getName() == null || node.getFunctionArgList() != null || node.getDerivedTypeComponentRef() != null || node.getComponentSectionSubscriptList() != null || node.getSubstringRange() != null) {
                    return;
                }
                String name = PhotranVPG.canonicalizeIdentifier(node.getName().getName().getText());
                LinearFunction[] indices = LinearFunction.fromList(node.getPrimarySectionSubscriptList());
                result.add(new VariableReference(node, name, indices, isWrite, null));
            }
        });
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.variable);
        if (this.indices != null) {
            sb.append("(");
            int i = 0;
            while (i < this.indices.length) {
                sb.append(String.valueOf(i > 0 ? ", " : "") + this.indices[i]);
                ++i;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isRead() {
        return !this.isWrite;
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public boolean isScalar() {
        return this.indices == null;
    }

    /* synthetic */ VariableReference(IASTNode iASTNode, String string, LinearFunction[] linearFunctionArray, boolean bl, VariableReference variableReference) {
        this(iASTNode, string, linearFunctionArray, bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinearFunction {
        public final int slope;
        public final String variable;
        public final int y_intercept;
        private static Pattern mxb = Pattern.compile("((-?(\\d+)[ \t]*\\*[ \t]*)?(\\w+)[ \t]*(\\+|-)[ \t]*)?(\\d+)");
        private static Pattern mx = Pattern.compile("((-?\\d+)[ \t]*\\*[ \t]*)?(\\w+)");
        private static Pattern bmx = Pattern.compile("(-?\\d+)[ \t]*\\+[ \t]*((-?\\d+)[ \t]*\\*[ \t]*)?(\\w+)");
        private static Pattern nxb = Pattern.compile("-[ \\t]*(\\w+)([ \t]*(\\+|-)[ \t]*(\\d+))?");
        private static Pattern bnx = Pattern.compile("(-?\\d+)[ \t]*\\+[ \t]*-[ \t]*(\\w+)");

        private LinearFunction(int slope, String variable, int y_intercept) {
            this.slope = slope;
            this.variable = variable;
            this.y_intercept = y_intercept;
        }

        public static LinearFunction from(String slope, String variable, String y_intercept) {
            try {
                int m = slope == null || slope.equals("") ? 1 : Integer.parseInt(slope);
                String x = variable == null ? null : PhotranVPG.canonicalizeIdentifier(variable);
                int b = y_intercept == null || y_intercept.equals("") ? 0 : Integer.parseInt(y_intercept);
                return new LinearFunction(m, x, b);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public static LinearFunction[] fromList(IASTListNode<? extends IASTNode> list) {
            if (list == null) {
                return null;
            }
            LinearFunction[] result = new LinearFunction[list.size()];
            int i = 0;
            while (i < list.size()) {
                LinearFunction thisIndex = LinearFunction.fromNode((IASTNode)list.get(i));
                if (thisIndex == null) {
                    return null;
                }
                result[i] = thisIndex;
                ++i;
            }
            return result;
        }

        public static LinearFunction fromNode(IASTNode node) {
            Matcher m;
            String str = node.toString().trim();
            if (str.startsWith(",")) {
                str = str.substring(1);
            }
            if ((m = mxb.matcher(str = str.trim())).matches()) {
                return LinearFunction.from(m.group(3), m.group(4), LinearFunction.intString(m.group(5), m.group(6)));
            }
            m = mx.matcher(str);
            if (m.matches()) {
                return LinearFunction.from(m.group(2), m.group(3), null);
            }
            m = bmx.matcher(str);
            if (m.matches()) {
                return LinearFunction.from(m.group(3), m.group(4), m.group(1));
            }
            m = nxb.matcher(str);
            if (m.matches()) {
                return LinearFunction.from("-1", m.group(1), LinearFunction.intString(m.group(3), m.group(4)));
            }
            m = bnx.matcher(str);
            if (m.matches()) {
                return LinearFunction.from("-1", m.group(2), m.group(1));
            }
            return null;
        }

        private static String intString(String sign, String value) {
            if (sign == null) {
                return value;
            }
            if (value == null) {
                return null;
            }
            return String.valueOf(sign.replace("+", "")) + value;
        }

        public String toString() {
            if (this.variable == null) {
                return Integer.toString(this.y_intercept);
            }
            return String.valueOf(this.slope) + "*" + this.variable + (this.y_intercept >= 0 ? "+" : "-") + Math.abs(this.y_intercept);
        }
    }
}

