/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.reindenter;

import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.core.reindenter.ReindentEachLineVisitor;
import org.eclipse.photran.internal.core.reindenter.ReindentingVisitor;
import org.eclipse.photran.internal.core.reindenter.ShiftBlockVisitor;

public final class Reindenter {
    public static void reindent(IASTNode node, IFortranAST ast) {
        Reindenter.reindent(node, ast, Strategy.SHIFT_ENTIRE_BLOCK);
    }

    public static void reindent(IASTNode node, IFortranAST ast, Strategy strategy) {
        Reindenter.reindent(node.findFirstToken(), node.findLastToken(), ast, strategy);
    }

    public static void reindent(Token firstTokenInAffectedNode, Token lastTokenInAffectedNode, IFortranAST ast) {
        Reindenter.reindent(firstTokenInAffectedNode, lastTokenInAffectedNode, ast, Strategy.SHIFT_ENTIRE_BLOCK);
    }

    public static void reindent(int fromLine, int thruLine, IFortranAST ast) {
        Reindenter.reindent(fromLine, thruLine, ast, Strategy.SHIFT_ENTIRE_BLOCK);
    }

    public static void reindent(int fromLine, int thruLine, IFortranAST ast, Strategy strategy) {
        Reindenter.reindent(ast.findFirstTokenOnOrAfterLine(fromLine), ast.findLastTokenOnOrBeforeLine(thruLine), ast, strategy);
    }

    private static void reindent(Token firstTokenInRegion, Token lastTokenInRegion, IFortranAST ast, Strategy strategy) {
        if (firstTokenInRegion != null && lastTokenInRegion != null) {
            ast.accept(strategy.createVisitor(ast, firstTokenInRegion, lastTokenInRegion));
        }
    }

    public static String defaultIndentation() {
        return FortranPreferences.TAB_WIDTH.getStringOfSpaces();
    }

    private Reindenter() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        SHIFT_ENTIRE_BLOCK{

            protected ReindentingVisitor createVisitor(IFortranAST ast, Token firstTokenInRegion, Token lastTokenInRegion) {
                return new ShiftBlockVisitor(ast, firstTokenInRegion, lastTokenInRegion);
            }
        }
        ,
        REINDENT_EACH_LINE{

            protected ReindentingVisitor createVisitor(IFortranAST ast, Token firstTokenInRegion, Token lastTokenInRegion) {
                return new ReindentEachLineVisitor(ast, firstTokenInRegion, lastTokenInRegion);
            }
        };


        protected abstract ReindentingVisitor createVisitor(IFortranAST var1, Token var2, Token var3);
    }
}

