/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.File;
import java.io.IOException;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.Activator;
import org.eclipse.photran.internal.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPGDB1;
import org.eclipse.photran.internal.core.vpg.PhotranVPGWriter;
import org.eclipse.rephraserengine.core.vpg.IVPGComponentFactory;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.VPGLog;
import org.eclipse.rephraserengine.core.vpg.db.profiling.ProfilingDB;
import org.eclipse.rephraserengine.core.vpg.eclipse.IEclipseVPGComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotranVPGComponentFactory
implements IEclipseVPGComponentFactory<IFortranAST, Token, PhotranTokenRef> {
    public VPGLog<Token, PhotranTokenRef> createLog() {
        File logFile = new File(String.valueOf(Activator.getDefault().getStateLocation().addTrailingSeparator().toOSString()) + "photran70vpg-log.txt");
        return new VPGLog(logFile, (IVPGComponentFactory)this);
    }

    public VPGDB<IFortranAST, Token, PhotranTokenRef> createDatabase(VPGLog<Token, PhotranTokenRef> log) {
        File file;
        File file2 = file = FortranCorePlugin.inTestingMode() ? PhotranVPGComponentFactory.createTempFile() : PhotranVPGComponentFactory.getFileInPluginStateLocation();
        if (FortranPreferences.ENABLE_VPG_LOGGING.getValue()) {
            System.out.println("Using Photran VPG database " + file.getAbsolutePath());
        }
        return new ProfilingDB((VPGDB)new PhotranVPGDB1(this, file, log));
    }

    private static File createTempFile() {
        try {
            File f = File.createTempFile("vpg", null);
            f.deleteOnExit();
            return f;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static File getFileInPluginStateLocation() {
        return new File(String.valueOf(Activator.getDefault().getStateLocation().addTrailingSeparator().toOSString()) + "photran70vpg.new");
    }

    public PhotranVPGWriter createVPGWriter(VPGDB<IFortranAST, Token, PhotranTokenRef> db, VPGLog<Token, PhotranTokenRef> log) {
        return new PhotranVPGWriter(db, log);
    }

    public PhotranTokenRef getVPGNode(String filename, int offset, int length) {
        return new PhotranTokenRef(filename, offset, length);
    }
}

