/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg;

import org.eclipse.rephraserengine.core.vpg.DemandDB;
import org.eclipse.rephraserengine.core.vpg.ILazyVPGPopulator;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.VPGLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VPGWriter<A, T, R extends IVPGNode<T>> {
    protected final VPGDB<A, T, R> db;
    protected final VPGLog<T, R> log;

    protected VPGWriter(VPGDB<A, T, R> db, VPGLog<T, R> log) {
        this.db = db;
        this.log = log;
    }

    public abstract void computeDependencies(String var1);

    protected abstract void populateVPG(String var1, A var2);

    public void computeEdgesAndAnnotations(String filename, A ast) {
        if (this.db instanceof DemandDB) {
            ((DemandDB)this.db).lazyComputationEnabled = false;
        }
        this.db.deleteAllEdgesAndAnnotationsFor(filename);
        this.populateVPG(filename, ast);
        this.db.updateModificationStamp(filename);
        if (this.db instanceof DemandDB) {
            ((DemandDB)this.db).lazyComputationEnabled = true;
        }
    }

    public void computeEdgesAndAnnotationsFromModifiedAST(String filename, A ast) {
        this.computeEdgesAndAnnotations(filename, ast);
    }

    public ILazyVPGPopulator[] getLazyEdgePopulators() {
        return new ILazyVPGPopulator[0];
    }
}

