/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg.db.profiling;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import org.eclipse.rephraserengine.core.util.Pair;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPGDB;
import org.eclipse.rephraserengine.core.vpg.VPGDependency;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilingDB<A, T, R extends IVPGNode<T>>
extends VPGDB<A, T, R> {
    private VPGDB<A, T, R> db;
    private HashMap<String, Integer> methodCalls;
    private HashMap<String, Long> methodTimes;
    private HashMap<String, Long> methodLongestCall;

    public ProfilingDB(VPGDB<A, T, R> diskDatabase) {
        super(diskDatabase);
        this.db = diskDatabase;
        this.methodCalls = new HashMap();
        this.methodTimes = new HashMap();
        this.methodLongestCall = new HashMap();
    }

    private void update(String methodName, long time) {
        if (!this.methodCalls.containsKey(methodName)) {
            this.methodCalls.put(methodName, 1);
            this.methodTimes.put(methodName, time);
            this.methodLongestCall.put(methodName, time);
        } else {
            int oldNumCalls = this.methodCalls.get(methodName);
            this.methodCalls.put(methodName, ++oldNumCalls);
            long oldTotTime = this.methodTimes.get(methodName);
            this.methodTimes.put(methodName, oldTotTime += time);
            if (this.methodLongestCall.get(methodName) < time) {
                this.methodLongestCall.put(methodName, time);
            }
        }
    }

    @Override
    public void flush() {
        long startTime = System.currentTimeMillis();
        this.db.flush();
        long endTime = System.currentTimeMillis();
        this.update("flush", endTime - startTime);
    }

    @Override
    public void close() {
        long startTime = System.currentTimeMillis();
        this.db.close();
        long endTime = System.currentTimeMillis();
        this.update("close", endTime - startTime);
    }

    @Override
    public void clearDatabase() {
        long startTime = System.currentTimeMillis();
        this.db.clearDatabase();
        long endTime = System.currentTimeMillis();
        this.update("clearDatabase", endTime - startTime);
    }

    @Override
    public void enterHypotheticalMode() throws IOException {
        long startTime = System.currentTimeMillis();
        this.db.enterHypotheticalMode();
        long endTime = System.currentTimeMillis();
        this.update("enterHypotheticalMode", endTime - startTime);
    }

    @Override
    public void leaveHypotheticalMode() throws IOException {
        long startTime = System.currentTimeMillis();
        this.db.leaveHypotheticalMode();
        long endTime = System.currentTimeMillis();
        this.update("leaveHypotheticalMode", endTime - startTime);
    }

    @Override
    public boolean isInHypotheticalMode() {
        long startTime = System.currentTimeMillis();
        boolean result = this.db.isInHypotheticalMode();
        long endTime = System.currentTimeMillis();
        this.update("isInHypotheticalMode", endTime - startTime);
        return result;
    }

    @Override
    public void updateModificationStamp(String filename) {
        long startTime = System.currentTimeMillis();
        this.db.updateModificationStamp(filename);
        long endTime = System.currentTimeMillis();
        this.update("updateModificationStamp", endTime - startTime);
    }

    @Override
    public boolean isOutOfDate(String filename) {
        long startTime = System.currentTimeMillis();
        boolean result = this.db.isOutOfDate(filename);
        long endTime = System.currentTimeMillis();
        this.update("isOutOfDate", endTime - startTime);
        return result;
    }

    @Override
    public void deleteAllEntriesFor(String filename) {
        long startTime = System.currentTimeMillis();
        this.db.deleteAllEntriesFor(filename);
        long endTime = System.currentTimeMillis();
        this.update("deleteAllEntriesFor", endTime - startTime);
    }

    @Override
    public void deleteAllEdgesAndAnnotationsFor(String filename) {
        long startTime = System.currentTimeMillis();
        this.db.deleteAllEdgesAndAnnotationsFor(filename);
        long endTime = System.currentTimeMillis();
        this.update("deleteAllEdgesAndAnnotationsFor", endTime - startTime);
    }

    @Override
    public void deleteAllIncomingDependenciesFor(String filename) {
        long startTime = System.currentTimeMillis();
        this.db.deleteAllIncomingDependenciesFor(filename);
        long endTime = System.currentTimeMillis();
        this.update("deleteAllIncomingDependenciesFor", endTime - startTime);
    }

    @Override
    public void deleteAllOutgoingDependenciesFor(String filename) {
        long startTime = System.currentTimeMillis();
        this.db.deleteAllOutgoingDependenciesFor(filename);
        long endTime = System.currentTimeMillis();
        this.update("deleteAllOutgoingDependenciesFor", endTime - startTime);
    }

    @Override
    public Iterable<String> listAllFilenames() {
        long startTime = System.currentTimeMillis();
        Iterable<String> result = this.db.listAllFilenames();
        long endTime = System.currentTimeMillis();
        this.update("listAllFilenames", endTime - startTime);
        return result;
    }

    @Override
    public Iterable<String> listAllFilenamesWithDependents() {
        long startTime = System.currentTimeMillis();
        Iterable<String> result = this.db.listAllFilenamesWithDependents();
        long endTime = System.currentTimeMillis();
        this.update("listAllFilenamesWithDependents", endTime - startTime);
        return result;
    }

    @Override
    public Iterable<String> listAllDependentFilenames() {
        long startTime = System.currentTimeMillis();
        Iterable<String> result = this.db.listAllDependentFilenames();
        long endTime = System.currentTimeMillis();
        this.update("listAllDependentFilenames", endTime - startTime);
        return result;
    }

    @Override
    public void ensure(VPGDependency<A, T, R> dependency) {
        long startTime = System.currentTimeMillis();
        this.db.ensure(dependency);
        long endTime = System.currentTimeMillis();
        this.update("ensure - dependency", endTime - startTime);
    }

    @Override
    public void delete(VPGDependency<A, T, R> dependency) {
        long startTime = System.currentTimeMillis();
        this.db.delete(dependency);
        long endTime = System.currentTimeMillis();
        this.update("delete - dependency", endTime - startTime);
    }

    @Override
    public Iterable<String> getOutgoingDependenciesFrom(String filename) {
        long startTime = System.currentTimeMillis();
        Iterable<String> result = this.db.getOutgoingDependenciesFrom(filename);
        long endTime = System.currentTimeMillis();
        this.update("getOutgoingDependenciesFrom", endTime - startTime);
        return result;
    }

    @Override
    public Iterable<String> getIncomingDependenciesTo(String filename) {
        long startTime = System.currentTimeMillis();
        Iterable<String> result = this.db.getIncomingDependenciesTo(filename);
        long endTime = System.currentTimeMillis();
        this.update("getIncomingDependenciesTo", endTime - startTime);
        return result;
    }

    @Override
    public void ensure(VPGEdge<A, T, R> edge) {
        long startTime = System.currentTimeMillis();
        this.db.ensure(edge);
        long endTime = System.currentTimeMillis();
        this.update("ensure - edge", endTime - startTime);
    }

    @Override
    public void delete(VPGEdge<A, T, R> edge) {
        long startTime = System.currentTimeMillis();
        this.db.delete(edge);
        long endTime = System.currentTimeMillis();
        this.update("delete - edge", endTime - startTime);
    }

    @Override
    public Iterable<? extends VPGEdge<A, T, R>> getAllEdgesFor(String filename) {
        long startTime = System.currentTimeMillis();
        Iterable<VPGEdge<A, T, R>> result = this.db.getAllEdgesFor(filename);
        long endTime = System.currentTimeMillis();
        this.update("getAllEdgesFor", endTime - startTime);
        return result;
    }

    @Override
    public Iterable<Pair<R, Integer>> getAllAnnotationsFor(String filename) {
        long startTime = System.currentTimeMillis();
        Iterable<Pair<R, Integer>> result = this.db.getAllAnnotationsFor(filename);
        long endTime = System.currentTimeMillis();
        this.update("getAllAnnotationsFor", endTime - startTime);
        return result;
    }

    @Override
    public void setAnnotation(R token, int annotationID, Serializable annotation) {
        long startTime = System.currentTimeMillis();
        this.db.setAnnotation(token, annotationID, annotation);
        long endTime = System.currentTimeMillis();
        this.update("setAnnotation", endTime - startTime);
    }

    @Override
    public void deleteAnnotation(R token, int annotationID) {
        long startTime = System.currentTimeMillis();
        this.db.deleteAnnotation(token, annotationID);
        long endTime = System.currentTimeMillis();
        this.update("deleteAnnotation", endTime - startTime);
    }

    @Override
    public void printOn(PrintStream out) {
        this.printStatisticsOn(out);
        out.println();
        this.db.printOn(out);
    }

    @Override
    public void printStatisticsOn(PrintStream out) {
        out.println();
        out.println("Wrapped database is " + this.db.getClass().getName());
        out.println();
        out.println("Additional Statistics: ");
        out.format("%-35s%-20s%-20s%-20s\n", "Method Name", "Times Called", "Average Time (ms)", "Longest Time (ms)");
        for (String aMethod : this.methodCalls.keySet()) {
            int numCalls = this.methodCalls.get(aMethod);
            double avgTime = (double)this.methodTimes.get(aMethod).longValue() / (double)numCalls;
            long longestCall = this.methodLongestCall.get(aMethod);
            out.format("%-35s%-20d%-20.2f%-20d\n", aMethod, numCalls, avgTime, longestCall);
        }
        this.db.printStatisticsOn(out);
    }

    @Override
    public void resetStatistics() {
        this.methodCalls = new HashMap();
        this.methodTimes = new HashMap();
        this.methodLongestCall = new HashMap();
        this.db.resetStatistics();
    }

    @Override
    public Iterable<? extends VPGEdge<A, T, R>> getOutgoingEdgesFrom(R tokenRef, int edgeType) {
        long startTime = System.currentTimeMillis();
        Iterable<VPGEdge<A, T, R>> result = this.db.getOutgoingEdgesFrom(tokenRef, edgeType);
        long endTime = System.currentTimeMillis();
        this.update("getOutgoingEdgesFrom", endTime - startTime);
        return result;
    }

    @Override
    public Iterable<? extends VPGEdge<A, T, R>> getIncomingEdgesTo(R tokenRef, int edgeType) {
        long startTime = System.currentTimeMillis();
        Iterable<VPGEdge<A, T, R>> result = this.db.getIncomingEdgesTo(tokenRef, edgeType);
        long endTime = System.currentTimeMillis();
        this.update("getIncomingEdgesTo", endTime - startTime);
        return result;
    }

    @Override
    public Serializable getAnnotation(R tokenRef, int annotationID) {
        long startTime = System.currentTimeMillis();
        Serializable result = this.db.getAnnotation(tokenRef, annotationID);
        long endTime = System.currentTimeMillis();
        this.update("getAnnotation", endTime - startTime);
        return result;
    }
}

