/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.Util;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IControlFlowGraph;

public class MPISingleAssignAnalysis {
    protected ICallGraph cg_;
    protected IControlFlowGraph cfg_;
    protected MPICallGraphNode currentNode_;
    protected Hashtable<String, Integer> assignNum_;
    protected Hashtable<String, Boolean> type_;
    private static final boolean traceOn = false;

    public MPISingleAssignAnalysis(ICallGraph cg) {
        this.cg_ = cg;
    }

    public void run() {
        ICallGraphNode n = this.cg_.botEntry();
        while (n != null) {
            MPICallGraphNode currentNode_ = (MPICallGraphNode)n;
            this.cfg_ = currentNode_.getCFG();
            this.assignNum_ = currentNode_.getSAVar();
            this.type_ = currentNode_.getSAVarPointer();
            dataCollector dc = new dataCollector();
            dc.run();
            SingleAssignAnalyzer saa = new SingleAssignAnalyzer();
            saa.run();
            Enumeration<String> e = currentNode_.getSAVar().keys();
            while (e.hasMoreElements()) {
                String string = e.nextElement();
            }
            n = n.botNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SingleAssignAnalyzer
    extends ASTVisitor {
        protected final int lhs = 0;
        protected final int rhs = 1;
        protected final int lderef = 2;
        protected final int rderef = 3;

        SingleAssignAnalyzer() {
        }

        public void run() {
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTDeclarationStatement) {
                IASTDeclarationStatement declStmt = (IASTDeclarationStatement)stmt;
                IASTDeclaration decl = declStmt.getDeclaration();
                if (decl instanceof IASTSimpleDeclaration) {
                    IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                    IASTDeclarator[] declarators = simpleDecl.getDeclarators();
                    int i = 0;
                    while (i < declarators.length) {
                        IASTName name = declarators[i].getName();
                        IASTInitializer init = declarators[i].getInitializer();
                        if (init != null) {
                            this.processInitializer(init, name.toString());
                        }
                        ++i;
                    }
                }
                return 1;
            }
            return 3;
        }

        protected void processInitializer(IASTInitializer init, String var) {
            if (init != null) {
                if (init instanceof IASTInitializerExpression) {
                    IASTInitializerExpression initE = (IASTInitializerExpression)init;
                    IASTExpression e = initE.getExpression();
                    ArrayList<String> def = new ArrayList<String>();
                    ArrayList<String> use = new ArrayList<String>();
                    ArrayList<String> ldf = new ArrayList<String>();
                    ArrayList<String> rdf = new ArrayList<String>();
                    boolean value = this.saExpr(e, 1, null, -1, def, use, ldf, rdf);
                    for (String v : use) {
                        int num = MPISingleAssignAnalysis.this.assignNum_.get(v);
                        boolean pointerType = MPISingleAssignAnalysis.this.type_.get(v);
                        if (!pointerType) continue;
                        MPISingleAssignAnalysis.this.assignNum_.put(v, new Integer(num + 2));
                    }
                    boolean pointerType = MPISingleAssignAnalysis.this.type_.get(var);
                    if (pointerType) {
                        if (value) {
                            MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(1));
                        } else {
                            MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(2));
                        }
                    } else {
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(1));
                    }
                } else if (init instanceof IASTInitializerList) {
                    IASTInitializerList list = (IASTInitializerList)init;
                    IASTInitializer[] inits = list.getInitializers();
                    int j = 0;
                    while (j < inits.length) {
                        this.processInitializer(inits[j], var);
                        ++j;
                    }
                } else if (init instanceof ICASTDesignatedInitializer) {
                    System.out.println("ICASTDesignatedInitializer found !");
                }
            }
        }

        public int visit(IASTExpression expr) {
            this.saExpr(expr, 1, null, -1, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());
            return 1;
        }

        protected boolean saExpr(IASTExpression expr, int side, IASTFunctionCallExpression func, int index, List<String> def, List<String> use, List<String> ldf, List<String> rdf) {
            ArrayList<String> d1 = new ArrayList<String>();
            ArrayList<String> d2 = new ArrayList<String>();
            ArrayList<String> d3 = new ArrayList<String>();
            ArrayList<String> u1 = new ArrayList<String>();
            ArrayList<String> u2 = new ArrayList<String>();
            ArrayList<String> u3 = new ArrayList<String>();
            ArrayList<String> lr1 = new ArrayList<String>();
            ArrayList<String> lr2 = new ArrayList<String>();
            ArrayList<String> lr3 = new ArrayList<String>();
            ArrayList<String> rr1 = new ArrayList<String>();
            ArrayList<String> rr2 = new ArrayList<String>();
            ArrayList<String> rr3 = new ArrayList<String>();
            boolean v1 = false;
            boolean v2 = false;
            boolean v3 = false;
            if (expr == null) {
                return false;
            }
            if (expr instanceof IASTArraySubscriptExpression) {
                IASTArraySubscriptExpression asE = (IASTArraySubscriptExpression)expr;
                if (side == 1 || side == 3) {
                    v1 = this.saExpr(asE.getArrayExpression(), 3, func, index, d1, u1, lr1, rr1);
                    v2 = this.saExpr(asE.getSubscriptExpression(), 1, func, index, d2, u2, lr2, rr2);
                } else {
                    v1 = this.saExpr(asE.getArrayExpression(), 2, func, index, d1, u1, lr1, rr1);
                    v2 = this.saExpr(asE.getSubscriptExpression(), 1, func, index, d2, u2, lr2, rr2);
                }
                Util.addAll(def, d1);
                Util.addAll(def, d2);
                Util.addAll(use, u1);
                Util.addAll(use, u2);
                Util.addAll(ldf, lr1);
                Util.addAll(ldf, lr2);
                Util.addAll(rdf, rr1);
                Util.addAll(rdf, rr2);
                return v1 | v2;
            }
            if (expr instanceof IASTBinaryExpression) {
                IASTBinaryExpression biE = (IASTBinaryExpression)expr;
                int op = biE.getOperator();
                if (op == 17) {
                    boolean pointerType;
                    int num;
                    v1 = this.saExpr(biE.getOperand1(), 0, func, index, d1, u1, lr1, rr1);
                    v2 = this.saExpr(biE.getOperand2(), 1, func, index, d2, u2, lr2, rr2);
                    for (String var : d1) {
                        num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                        pointerType = MPISingleAssignAnalysis.this.type_.get(var);
                        if (pointerType) {
                            if (v2) {
                                MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 1));
                                continue;
                            }
                            MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 2));
                            continue;
                        }
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 1));
                    }
                    for (String var : u1) {
                        num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                        pointerType = MPISingleAssignAnalysis.this.type_.get(var);
                        if (!pointerType) continue;
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 2));
                    }
                    for (String var : u2) {
                        num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                        pointerType = MPISingleAssignAnalysis.this.type_.get(var);
                        if (!pointerType) continue;
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 2));
                    }
                } else if (op == 18 || op == 19 || op == 20 || op == 21 || op == 22 || op == 23 || op == 24 || op == 25 || op == 26 || op == 27) {
                    boolean pointerType;
                    int num;
                    v1 = this.saExpr(biE.getOperand1(), 0, func, index, d1, u1, lr1, rr1);
                    v2 = this.saExpr(biE.getOperand1(), 1, func, index, d2, u2, lr2, rr2);
                    v3 = this.saExpr(biE.getOperand2(), 1, func, index, d3, u3, lr2, rr3);
                    for (String var : d1) {
                        num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                        pointerType = MPISingleAssignAnalysis.this.type_.get(var);
                        if (pointerType) {
                            if (v2) {
                                MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 1));
                                continue;
                            }
                            MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 2));
                            continue;
                        }
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 1));
                    }
                    for (String var : u2) {
                        num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                        pointerType = MPISingleAssignAnalysis.this.type_.get(index);
                        if (!pointerType) continue;
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 2));
                    }
                    for (String var : u3) {
                        num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                        pointerType = MPISingleAssignAnalysis.this.type_.get(index);
                        if (!pointerType) continue;
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 2));
                    }
                } else {
                    v1 = this.saExpr(biE.getOperand1(), 1, func, index, d1, u1, lr1, rr1);
                    v2 = this.saExpr(biE.getOperand2(), 1, func, index, d2, u2, lr2, rr2);
                }
                Util.addAll(def, d1);
                Util.addAll(def, d2);
                Util.addAll(def, d3);
                Util.addAll(use, u1);
                Util.addAll(use, u2);
                Util.addAll(use, u3);
                Util.addAll(ldf, lr1);
                Util.addAll(ldf, lr2);
                Util.addAll(ldf, lr3);
                Util.addAll(rdf, rr1);
                Util.addAll(rdf, rr2);
                Util.addAll(rdf, rr3);
                return v1 | v2 | v3;
            }
            if (expr instanceof IASTCastExpression) {
                IASTCastExpression castE = (IASTCastExpression)expr;
                v1 = this.saExpr(castE.getOperand(), side, func, index, d1, u1, lr1, rr1);
                Util.addAll(def, d1);
                Util.addAll(use, u1);
                Util.addAll(ldf, lr1);
                Util.addAll(rdf, rr1);
                return v1;
            }
            if (expr instanceof IASTConditionalExpression) {
                IASTConditionalExpression condE = (IASTConditionalExpression)expr;
                if (side == 1 || side == 3) {
                    v1 = this.saExpr(condE.getLogicalConditionExpression(), side, func, index, d1, u1, lr1, rr1);
                    v2 = this.saExpr(condE.getPositiveResultExpression(), side, func, index, d2, u2, lr2, rr2);
                    v3 = this.saExpr(condE.getNegativeResultExpression(), side, func, index, d3, u3, lr3, rr3);
                } else {
                    v1 = side == 0 ? this.saExpr(condE.getLogicalConditionExpression(), 1, func, index, d1, u1, lr1, rr1) : this.saExpr(condE.getLogicalConditionExpression(), 3, func, index, d1, u1, lr1, rr1);
                    v2 = this.saExpr(condE.getPositiveResultExpression(), side, func, index, d2, u2, lr2, rr2);
                    v3 = this.saExpr(condE.getNegativeResultExpression(), side, func, index, d3, u3, lr3, rr3);
                }
                Util.addAll(def, d1);
                Util.addAll(def, d2);
                Util.addAll(def, d3);
                Util.addAll(use, u1);
                Util.addAll(use, u2);
                Util.addAll(use, u3);
                Util.addAll(ldf, lr1);
                Util.addAll(ldf, lr2);
                Util.addAll(ldf, lr3);
                Util.addAll(rdf, rr1);
                Util.addAll(rdf, rr2);
                Util.addAll(rdf, rr3);
                return v1 | v2 | v3;
            }
            if (expr instanceof IASTExpressionList) {
                IASTExpressionList exprList = (IASTExpressionList)expr;
                IASTExpression[] exprs = exprList.getExpressions();
                int i = 0;
                while (i < exprs.length) {
                    v1 = func != null ? (v1 |= this.saExpr(exprs[i], side, func, i, d1, u1, lr1, rr1)) : (v1 |= this.saExpr(exprs[i], side, func, index, d1, u1, lr1, rr1));
                    Util.addAll(def, d1);
                    Util.addAll(use, u1);
                    Util.addAll(ldf, lr1);
                    Util.addAll(rdf, rr1);
                    ++i;
                }
                return v1;
            }
            if (expr instanceof IASTFieldReference) {
                IASTFieldReference frE = (IASTFieldReference)expr;
                v1 = side == 0 || side == 2 ? this.saExpr(frE.getFieldOwner(), 2, func, index, d1, u1, lr1, rr1) : this.saExpr(frE.getFieldOwner(), 3, func, index, d1, u1, lr1, rr1);
                Util.addAll(def, d1);
                Util.addAll(use, u1);
                Util.addAll(ldf, lr1);
                Util.addAll(rdf, rr1);
                return v1;
            }
            if (expr instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcE = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcE.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                if (signature.equals("malloc") || signature.equals("calloc") || signature.equals("realloc")) {
                    return true;
                }
                IASTExpression paramE = funcE.getParameterExpression();
                if (paramE == null) {
                    return false;
                }
                v1 = paramE instanceof IASTExpressionList ? this.saExpr(paramE, side, funcE, -1, d1, u1, lr1, rr1) : this.saExpr(paramE, side, funcE, 0, d1, u1, lr1, rr1);
                MPICallGraphNode node = (MPICallGraphNode)MPISingleAssignAnalysis.this.cg_.getNode(MPISingleAssignAnalysis.this.currentNode_.getFileName(), signature);
                if (node != null) {
                    for (String gvar : MPISingleAssignAnalysis.this.cg_.getEnv()) {
                        if (u1.contains(gvar) || rr1.contains(gvar)) continue;
                        int fnum = node.getSAVar().get(gvar);
                        int num = MPISingleAssignAnalysis.this.assignNum_.get(gvar);
                        MPISingleAssignAnalysis.this.assignNum_.put(gvar, new Integer(fnum + num));
                    }
                }
                Util.addAll(def, d1);
                Util.addAll(use, u1);
                Util.addAll(ldf, lr1);
                Util.addAll(rdf, rr1);
                return v1;
            }
            if (expr instanceof IASTIdExpression) {
                IASTIdExpression id = (IASTIdExpression)expr;
                IASTName name = id.getName();
                String var = name.toString();
                if (var.startsWith("MPI_")) {
                    return false;
                }
                int fnum = 0;
                if (func != null) {
                    fnum = this.getParamAssignNum(func, index);
                }
                if (side == 1) {
                    if (!use.contains(var)) {
                        use.add(var);
                    }
                    int num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                    MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + fnum));
                } else if (side == 0) {
                    if (!def.contains(var)) {
                        def.add(var);
                    }
                } else if (side == 2) {
                    if (!ldf.contains(var)) {
                        ldf.add(var);
                    }
                } else {
                    if (!rdf.contains(var)) {
                        rdf.add(var);
                    }
                    int num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                    MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + fnum));
                }
                return false;
            }
            if (!(expr instanceof IASTLiteralExpression) && !(expr instanceof IASTProblemExpression) && !(expr instanceof IASTTypeIdExpression) && expr instanceof IASTUnaryExpression) {
                IASTUnaryExpression uE = (IASTUnaryExpression)expr;
                int op = uE.getOperator();
                if (op == 0 || op == 1 || op == 9 || op == 10) {
                    boolean pointerType;
                    int num;
                    v1 = this.saExpr(uE.getOperand(), 1, func, index, d1, u1, lr1, rr1);
                    v2 = this.saExpr(uE.getOperand(), 0, func, index, d2, u2, lr2, rr2);
                    for (String var : d1) {
                        num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                        pointerType = MPISingleAssignAnalysis.this.type_.get(var);
                        if (pointerType) {
                            if (v2) {
                                MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 1));
                                continue;
                            }
                            MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 2));
                            continue;
                        }
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 1));
                    }
                    for (String var : u1) {
                        num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                        pointerType = MPISingleAssignAnalysis.this.type_.get(var);
                        if (!pointerType) continue;
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 2));
                    }
                    for (String var : u2) {
                        num = MPISingleAssignAnalysis.this.assignNum_.get(var);
                        pointerType = MPISingleAssignAnalysis.this.type_.get(var);
                        if (!pointerType) continue;
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(num + 2));
                    }
                    Util.addAll(def, d1);
                    Util.addAll(def, d2);
                    Util.addAll(use, u1);
                    Util.addAll(use, u2);
                    Util.addAll(ldf, lr1);
                    Util.addAll(ldf, lr2);
                    Util.addAll(rdf, rr1);
                    Util.addAll(rdf, rr2);
                } else {
                    v1 = this.saExpr(uE.getOperand(), side, func, index, d1, u1, lr1, rr1);
                    Util.addAll(def, d1);
                    Util.addAll(use, u1);
                    Util.addAll(ldf, lr1);
                    Util.addAll(rdf, rr1);
                }
                return v1 | v2;
            }
            return false;
        }

        protected int getParamAssignNum(IASTFunctionCallExpression fE, int index) {
            IType type;
            IASTExpressionList paramEList;
            IASTExpression param;
            IType type2;
            if (index == -1) {
                return 0;
            }
            IASTExpression funcname = fE.getFunctionNameExpression();
            String signature = funcname.getRawSignature();
            MPICallGraphNode node = (MPICallGraphNode)MPISingleAssignAnalysis.this.cg_.getNode(MPISingleAssignAnalysis.this.currentNode_.getFileName(), signature);
            if (node != null) {
                Hashtable<String, Integer> funcAssignNum = node.getSAVar();
                IASTFunctionDefinition fdef = node.getFuncDef();
                IASTFunctionDeclarator fdecl = fdef.getDeclarator();
                if (fdecl instanceof IASTStandardFunctionDeclarator) {
                    IASTStandardFunctionDeclarator sfunc = (IASTStandardFunctionDeclarator)fdecl;
                    IASTParameterDeclaration[] params = sfunc.getParameters();
                    if (params.length <= index) {
                        return 0;
                    }
                    IASTName param2 = params[index].getDeclarator().getName();
                    return funcAssignNum.get(param2.toString());
                }
                ICASTKnRFunctionDeclarator krfunc = (ICASTKnRFunctionDeclarator)fdecl;
                IASTName[] params = krfunc.getParameterNames();
                if (params.length <= index) {
                    return 0;
                }
                IASTName param3 = params[index];
                return funcAssignNum.get(param3.toString());
            }
            IASTExpression parameterE = fE.getParameterExpression();
            if (parameterE instanceof IASTExpressionList ? (type2 = (param = (paramEList = (IASTExpressionList)parameterE).getExpressions()[index]).getExpressionType()) instanceof IArrayType || type2 instanceof IPointerType : (type = parameterE.getExpressionType()) instanceof IArrayType || type instanceof IPointerType) {
                return 2;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class dataCollector
    extends ASTVisitor {
        dataCollector() {
        }

        public void run() {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            int i = 0;
            while (i < MPISingleAssignAnalysis.this.cg_.getEnv().size()) {
                String var = (String)MPISingleAssignAnalysis.this.cg_.getEnv().get(i);
                MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(0));
                MPISingleAssignAnalysis.this.type_.put(var, ((MPICallGraph)MPISingleAssignAnalysis.this.cg_).getGVPointer().get(i));
                ++i;
            }
            ArrayList<String> parameters = new ArrayList<String>();
            ArrayList<Boolean> pointers = new ArrayList<Boolean>();
            this.getParameters(MPISingleAssignAnalysis.this.currentNode_.getFuncDef(), parameters, pointers);
            int i2 = 0;
            while (i2 < parameters.size()) {
                String var = (String)parameters.get(i2);
                MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(0));
                MPISingleAssignAnalysis.this.type_.put(var, (Boolean)pointers.get(i2));
                ++i2;
            }
            MPISingleAssignAnalysis.this.currentNode_.getFuncDef().accept((ASTVisitor)this);
        }

        protected void getParameters(IASTFunctionDefinition fd, List<String> paramList, List<Boolean> pointerList) {
            IASTFunctionDeclarator fdecl = fd.getDeclarator();
            if (fdecl instanceof IASTStandardFunctionDeclarator) {
                IASTStandardFunctionDeclarator sfunc = (IASTStandardFunctionDeclarator)fdecl;
                IASTParameterDeclaration[] params = sfunc.getParameters();
                int i = 0;
                while (i < params.length) {
                    paramList.add(params[i].getDeclarator().getName().toString());
                    IASTPointerOperator[] pops = params[i].getDeclarator().getPointerOperators();
                    if (pops != IASTPointerOperator.EMPTY_ARRAY) {
                        pointerList.add(new Boolean(true));
                    } else {
                        pointerList.add(new Boolean(false));
                    }
                    ++i;
                }
            } else {
                ICASTKnRFunctionDeclarator krfunc = (ICASTKnRFunctionDeclarator)fdecl;
                IASTName[] params = krfunc.getParameterNames();
                int i = 0;
                while (i < params.length) {
                    paramList.add(params[i].toString());
                    IASTDeclarator decl = krfunc.getDeclaratorForParameterName(params[i]);
                    if (decl.getPointerOperators() != IASTPointerOperator.EMPTY_ARRAY) {
                        pointerList.add(new Boolean(true));
                    } else {
                        pointerList.add(new Boolean(false));
                    }
                    ++i;
                }
            }
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTDeclarationStatement) {
                IASTDeclarationStatement declStmt = (IASTDeclarationStatement)stmt;
                IASTDeclaration decl = declStmt.getDeclaration();
                if (decl instanceof IASTSimpleDeclaration) {
                    IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                    IASTDeclarator[] declarators = simpleDecl.getDeclarators();
                    int i = 0;
                    while (i < declarators.length) {
                        String var = declarators[i].getName().toString();
                        MPISingleAssignAnalysis.this.assignNum_.put(var, new Integer(0));
                        if (declarators[i].getPointerOperators() != IASTPointerOperator.EMPTY_ARRAY) {
                            MPISingleAssignAnalysis.this.type_.put(var, new Boolean(true));
                        } else {
                            MPISingleAssignAnalysis.this.type_.put(var, new Boolean(false));
                        }
                        ++i;
                    }
                }
                return 1;
            }
            return 3;
        }
    }
}

