/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchIntegration;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchObserver;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchProcess;
import org.eclipse.ptp.remotetools.environment.launcher.data.ExecutionConfiguration;
import org.eclipse.ptp.remotetools.environment.launcher.internal.LaunchObserverIterator;
import org.eclipse.ptp.remotetools.environment.launcher.internal.RemoteLaunchProcess;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RemoteLauncherPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.remotetools.environment.launcher";
    public static final String OBERVER_EXTENSION_ID = "org.eclipse.ptp.remotetools.environment.launcher.observer";
    private static RemoteLauncherPlugin plugin;

    public RemoteLauncherPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static RemoteLauncherPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (RemoteLauncherPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return RemoteLauncherPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static LaunchObserverIterator getLaunchObserverIterator() {
        return new LaunchObserverIterator();
    }

    public static ILaunchObserver getLaunchObserverByID(String id) {
        if (id == null) {
            return null;
        }
        LaunchObserverIterator iterator = RemoteLauncherPlugin.getLaunchObserverIterator();
        while (iterator.hasMoreElements()) {
            iterator.nextElement();
            if (!iterator.getName().equals(id)) continue;
            return iterator.getInstance();
        }
        return null;
    }

    public static void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, PLUGIN_ID, 0, message, null);
        CoreException exception = new CoreException((IStatus)status);
        throw exception;
    }

    public static void throwCoreException(String message, int errorCode) throws CoreException {
        Status status = new Status(4, PLUGIN_ID, errorCode, message, null);
        CoreException exception = new CoreException((IStatus)status);
        throw exception;
    }

    public static ILaunchProcess createRemoteLaunchProcess(ILaunch launch, ExecutionConfiguration configuration, ILaunchIntegration launchIntegration) {
        return new RemoteLaunchProcess(launch, configuration, launchIntegration);
    }

    public static void throwCoreException(String message, RemoteConnectionException e) throws CoreException {
        Status status = new Status(4, PLUGIN_ID, 0, message, (Throwable)e);
        CoreException exception = new CoreException((IStatus)status);
        throw exception;
    }

    public static void log(IStatus status) {
        RemoteLauncherPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        RemoteLauncherPlugin.log((IStatus)new Status(4, RemoteLauncherPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        RemoteLauncherPlugin.log((IStatus)new Status(4, RemoteLauncherPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }
}

