/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.ui;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remotetools.environment.launcher.core.LinuxPath;
import org.eclipse.ptp.remotetools.environment.launcher.data.DownloadRule;
import org.eclipse.ptp.remotetools.environment.launcher.data.UploadRule;
import org.eclipse.ptp.remotetools.environment.launcher.messages.Messages;
import org.eclipse.swt.graphics.Image;

class SynchronizationRuleLabelProvider
implements ILabelProvider {
    Image uploadRuleImage = null;
    Image downloadRuleImage = null;
    String remoteWorkingDir;

    public String getRemoteWorkingDir() {
        return this.remoteWorkingDir;
    }

    public void setRemoteWorkingDir(String remoteWorkingDir) {
        this.remoteWorkingDir = remoteWorkingDir;
    }

    public Image getImage(Object element) {
        if (element instanceof DownloadRule) {
            return this.downloadRuleImage;
        }
        if (element instanceof DownloadRule) {
            return this.uploadRuleImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof DownloadRule) {
            DownloadRule rule = (DownloadRule)element;
            String result = Messages.EnhancedSynchronizeTab_DownloadLabel_Type;
            result = rule.getRemoteFileCount() == 0 ? String.valueOf(result) + Messages.EnhancedSynchronizeTab_DownloadLabel_NoFiles : (rule.getRemoteFileCount() == 1 ? String.valueOf(result) + Messages.EnhancedSynchronizeTab_DownloadLabel_OneFile : String.valueOf(result) + NLS.bind((String)Messages.EnhancedSynchronizeTab_DownloadLabel_MultipleFiles, (Object)new Integer(rule.getRemoteFileCount())));
            if (rule.getRemoteFileCount() >= 1) {
                result = String.valueOf(result) + '\n' + Messages.EnhancedSynchronizeTab_DownloadLabel_FromLabel;
                String[] files = rule.getRemoteFilesAsStringArray();
                int i = 0;
                while (i < files.length) {
                    String file = files[i];
                    if (i != 0) {
                        file = String.valueOf(file) + Messages.EnhancedSynchronizeTab_DownloadLabel_FileListSeparator;
                    }
                    result = String.valueOf(result) + file;
                    ++i;
                }
                result = String.valueOf(result) + '\n';
                result = rule.getLocalDirectory() == null ? String.valueOf(result) + Messages.EnhancedSynchronizeTab_DownloadLabel_DestinationMissing : String.valueOf(result) + Messages.EnhancedSynchronizeTab_DownloadLabel_DestinationLabel + rule.getLocalDirectory();
                if (rule.isAsExecutable() || rule.isAsReadOnly() || rule.isPreserveTimeStamp()) {
                    result = String.valueOf(result) + '\n' + Messages.EnhancedSynchronizeTab_DownloadLabel_OptionsLabel;
                    boolean comma = false;
                    if (rule.isAsExecutable()) {
                        if (comma) {
                            result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_DownloadLabel_OptionsSeparator;
                        } else {
                            comma = true;
                        }
                        result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_DownloadLabel_Options_Executable;
                    }
                    if (rule.isAsReadOnly()) {
                        if (comma) {
                            result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_DownloadLabel_OptionsSeparator;
                        } else {
                            comma = true;
                        }
                        result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_DownloadLabel_Options_Readonly;
                    }
                    if (rule.isPreserveTimeStamp()) {
                        if (comma) {
                            result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_DownloadLabel_OptionsSeparator;
                        } else {
                            comma = true;
                        }
                        result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_DownloadLabel_Options_PreserveTimeStamp;
                    }
                }
            }
            return result;
        }
        if (element instanceof UploadRule) {
            UploadRule rule = (UploadRule)element;
            String result = Messages.EnhancedSynchronizeTab_UploadLabel_Type;
            result = rule.getRemoteFileCount() == 0 ? String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_NoFiles : (rule.getRemoteFileCount() == 1 ? String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_OneFile : String.valueOf(result) + NLS.bind((String)Messages.EnhancedSynchronizeTab_UploadLabel_MultipleFiles, (Object)new Integer(rule.getRemoteFileCount())));
            if (rule.getRemoteFileCount() >= 1) {
                result = String.valueOf(result) + '\n' + Messages.EnhancedSynchronizeTab_UploadLabel_FromLabel;
                String[] files = rule.getLocalFilesAsStringArray();
                int i = 0;
                while (i < files.length) {
                    String file = files[i];
                    if (i != 0) {
                        file = String.valueOf(file) + Messages.EnhancedSynchronizeTab_UploadLabel_FileListSeparator;
                    }
                    result = String.valueOf(result) + file;
                    ++i;
                }
                result = String.valueOf(result) + '\n';
                if (rule.getRemoteDirectory() == null || rule.isDefaultRemoteDirectory()) {
                    result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_DestinationLabel + this.remoteWorkingDir;
                } else {
                    Path remoteWorkingPath = new Path(this.remoteWorkingDir);
                    Path remotePath = new Path(rule.getRemoteDirectory());
                    if (!remotePath.isAbsolute()) {
                        remotePath = remoteWorkingPath.append((IPath)remotePath);
                    }
                    result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_DestinationLabel + LinuxPath.toString((IPath)remotePath);
                }
                if (rule.isAsExecutable() || rule.isAsReadOnly() || rule.isPreserveTimeStamp() || rule.isDownloadBack()) {
                    result = String.valueOf(result) + '\n' + Messages.EnhancedSynchronizeTab_UploadLabel_OptionsLabel;
                    boolean comma = false;
                    if (rule.isAsExecutable()) {
                        if (comma) {
                            result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_DestinationSeparator;
                        } else {
                            comma = true;
                        }
                        result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_Options_Executable;
                    }
                    if (rule.isAsReadOnly()) {
                        if (comma) {
                            result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_DestinationSeparator;
                        } else {
                            comma = true;
                        }
                        result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_Options_Readonly;
                    }
                    if (rule.isPreserveTimeStamp()) {
                        if (comma) {
                            result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_DestinationSeparator;
                        } else {
                            comma = true;
                        }
                        result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_Options_PreserveTimeStamp;
                    }
                    if (rule.isDownloadBack()) {
                        if (comma) {
                            result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_DestinationSeparator;
                        } else {
                            comma = true;
                        }
                        result = String.valueOf(result) + Messages.EnhancedSynchronizeTab_UploadLabel_Options_DownloadBack;
                    }
                }
            }
            return result;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.uploadRuleImage != null) {
            this.uploadRuleImage.dispose();
        }
        if (this.downloadRuleImage != null) {
            this.downloadRuleImage.dispose();
        }
        this.uploadRuleImage = null;
        this.downloadRuleImage = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

