/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.subsystems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.swt.widgets.Display;

public class StatusMonitor
implements IDomainListener,
IRemoteConnectionChangeListener {
    private static Map<IRemoteConnection, StatusMonitor> fMonitors = new HashMap<IRemoteConnection, StatusMonitor>();
    protected IRemoteConnection fRemoteConnection;
    protected boolean fNetworkDown = false;
    protected List<DataElement> fWorkingStatuses = new ArrayList<DataElement>();
    protected List<DataElement> fCancelledStatuses = new ArrayList<DataElement>();
    protected List<DataElement> fDoneStatuses = new ArrayList<DataElement>();
    protected DataStore fDataStore;

    public static StatusMonitor getStatusMonitorFor(IRemoteConnection connection, DataStore store) {
        StatusMonitor monitor = fMonitors.get(connection);
        if (monitor == null) {
            monitor = new StatusMonitor(connection, store);
            fMonitors.put(connection, monitor);
        }
        return monitor;
    }

    public StatusMonitor(IRemoteConnection connection, DataStore dataStore) {
        this.fRemoteConnection = connection;
        this.fDataStore = dataStore;
        this.reInit();
    }

    public void connectionChanged(IRemoteConnectionChangeEvent e) {
        if (e.getType() == 1 || e.getType() == 4) {
            this.fNetworkDown = true;
        }
    }

    public void dispose() {
        this.fRemoteConnection.removeConnectionChangeListener((IRemoteConnectionChangeListener)this);
        this.fWorkingStatuses.clear();
        this.fDoneStatuses.clear();
        this.fCancelledStatuses.clear();
        this.fDataStore.getDomainNotifier().removeDomainListener((IDomainListener)this);
    }

    public void domainChanged(DomainEvent event) {
        boolean isStatusDone;
        if (this.fWorkingStatuses.size() == 0) {
            return;
        }
        DataElement parent = (DataElement)event.getParent();
        if (this.fWorkingStatuses.contains(parent) && (isStatusDone = this.determineStatusDone(parent))) {
            this.setDone(parent);
        }
    }

    public DataStore getDataStore() {
        return this.fDataStore;
    }

    public boolean isNetworkDown() {
        return this.fNetworkDown;
    }

    public boolean listeningTo(DomainEvent event) {
        if (this.fWorkingStatuses.size() == 0) {
            return true;
        }
        DataElement parent = (DataElement)event.getParent();
        if (this.fWorkingStatuses.contains(parent)) {
            return this.determineStatusDone(parent);
        }
        return false;
    }

    public void reInit() {
        this.fNetworkDown = false;
        this.fRemoteConnection.addConnectionChangeListener((IRemoteConnectionChangeListener)this);
        this.fWorkingStatuses.clear();
        this.fDoneStatuses.clear();
        this.fCancelledStatuses.clear();
        this.fDataStore.getDomainNotifier().addDomainListener((IDomainListener)this);
    }

    public synchronized void setCancelled(DataElement status) {
        this.fWorkingStatuses.remove(status);
        this.fCancelledStatuses.add(status);
    }

    public synchronized void setDone(DataElement status) {
        this.fWorkingStatuses.remove(status);
        this.fDoneStatuses.add(status);
    }

    public synchronized void setWorking(DataElement status) {
        this.fWorkingStatuses.add(status);
    }

    public DataElement waitForUpdate(DataElement status) throws InterruptedException {
        return this.waitForUpdate(status, null, 0);
    }

    public DataElement waitForUpdate(DataElement status, int wait) throws InterruptedException {
        return this.waitForUpdate(status, null, wait);
    }

    public DataElement waitForUpdate(DataElement status, IProgressMonitor monitor) throws InterruptedException {
        return this.waitForUpdate(status, monitor, 0);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized DataElement waitForUpdate(DataElement status, IProgressMonitor monitor, int wait) throws InterruptedException {
        block21: {
            if (this.fNetworkDown && status.getDataStore().isConnected()) {
                this.reInit();
            }
            if (this.determineStatusDone(status)) {
                this.setDone(status);
                return status;
            }
            this.setWorking(status);
            display = Display.getCurrent();
            WaitThreshold = 50;
            if (wait > 0) {
                WaitThreshold = wait * 10;
            } else if (wait == -1) {
                WaitThreshold = -1;
            }
            initialWaitThreshold = WaitThreshold;
            nudges = 0;
            if (display == null) ** GOTO lbl67
            while (this.fWorkingStatuses.contains(status)) {
                if (monitor != null && monitor.isCanceled()) {
                    this.setCancelled(status);
                    throw new InterruptedException();
                }
                statusDone = this.determineStatusDone(status);
                if (statusDone) {
                    this.setDone(status);
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException v0) {
                    continue;
                }
                if (WaitThreshold > 0) {
                    --WaitThreshold;
                }
                if (WaitThreshold == 0) {
                    this.wakeupServer(status);
                    if (nudges >= 12) {
                        return status;
                    }
                    ++nudges;
                    WaitThreshold = initialWaitThreshold;
                    continue;
                }
                if (!this.fNetworkDown && this.fDataStore.isConnected()) continue;
                this.dispose();
                throw new InterruptedException();
            }
            break block21;
lbl-1000:
            // 1 sources

            {
                if (monitor != null && monitor.isCanceled()) {
                    this.setCancelled(status);
                    throw new InterruptedException();
                }
                statusDone = this.determineStatusDone(status);
                if (statusDone) {
                    this.setDone(status);
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException v1) {
                    continue;
                }
                if (WaitThreshold > 0) {
                    --WaitThreshold;
                }
                if (WaitThreshold == 0) {
                    this.wakeupServer(status);
                    if (nudges >= 12) {
                        return status;
                    }
                    ++nudges;
                    WaitThreshold = initialWaitThreshold;
                    continue;
                }
                if (!this.fNetworkDown) continue;
                this.dispose();
                throw new InterruptedException();
lbl67:
                // 5 sources

                ** while (this.fWorkingStatuses.contains((Object)status))
            }
        }
        return status;
    }

    public boolean wasCancelled(DataElement status) {
        return this.fCancelledStatuses.contains(status);
    }

    private void wakeupServer(DataElement status) {
        if (status != null) {
            DataElement cmdDescriptor = this.fDataStore.findCommandDescriptor("C_NOTIFICATION");
            DataElement subject = status.getParent().get(0);
            if (cmdDescriptor != null) {
                this.fDataStore.command(cmdDescriptor, subject);
            }
        }
    }

    protected boolean determineStatusDone(DataElement status) {
        return status.getAttribute(3).equals("done") || status.getAttribute(2).equals("done");
    }
}

