/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.ptp.rm.jaxb.core.data.FontType;
import org.eclipse.ptp.rm.jaxb.ui.JAXBUIConstants;
import org.eclipse.ptp.utils.ui.swt.SWTUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class WidgetBuilderUtils {
    private static final FontRegistry fonts = new FontRegistry();

    public static void applyMonospace(Text text) {
        FontType fd = new FontType();
        fd.setName("Courier");
        fd.setSize(Integer.valueOf(14));
        fd.setStyle("SWT.NORMAL");
        Font font = WidgetBuilderUtils.getFont(fd);
        if (font != null) {
            text.setFont(font);
            Dialog.applyDialogFont((Control)text);
        }
    }

    public static Button createButton(Composite parent, Object layoutData, String label, Integer style, SelectionListener listener) {
        Button button = new Button(parent, style.intValue());
        if (label != null) {
            button.setText(label);
        }
        button.setLayoutData(layoutData);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public static Button createButton(Composite parent, String label, Integer style) {
        return WidgetBuilderUtils.createButton(parent, null, label, style, null);
    }

    public static Button createButton(Composite parent, String label, Integer style, SelectionListener listener) {
        return WidgetBuilderUtils.createButton(parent, null, label, style, listener);
    }

    public static Button createCheckButton(Composite parent, String label, SelectionListener listener) {
        return WidgetBuilderUtils.createButton(parent, label, 32, listener);
    }

    public static Combo createCombo(Composite parent, Integer style, Object data, String[] items, String initialValue, String label, String tooltip, Object listener) {
        if (label != null) {
            Label comboLabel = WidgetBuilderUtils.createLabel(parent, label, (Integer)131072, 1);
            if (tooltip != null) {
                comboLabel.setToolTipText(tooltip);
            }
        }
        Combo combo = new Combo(parent, style.intValue());
        if (items != null) {
            combo.setItems(items);
        }
        combo.setLayoutData(data);
        if (initialValue != null) {
            combo.setText(initialValue);
        }
        if (listener != null) {
            if (listener instanceof ModifyListener) {
                combo.addModifyListener((ModifyListener)listener);
            } else if (listener instanceof SelectionListener) {
                combo.addSelectionListener((SelectionListener)listener);
            }
        }
        return combo;
    }

    public static Composite createComposite(Composite parent, Integer columns) {
        GridLayout layout = WidgetBuilderUtils.createGridLayout(columns, false, -1, -1, -1, -1);
        return WidgetBuilderUtils.createComposite(parent, 0, (Layout)layout, null);
    }

    public static Composite createComposite(Composite parent, Integer style, Layout layout, Object layoutData) {
        Composite composite = new Composite(parent, style.intValue());
        composite.setLayout(layout);
        composite.setLayoutData(layoutData);
        return composite;
    }

    public static FillLayout createFillLayout(String type, Integer height, Integer width, Integer spacing) {
        FillLayout layout = new FillLayout();
        if (type != null) {
            layout.type = WidgetBuilderUtils.getStyle(type);
        }
        if (height != null) {
            layout.marginHeight = height;
        }
        if (width != null) {
            layout.marginWidth = width;
        }
        if (spacing != null) {
            layout.spacing = spacing;
        }
        return layout;
    }

    public static FormAttachment createFormAttachment(String align, Integer denominator, Integer numerator, Integer offset) {
        FormAttachment fa = new FormAttachment();
        if (align != null) {
            fa.alignment = WidgetBuilderUtils.getStyle(align);
        }
        if (denominator != null) {
            fa.denominator = denominator;
        }
        if (numerator != null) {
            fa.numerator = numerator;
        }
        if (offset != null) {
            fa.offset = offset;
        }
        return fa;
    }

    public static FormData createFormData(Integer height, Integer width, FormAttachment top, FormAttachment bottom, FormAttachment left, FormAttachment right) {
        FormData data = new FormData();
        if (height != null) {
            data.height = height;
        }
        if (width != null) {
            data.width = width;
        }
        if (top != null) {
            data.top = top;
        }
        if (bottom != null) {
            data.bottom = bottom;
        }
        if (left != null) {
            data.left = left;
        }
        if (right != null) {
            data.right = right;
        }
        return data;
    }

    public static FormLayout createFormLayout(Integer height, Integer width, Integer top, Integer bottom, Integer left, Integer right, Integer spacing) {
        FormLayout layout = new FormLayout();
        if (height != null) {
            layout.marginHeight = height;
        }
        if (width != null) {
            layout.marginWidth = width;
        }
        if (top != null) {
            layout.marginTop = top;
        }
        if (bottom != null) {
            layout.marginBottom = bottom;
        }
        if (left != null) {
            layout.marginLeft = left;
        }
        if (right != null) {
            layout.marginRight = right;
        }
        if (spacing != null) {
            layout.spacing = spacing;
        }
        return layout;
    }

    public static GridData createGridData(Integer style, Boolean grabExcessHorizontal, Boolean grabExcessVertical, Integer widthHint, Integer heightHint, Integer horizontalSpan, Integer verticalSpan) {
        new GridData();
        return WidgetBuilderUtils.createGridData(style, grabExcessHorizontal, grabExcessVertical, widthHint, heightHint, -1, -1, horizontalSpan, verticalSpan, -1, -1, -1, -1);
    }

    public static GridData createGridData(Integer style, Boolean grabExcessHorizontal, Boolean grabExcessVertical, Integer widthHint, Integer heightHint, Integer minimumWidth, Integer minimumHeight, Integer horizontalSpan, Integer verticalSpan, Integer horizonalAlign, Integer verticalAlign, Integer horizontalIndent, Integer verticalIndent) {
        GridData data = null;
        data = style != null ? (style == -1 ? new GridData() : new GridData(style.intValue())) : new GridData();
        if (grabExcessHorizontal != null) {
            data.grabExcessHorizontalSpace = grabExcessHorizontal;
        }
        if (grabExcessVertical != null) {
            data.grabExcessVerticalSpace = grabExcessVertical;
        }
        if (widthHint != null && widthHint != -1) {
            data.widthHint = widthHint;
        }
        if (heightHint != null && heightHint != -1) {
            data.heightHint = heightHint;
        }
        if (minimumWidth != null && minimumWidth != -1) {
            data.minimumWidth = minimumWidth;
        }
        if (minimumHeight != null && minimumHeight != -1) {
            data.minimumHeight = minimumHeight;
        }
        if (horizontalSpan != null && horizontalSpan != -1) {
            data.horizontalSpan = horizontalSpan;
        }
        if (verticalSpan != null && verticalSpan != -1) {
            data.verticalSpan = verticalSpan;
        }
        if (horizonalAlign != null && horizonalAlign != -1) {
            data.horizontalAlignment = horizonalAlign;
        }
        if (verticalAlign != null && verticalAlign != -1) {
            data.verticalAlignment = verticalAlign;
        }
        if (horizontalIndent != null && horizontalIndent != -1) {
            data.horizontalIndent = horizontalIndent;
        }
        if (verticalIndent != null && verticalIndent != -1) {
            data.verticalIndent = verticalIndent;
        }
        return data;
    }

    public static GridData createGridData(Integer style, Integer cols) {
        return WidgetBuilderUtils.createGridData(style, false, false, -1, -1, cols, -1);
    }

    public static GridData createGridDataFill(Integer widthHint, Integer heightHint, Integer cols) {
        return WidgetBuilderUtils.createGridData(1808, true, true, widthHint, heightHint, cols, -1);
    }

    public static GridData createGridDataFillH(Integer cols) {
        return WidgetBuilderUtils.createGridData(768, true, false, -1, -1, cols, -1);
    }

    public static GridLayout createGridLayout(Integer columns, Boolean makeColumnsEqualWidth) {
        return WidgetBuilderUtils.createGridLayout(columns, makeColumnsEqualWidth, -1, -1, -1, -1);
    }

    public static GridLayout createGridLayout(Integer columns, Boolean makeColumnsEqualWidth, Integer horizontalSpacing, Integer verticalSpacing, Integer marginWidth, Integer marginHeight) {
        return WidgetBuilderUtils.createGridLayout(columns, makeColumnsEqualWidth, horizontalSpacing, verticalSpacing, marginWidth, marginHeight, -1, -1, -1, -1);
    }

    public static GridLayout createGridLayout(Integer columns, Boolean makeColumnsEqualWidth, Integer horizontalSpacing, Integer verticalSpacing, Integer marginWidth, Integer marginHeight, Integer marginLeft, Integer marginRight, Integer marginTop, Integer marginBottom) {
        GridLayout gridLayout = new GridLayout();
        if (columns != null) {
            gridLayout.numColumns = columns;
        }
        if (makeColumnsEqualWidth != null) {
            gridLayout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        }
        if (horizontalSpacing != null && horizontalSpacing != -1) {
            gridLayout.horizontalSpacing = horizontalSpacing;
        }
        if (verticalSpacing != null && verticalSpacing != -1) {
            gridLayout.verticalSpacing = verticalSpacing;
        }
        if (marginWidth != null && marginWidth != -1) {
            gridLayout.marginWidth = marginWidth;
        }
        if (marginHeight != null && marginHeight != -1) {
            gridLayout.marginHeight = marginHeight;
        }
        if (marginLeft != null && marginLeft != -1) {
            gridLayout.marginLeft = marginLeft;
        }
        if (marginRight != null && marginRight != -1) {
            gridLayout.marginRight = marginRight;
        }
        if (marginTop != null && marginTop != -1) {
            gridLayout.marginTop = marginTop;
        }
        if (marginBottom != null && marginBottom != -1) {
            gridLayout.marginBottom = marginBottom;
        }
        return gridLayout;
    }

    public static Group createGroup(Composite parent, Integer style, Layout layout, Object layoutData) {
        return WidgetBuilderUtils.createGroup(parent, style, layout, layoutData, null);
    }

    public static Group createGroup(Composite parent, Integer style, Layout layout, Object layoutData, String text) {
        Group group = new Group(parent, style.intValue());
        group.setLayout(layout);
        group.setLayoutData(layoutData);
        if (text != null) {
            group.setText(text);
        }
        return group;
    }

    public static Label createLabel(Composite container, String text, Integer style, Integer columnSpan) {
        GridData data = WidgetBuilderUtils.createGridData(-1, columnSpan);
        return WidgetBuilderUtils.createLabel(container, text, style, data);
    }

    public static Label createLabel(Composite container, String text, Integer style, Object layoutData) {
        Label label = new Label(container, style.intValue());
        if (text == null) {
            text = "";
        }
        label.setText(text.trim());
        label.setLayoutData(layoutData);
        return label;
    }

    public static Button createPushButton(Composite parent, String label, SelectionListener listener) {
        Button button = SWTUtil.createPushButton((Composite)parent, (String)label, null);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        button.setLayoutData((Object)gd);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public static RowData createRowData(Integer height, Integer width, Boolean exclude) {
        RowData data = new RowData();
        if (height != null) {
            data.height = height;
        }
        if (width != null) {
            data.width = width;
        }
        if (exclude != null) {
            data.exclude = exclude;
        }
        return data;
    }

    public static RowLayout createRowLayout(String type, Boolean center, Boolean fill, Boolean justify, Boolean pack, Boolean wrap, Integer marginHeight, Integer marginWidth, Integer marginTop, Integer marginBottom, Integer marginLeft, Integer marginRight, Integer spacing) {
        RowLayout layout = new RowLayout();
        if (type != null) {
            layout.type = WidgetBuilderUtils.getStyle(type);
        }
        if (center != null) {
            layout.center = center;
        }
        if (fill != null) {
            layout.fill = fill;
        }
        if (justify != null) {
            layout.justify = justify;
        }
        if (pack != null) {
            layout.pack = pack;
        }
        if (wrap != null) {
            layout.wrap = wrap;
        }
        if (marginHeight != null) {
            layout.marginHeight = marginHeight;
        }
        if (marginWidth != null) {
            layout.marginWidth = marginWidth;
        }
        if (marginTop != null) {
            layout.marginTop = marginTop;
        }
        if (marginBottom != null) {
            layout.marginBottom = marginBottom;
        }
        if (marginLeft != null) {
            layout.marginLeft = marginLeft;
        }
        if (marginRight != null) {
            layout.marginRight = marginRight;
        }
        if (spacing != null) {
            layout.spacing = spacing;
        }
        return layout;
    }

    public static Spinner createSpinner(Composite parent, int style, Object layoutData, String label, Integer minimum, Integer maximum, Integer initialValue, ModifyListener listener) {
        if (label != null) {
            WidgetBuilderUtils.createLabel(parent, label, (Integer)0, 1);
        }
        Spinner s = new Spinner(parent, style);
        if (maximum != null) {
            s.setMaximum(maximum.intValue());
        }
        if (minimum != null) {
            s.setMinimum(minimum.intValue());
        }
        if (initialValue != null) {
            s.setSelection(initialValue.intValue());
        }
        s.setLayoutData(layoutData);
        if (listener != null) {
            s.addModifyListener(listener);
        }
        return s;
    }

    public static CTabItem createTabItem(CTabFolder folder, Integer style, String text, String tooltip, Integer index) {
        CTabItem item = new CTabItem(folder, style.intValue(), index.intValue());
        item.setText(text);
        item.setToolTipText(tooltip);
        return item;
    }

    public static Table createTable(Composite parent, Integer style, Object layoutData) {
        Integer cols = null;
        if (layoutData instanceof GridData) {
            GridData gd = (GridData)layoutData;
            cols = gd.horizontalSpan;
        }
        if (style == null) {
            style = 0;
        }
        if (cols == null) {
            cols = 1;
        }
        Table t = new Table(parent, style.intValue());
        t.setLayoutData(layoutData);
        return t;
    }

    public static Text createText(Composite parent, Integer style, Object layoutData, Boolean readOnly, String initialValue) {
        return WidgetBuilderUtils.createText(parent, style, layoutData, readOnly, initialValue, null, null);
    }

    public static Text createText(Composite parent, Integer style, Object layoutData, Boolean readOnly, String initialValue, ModifyListener listener, Color color) {
        Text text = new Text(parent, style.intValue());
        text.setLayoutData(layoutData);
        if (readOnly != null) {
            text.setEditable(readOnly == false);
        }
        if (color != null) {
            text.setBackground(color);
        }
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static Tree createTree(Composite parent, Integer style, Object layoutData) {
        Integer cols = null;
        if (layoutData instanceof GridData) {
            GridData gd = (GridData)layoutData;
            cols = gd.horizontalSpan;
        }
        if (style == null) {
            style = 0;
        }
        if (cols == null) {
            cols = 1;
        }
        Tree t = new Tree(parent, style.intValue());
        t.setLayoutData(layoutData);
        return t;
    }

    public static Color getColor(String color) {
        int swtColor = 2;
        if ("SWT.COLOR_BLACK".equals(color)) {
            swtColor = 2;
        } else if ("SWT.COLOR_WHITE".equals(color)) {
            swtColor = 1;
        } else if ("SWT.COLOR_RED".equals(color)) {
            swtColor = 3;
        } else if ("SWT.COLOR_DARK_RED".equals(color)) {
            swtColor = 4;
        } else if ("SWT.COLOR_GREEN".equals(color)) {
            swtColor = 5;
        } else if ("SWT.COLOR_DARK_GREEN".equals(color)) {
            swtColor = 6;
        } else if ("SWT.COLOR_YELLOW".equals(color)) {
            swtColor = 7;
        } else if ("SWT.COLOR_DARK_YELLOW".equals(color)) {
            swtColor = 8;
        } else if ("SWT.COLOR_BLUE".equals(color)) {
            swtColor = 9;
        } else if ("SWT.COLOR_DARK_BLUE".equals(color)) {
            swtColor = 10;
        } else if ("SWT.COLOR_MAGENTA".equals(color)) {
            swtColor = 11;
        } else if ("SWT.COLOR_DARK_MAGENTA".equals(color)) {
            swtColor = 12;
        } else if ("SWT.COLOR_CYAN".equals(color)) {
            swtColor = 13;
        } else if ("SWT.COLOR_DARK_CYAN".equals(color)) {
            swtColor = 14;
        } else if ("SWT.COLOR_GRAY".equals(color)) {
            swtColor = 15;
        } else if ("SWT.COLOR_DARK_GRAY".equals(color)) {
            swtColor = 16;
        } else if ("SWT.COLOR_INFO_BACKGROUND".equals(color)) {
            swtColor = 29;
        } else if ("SWT.COLOR_INFO_FOREGROUND".equals(color)) {
            swtColor = 28;
        } else if ("SWT.COLOR_LIST_BACKGROUND".equals(color)) {
            swtColor = 25;
        } else if ("SWT.COLOR_LIST_FOREGROUND".equals(color)) {
            swtColor = 24;
        } else if ("SWT.COLOR_LIST_SELECTION".equals(color)) {
            swtColor = 26;
        } else if ("SWT.COLOR_LIST_SELECTION_TEXT".equals(color)) {
            swtColor = 27;
        } else if ("SWT.COLOR_TITLE_BACKGROUND".equals(color)) {
            swtColor = 31;
        } else if ("SWT.COLOR_TITLE_BACKGROUND_GRADIENT".equals(color)) {
            swtColor = 32;
        } else if ("SWT.COLOR_TITLE_FOREGROUND".equals(color)) {
            swtColor = 30;
        } else if ("SWT.COLOR_TITLE_INACTIVE_BACKGROUND".equals(color)) {
            swtColor = 34;
        } else if ("SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT".equals(color)) {
            swtColor = 35;
        } else if ("SWT.COLOR_TITLE_INACTIVE_FOREGROUND".equals(color)) {
            swtColor = 33;
        } else if ("SWT.COLOR_WIDGET_BACKGROUND".equals(color)) {
            swtColor = 22;
        } else if ("SWT.COLOR_WIDGET_BORDER".equals(color)) {
            swtColor = 23;
        } else if ("SWT.COLOR_WIDGET_DARK_SHADOW".equals(color)) {
            swtColor = 17;
        } else if ("SWT.COLOR_WIDGET_FOREGROUND".equals(color)) {
            swtColor = 21;
        } else if ("SWT.COLOR_WIDGET_HIGHLIGHT_SHADOW".equals(color)) {
            swtColor = 20;
        } else if ("SWT.COLOR_WIDGET_LIGHT_SHADOW".equals(color)) {
            swtColor = 19;
        } else if ("SWT.COLOR_WIDGET_NORMAL_SHADOW".equals(color)) {
            swtColor = 18;
        }
        return Display.getDefault().getSystemColor(swtColor);
    }

    public static Font getFont(FontType fontDescriptor) {
        String key = String.valueOf(fontDescriptor.getName()) + fontDescriptor.getSize() + fontDescriptor.getStyle();
        FontData[] data = fonts.getFontData(key);
        if (data == null) {
            data = new FontData[]{new FontData(fontDescriptor.getName(), fontDescriptor.getSize(), WidgetBuilderUtils.getStyle(fontDescriptor.getStyle()))};
            fonts.put(key, data);
        }
        return fonts.get(key);
    }

    public static int getStyle(String style) {
        if (style == null || "".equals(style)) {
            return 0;
        }
        return WidgetBuilderUtils.getStyle(style.split("[|]"));
    }

    public static String[] normalizeComboItems(String[] items) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(items));
        Iterator s = list.iterator();
        while (s.hasNext()) {
            String item = ((String)s.next()).trim();
            if (!"".equals(item) && !JAXBUIConstants.LINE_SEP.equals(item)) continue;
            s.remove();
        }
        list.add(0, "");
        return list.toArray(new String[0]);
    }

    public static String removeTabOrLineBreak(String text) {
        if (text == null) {
            return null;
        }
        if ("".equals(text)) {
            return "";
        }
        StringBuffer newLine = new StringBuffer();
        int strln = text.length();
        char lastChar = '\u0000';
        int i = 0;
        while (i < strln) {
            char c = text.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    if (lastChar == " ".charAt(0)) break;
                    newLine.append(" ");
                    lastChar = " ".charAt(0);
                    break;
                }
                default: {
                    newLine.append(c);
                    lastChar = c;
                }
            }
            ++i;
        }
        return newLine.toString();
    }

    private static int getStyle(String[] style) {
        int swt = 0;
        String[] stringArray = style;
        int n = style.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ("SWT.ARROW".equals(s = s.trim())) {
                swt |= 4;
            }
            if ("SWT.BACKGROUND".equals(s)) {
                swt |= 8;
            }
            if ("SWT.BALLOON".equals(s)) {
                swt |= 0x1000;
            }
            if ("SWT.BAR".equals(s)) {
                swt |= 2;
            }
            if ("SWT.BEGINNING".equals(s)) {
                swt |= 1;
            }
            if ("SWT.BORDER".equals(s)) {
                swt |= 0x800;
            }
            if ("SWT.BORDER_DASH".equals(s)) {
                swt |= 2;
            }
            if ("SWT.BORDER_DOT".equals(s)) {
                swt |= 4;
            }
            if ("SWT.BORDER_SOLID".equals(s)) {
                swt |= 1;
            }
            if ("SWT.BOTTOM".equals(s)) {
                swt |= 0x400;
            }
            if ("SWT.CASCADE".equals(s)) {
                swt |= 0x40;
            }
            if ("SWT.CENTER".equals(s)) {
                swt |= 0x1000000;
            }
            if ("SWT.CHECK".equals(s)) {
                swt |= 0x20;
            }
            if ("SWT.DIALOG_TRIM".equals(s)) {
                swt |= 0x860;
            }
            if ("SWT.DOWN".equals(s)) {
                swt |= 0x400;
            }
            if ("SWT.DROP_DOWN".equals(s)) {
                swt |= 4;
            }
            if ("SWT.FILL".equals(s)) {
                swt |= 4;
            }
            if ("GridData.FILL_BOTH".equals(s)) {
                swt |= 0x710;
            }
            if ("SWT.FILL_EVEN_ODD".equals(s)) {
                swt |= 1;
            }
            if ("GridData.FILL_HORIZONTAL".equals(s)) {
                swt |= 0x300;
            }
            if ("GridData.FILL_VERTICAL".equals(s)) {
                swt |= 0x410;
            }
            if ("SWT.FILL_WINDING".equals(s)) {
                swt |= 2;
            }
            if ("SWT.FOREGROUND".equals(s)) {
                swt |= 0x10;
            }
            if ("SWT.FULL_SELECTION".equals(s)) {
                swt |= 0x10000;
            }
            if ("SWT.H_SCROLL".equals(s)) {
                swt |= 0x100;
            }
            if ("SWT.HORIZONTAL".equals(s)) {
                swt |= 0x100;
            }
            if ("SWT.LEAD".equals(s)) {
                swt |= 0x4000;
            }
            if ("SWT.LEFT".equals(s)) {
                swt |= 0x4000;
            }
            if ("SWT.LEFT_TO_RIGHT".equals(s)) {
                swt |= 0x2000000;
            }
            if ("SWT.LINE_CUSTOM".equals(s)) {
                swt |= 6;
            }
            if ("SWT.LINE_DASH".equals(s)) {
                swt |= 2;
            }
            if ("SWT.LINE_DASHDOT".equals(s)) {
                swt |= 4;
            }
            if ("SWT.LINE_DASHDOTDOT".equals(s)) {
                swt |= 5;
            }
            if ("SWT.LINE_DOT".equals(s)) {
                swt |= 3;
            }
            if ("SWT.LINE_SOLID".equals(s)) {
                swt |= 1;
            }
            if ("SWT.MODELESS".equals(s)) {
                swt |= 0;
            }
            if ("SWT.MULTI".equals(s)) {
                swt |= 2;
            }
            if ("SWT.NO".equals(s)) {
                swt |= 0x80;
            }
            if ("SWT.NO_BACKGROUND".equals(s)) {
                swt |= 0x40000;
            }
            if ("SWT.NO_FOCUS".equals(s)) {
                swt |= 0x80000;
            }
            if ("SWT.NO_MERGE_PAINTS".equals(s)) {
                swt |= 0x200000;
            }
            if ("SWT.NO_RADIO_GROUP".equals(s)) {
                swt |= 0x400000;
            }
            if ("SWT.NO_REDRAW_RESIZE".equals(s)) {
                swt |= 0x100000;
            }
            if ("SWT.NO_SCROLL".equals(s)) {
                swt |= 0x10;
            }
            if ("SWT.NO_TRIM".equals(s)) {
                swt |= 8;
            }
            if ("SWT.NONE".equals(s)) {
                swt |= 0;
            }
            if ("SWT.NORMAL".equals(s)) {
                swt |= 0;
            }
            if ("SWT.ON_TOP".equals(s)) {
                swt |= 0x4000;
            }
            if ("SWT.OPEN".equals(s)) {
                swt |= 0x1000;
            }
            if ("SWT.POP_UP".equals(s)) {
                swt |= 8;
            }
            if ("SWT.PRIMARY_MODAL".equals(s)) {
                swt |= 0x8000;
            }
            if ("SWT.PUSH".equals(s)) {
                swt |= 8;
            }
            if ("SWT.RADIO".equals(s)) {
                swt |= 0x10;
            }
            if ("SWT.READ_ONLY".equals(s)) {
                swt |= 8;
            }
            if ("SWT.RESIZE".equals(s)) {
                swt |= 0x10;
            }
            if ("SWT.RIGHT".equals(s)) {
                swt |= 0x20000;
            }
            if ("SWT.RIGHT_TO_LEFT".equals(s)) {
                swt |= 0x4000000;
            }
            if ("SWT.SCROLL_LINE".equals(s)) {
                swt |= 1;
            }
            if ("SWT.SCROLL_LOCK".equals(s)) {
                swt |= 0x1000054;
            }
            if ("SWT.SCROLL_PAGE".equals(s)) {
                swt |= 2;
            }
            if ("SWT.SHADOW_ETCHED_IN".equals(s)) {
                swt |= 0x10;
            }
            if ("SWT.SHADOW_ETCHED_OUT".equals(s)) {
                swt |= 0x40;
            }
            if ("SWT.SHADOW_IN".equals(s)) {
                swt |= 4;
            }
            if ("SWT.SHADOW_NONE".equals(s)) {
                swt |= 0x20;
            }
            if ("SWT.SHADOW_OUT".equals(s)) {
                swt |= 8;
            }
            if ("SWT.SHELL_TRIM".equals(s)) {
                swt |= 0x4F0;
            }
            if ("SWT.SHORT".equals(s)) {
                swt |= 0x8000;
            }
            if ("SWT.SIMPLE".equals(s)) {
                swt |= 0x40;
            }
            if ("SWT.SINGLE".equals(s)) {
                swt |= 4;
            }
            if ("SWT.SMOOTH".equals(s)) {
                swt |= 0x10000;
            }
            if ("SWT.TITLE".equals(s)) {
                swt |= 0x20;
            }
            if ("SWT.TOGGLE".equals(s)) {
                swt |= 2;
            }
            if ("SWT.TOGGLE".equals(s)) {
                swt |= 0x80;
            }
            if ("SWT.UP".equals(s)) {
                swt |= 0x80;
            }
            if ("SWT.V_SCROLL".equals(s)) {
                swt |= 0x200;
            }
            if ("SWT.VERTICAL".equals(s)) {
                swt |= 0x200;
            }
            if ("SWT.WRAP".equals(s)) {
                swt |= 0x40;
            }
            if ("SWT.YES".equals(s)) {
                swt |= 0x40;
            }
            ++n2;
        }
        return swt;
    }

    private WidgetBuilderUtils() {
    }
}

