/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class CPPASTTypeId
extends ASTNode
implements ICPPASTTypeId {
    private IASTDeclSpecifier declSpec;
    private IASTDeclarator absDecl;
    private boolean isPackExpansion;

    public CPPASTTypeId() {
    }

    public CPPASTTypeId(IASTDeclSpecifier declSpec, IASTDeclarator absDecl) {
        this.setDeclSpecifier(declSpec);
        this.setAbstractDeclarator(absDecl);
    }

    public CPPASTTypeId copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTTypeId copy(IASTNode.CopyStyle style) {
        CPPASTTypeId copy = new CPPASTTypeId();
        copy.setDeclSpecifier(this.declSpec == null ? null : this.declSpec.copy(style));
        copy.setAbstractDeclarator(this.absDecl == null ? null : this.absDecl.copy(style));
        copy.setOffsetAndLength(this);
        copy.isPackExpansion = this.isPackExpansion;
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpec;
    }

    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.declSpec = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    public IASTDeclarator getAbstractDeclarator() {
        return this.absDecl;
    }

    public void setAbstractDeclarator(IASTDeclarator abstractDeclarator) {
        this.assertNotFrozen();
        this.absDecl = abstractDeclarator;
        if (abstractDeclarator != null) {
            abstractDeclarator.setParent(this);
            abstractDeclarator.setPropertyInParent(ABSTRACT_DECLARATOR);
        }
    }

    public boolean isPackExpansion() {
        return this.isPackExpansion;
    }

    public void setIsPackExpansion(boolean val) {
        this.isPackExpansion = val;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitTypeIds) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declSpec != null && !this.declSpec.accept(action)) {
            return false;
        }
        if (this.absDecl != null && !this.absDecl.accept(action)) {
            return false;
        }
        if (action.shouldVisitTypeIds) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

