/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.io.Serializable;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITemplate;

public class Template
implements ITemplate,
Serializable {
    private static final long serialVersionUID = 1L;
    private String[] fParameterTypes;
    private String fSignature;
    protected String fName;
    protected String[] fTemplateArgs;

    public Template() {
        this.fName = "";
    }

    public Template(String name) {
        this.fName = name;
    }

    public int getNumberOfTemplateParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    public String[] getTemplateParameterTypes() {
        return this.fParameterTypes;
    }

    public String[] getTemplateArguments() {
        return this.fTemplateArgs;
    }

    public void setTemplateInfo(String[] templateParameterTypes, String[] args) {
        if (templateParameterTypes != null) {
            this.fParameterTypes = templateParameterTypes;
        }
        if (args != null) {
            this.fTemplateArgs = args;
        }
    }

    public String getTemplateSignature() throws CModelException {
        if (this.fSignature == null || this.fSignature.length() == 0) {
            StringBuffer sig = new StringBuffer(this.fName);
            if (this.getNumberOfTemplateParameters() > 0) {
                sig.append("<");
                String[] paramTypes = this.getTemplateParameterTypes();
                int i = 0;
                sig.append(paramTypes[i++]);
                while (i < paramTypes.length) {
                    sig.append(", ");
                    sig.append(paramTypes[i++]);
                }
                sig.append(">");
            } else {
                sig.append("<>");
            }
            this.fSignature = sig.toString();
        }
        return this.fSignature;
    }

    public void setTemplateParameterTypes(String[] parameterTypes) {
        this.fParameterTypes = parameterTypes;
    }
}

