/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.wizards;

import java.util.Set;
import java.util.SortedSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.messages.Messages;
import org.eclipse.ptp.services.ui.wizards.NewServiceConfigurationProjectWizard;
import org.eclipse.ptp.services.ui.wizards.ServiceConfigurationWidget;
import org.eclipse.ptp.services.ui.wizards.ServiceConfigurationWizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ServiceConfigurationSelectionWizardPage
extends WizardSelectionPage {
    private IServiceConfiguration fServiceConfiguration;

    public ServiceConfigurationSelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.ServiceConfigurationSelectionWizardPage_0);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.setControl((Control)container);
        ServiceModelManager manager = ServiceModelManager.getInstance();
        Set configs = manager.getConfigurations();
        if (configs.size() > 0) {
            Label label1 = new Label(container, 16384);
            label1.setText(Messages.ServiceConfigurationSelectionWizardPage_1);
            Label label2 = new Label(container, 16384);
            label2.setText(Messages.ServiceConfigurationSelectionWizardPage_2);
            new ServiceConfigurationWidget(configs).createContents(container);
        } else {
            Label label1 = new Label(container, 16384);
            label1.setText(Messages.ServiceConfigurationSelectionWizardPage_3);
            Label label2 = new Label(container, 16384);
            label2.setText(Messages.ServiceConfigurationSelectionWizardPage_4);
            IServiceConfiguration config = manager.newServiceConfiguration(Messages.ServiceConfigurationSelectionWizardPage_5);
            for (IService service : manager.getServices()) {
                SortedSet providers = service.getProvidersByPriority();
                if (providers.size() <= 0) continue;
                IServiceProvider provider = ServiceModelManager.getInstance().getServiceProvider((IServiceProviderDescriptor)providers.iterator().next());
                config.setServiceProvider(service, provider);
            }
            this.setServiceConfiguration(config);
            this.setSelectedNode(new ServiceNode(((NewServiceConfigurationProjectWizard)this.getWizard()).getWorkbench(), ((NewServiceConfigurationProjectWizard)this.getWizard()).getSelection()));
        }
    }

    private IServiceConfiguration getServiceConfiguration() {
        return this.fServiceConfiguration;
    }

    private void setServiceConfiguration(IServiceConfiguration fServiceConfiguration) {
        this.fServiceConfiguration = fServiceConfiguration;
    }

    private class ServiceNode
    implements IWizardNode {
        private INewWizard fWizard = null;
        private IWorkbench fWorkbench = null;
        private IStructuredSelection fSelection = null;

        public ServiceNode(IWorkbench workbench, IStructuredSelection selection) {
            this.fWorkbench = workbench;
            this.fSelection = selection;
        }

        public void dispose() {
        }

        public Point getExtent() {
            return new Point(-1, -1);
        }

        public IWizard getWizard() {
            if (this.fWizard == null) {
                this.fWizard = new ServiceConfigurationWizard(ServiceConfigurationSelectionWizardPage.this.getServiceConfiguration());
                this.fWizard.addPages();
                this.fWizard.init(this.fWorkbench, this.fSelection);
            }
            return this.fWizard;
        }

        public boolean isContentCreated() {
            return this.fWizard != null;
        }
    }
}

