/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.internal.ssh.Connection;
import org.eclipse.ptp.remotetools.internal.ssh.KillableExecution;

public class ExecutionObserver
extends Thread {
    private final Connection fConnection;
    private boolean fCanceled = false;

    public ExecutionObserver(Connection connection) {
        super(Messages.ExecutionObserver_ExecutionObserver_RemoteCommandObserver);
        this.fConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.fCanceled = true;
        ExecutionObserver executionObserver = this;
        synchronized (executionObserver) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndNotify(boolean cancel) {
        ArrayList<KillableExecution> execs;
        Hashtable<Integer, KillableExecution> hashtable = this.fConnection.getActiveProcessTable();
        synchronized (hashtable) {
            execs = new ArrayList<KillableExecution>(this.fConnection.getActiveProcessTable().values());
        }
        for (KillableExecution exec : execs) {
            if (cancel && exec.isRunning()) {
                exec.notifyCancel();
                continue;
            }
            if (cancel || exec.isRunning()) continue;
            exec.notifyFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.fCanceled && this.fConnection.isConnected()) {
            this.checkAndNotify(false);
            ExecutionObserver executionObserver = this;
            synchronized (executionObserver) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.checkAndNotify(true);
    }
}

