/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.eclipse.ptp.rm.lml.core.events.ILguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.internal.core.elements.AbslayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ChartType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ChartgroupType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ChartlayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ColumnType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ColumnlayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ComponentType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ComponentlayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataType;
import org.eclipse.ptp.rm.lml.internal.core.elements.GobjectType;
import org.eclipse.ptp.rm.lml.internal.core.elements.InfoboxType;
import org.eclipse.ptp.rm.lml.internal.core.elements.InfoboxlayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.internal.core.elements.NodedisplaylayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.ObjectFactory;
import org.eclipse.ptp.rm.lml.internal.core.elements.PaneType;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeType;
import org.eclipse.ptp.rm.lml.internal.core.elements.SplitlayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.TableType;
import org.eclipse.ptp.rm.lml.internal.core.elements.TablelayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.TextboxType;
import org.eclipse.ptp.rm.lml.internal.core.elements.UsagebarType;
import org.eclipse.ptp.rm.lml.internal.core.elements.UsagebarlayoutType;
import org.eclipse.ptp.rm.lml.internal.core.model.LguiHandler;
import org.eclipse.ptp.rm.lml.internal.core.model.LguiItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutAccess
extends LguiHandler {
    private final UsagebarlayoutType defaultUsagebar = objectFactory.createUsagebarlayoutType();
    private final ChartlayoutType defaultChart = objectFactory.createChartlayoutType();
    private final TablelayoutType defaultTable = objectFactory.createTablelayoutType();
    private final InfoboxlayoutType defaultInfobox = objectFactory.createInfoboxlayoutType();
    private static ObjectFactory objectFactory = new ObjectFactory();

    public static LguiType mergeLayouts(LguiType data, LguiType layout) {
        if (data == null || layout == null) {
            return data;
        }
        LguiItem lgui = new LguiItem(data);
        LayoutAccess la = new LayoutAccess(lgui, lgui.getLguiType());
        for (JAXBElement<?> el : layout.getObjectsAndRelationsAndInformation()) {
            if (!(el.getValue() instanceof ComponentlayoutType)) continue;
            la.replaceComponentLayout((ComponentlayoutType)el.getValue());
        }
        for (JAXBElement<?> el : layout.getObjectsAndRelationsAndInformation()) {
            if (!(el.getValue() instanceof LayoutType) || LayoutAccess.replaceGlobalLayout((LayoutType)el.getValue(), data)) continue;
            data.getObjectsAndRelationsAndInformation().add(el);
        }
        return data;
    }

    public static boolean replaceGlobalLayout(LayoutType newlayout, LguiType model) {
        List<JAXBElement<?>> all = model.getObjectsAndRelationsAndInformation();
        int i = 0;
        while (i < all.size()) {
            LayoutType old;
            JAXBElement<?> aobj = all.get(i);
            if (aobj.getValue() instanceof LayoutType && (old = (LayoutType)aobj.getValue()).getId().equals(newlayout.getId())) {
                aobj.setValue((Object)newlayout);
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void collectComponents(PaneType p, HashSet<String> neededComponents) {
        if (p.getGid() != null) {
            neededComponents.add(p.getGid());
        } else if (p.getBottom() != null) {
            LayoutAccess.collectComponents(p.getBottom(), neededComponents);
            LayoutAccess.collectComponents(p.getTop(), neededComponents);
        } else {
            LayoutAccess.collectComponents(p.getLeft(), neededComponents);
            LayoutAccess.collectComponents(p.getRight(), neededComponents);
        }
    }

    private static JAXBElement<GobjectType> minimizeGobjectType(GobjectType gobj) {
        GobjectType ut;
        String qname = "table";
        Class<?> c = gobj.getClass();
        GobjectType value = objectFactory.createGobjectType();
        if (gobj instanceof TableType) {
            TableType tt = objectFactory.createTableType();
            TableType orig = (TableType)gobj;
            tt.setContenttype(orig.getContenttype());
            for (ColumnType col : orig.getColumn()) {
                if (col.getPattern() == null) continue;
                tt.getColumn().add(col);
            }
            value = tt;
            qname = "table";
        } else if (gobj instanceof UsagebarType) {
            ut = objectFactory.createUsagebarType();
            ((UsagebarType)ut).setCpucount(BigInteger.valueOf(0L));
            value = ut;
            qname = "usagebar";
        } else if (gobj instanceof TextboxType) {
            ut = objectFactory.createTextboxType();
            ((TextboxType)ut).setText("");
            value = ut;
            qname = "text";
        } else if (gobj instanceof InfoboxType) {
            value = ut = objectFactory.createInfoboxType();
            qname = "infobox";
        } else if (gobj instanceof Nodedisplay) {
            value = ut = objectFactory.createNodedisplay();
            SchemeType scheme = objectFactory.createSchemeType();
            scheme.getEl1().add(objectFactory.createSchemeElement1());
            ((Nodedisplay)ut).setScheme(scheme);
            DataType dat = objectFactory.createDataType();
            dat.getEl1().add(objectFactory.createDataElement1());
            ((Nodedisplay)ut).setData(dat);
            qname = "nodedisplay";
        } else if (gobj instanceof ChartType) {
            value = ut = objectFactory.createChartType();
            qname = "chart";
        } else if (gobj instanceof ChartgroupType) {
            ut = objectFactory.createChartgroupType();
            ChartgroupType orig = (ChartgroupType)gobj;
            for (ChartType chart : orig.getChart()) {
                ChartType min = (ChartType)LayoutAccess.minimizeGobjectType(chart).getValue();
                ((ChartgroupType)ut).getChart().add(min);
            }
            value = ut;
            qname = "chartgroup";
        }
        value.setDescription(gobj.getDescription());
        value.setId(gobj.getId());
        value.setTitle(gobj.getTitle());
        JAXBElement res = new JAXBElement(new QName(qname), c, (Object)value);
        return res;
    }

    private static void objToLML(LguiType obj, OutputStream output) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"lml");
        Marshaller mar = jc.createMarshaller();
        mar.setProperty("jaxb.schemaLocation", (Object)"http://www.llview.de lgui.xsd");
        QName tagname = new QName("http://www.llview.de", "lgui", "lml");
        JAXBElement rootel = new JAXBElement(tagname, LguiType.class, (Object)obj);
        mar.setProperty("jaxb.formatted.output", (Object)true);
        mar.marshal((Object)rootel, output);
    }

    public LayoutAccess(ILguiItem lguiItem, LguiType lgui) {
        super(lguiItem, lgui);
        this.lguiItem.addListener(new ILguiListener(){

            public void handleEvent(ILguiUpdatedEvent e) {
                LayoutAccess.this.update(e.getLgui());
            }
        });
    }

    public void addLayoutTag(LayoutType layout) {
        if (layout.getId() == null) {
            layout.setId("");
        }
        JAXBElement jaxbel = null;
        if (layout instanceof AbslayoutType) {
            AbslayoutType abslayout = (AbslayoutType)layout;
            jaxbel = new JAXBElement(new QName("abslayout"), AbslayoutType.class, (Object)abslayout);
        } else if (layout instanceof SplitlayoutType) {
            SplitlayoutType splitlayout = (SplitlayoutType)layout;
            jaxbel = new JAXBElement(new QName("splitlayout"), SplitlayoutType.class, (Object)splitlayout);
        } else {
            return;
        }
        this.lgui.getObjectsAndRelationsAndInformation().add(jaxbel);
        this.lguiItem.notifyListeners();
    }

    public AbslayoutType generateDefaultAbsoluteLayout(int width, int height) {
        int rows;
        List<GobjectType> gobjects = this.lguiItem.getOverviewAccess().getGraphicalObjects();
        ArrayList<GobjectType> activeobjects = new ArrayList<GobjectType>();
        block0: for (GobjectType gobj : gobjects) {
            List<ComponentlayoutType> layouts = this.getComponentLayoutByGID(gobj.getId());
            if (layouts.size() == 0) {
                activeobjects.add(gobj);
            }
            for (ComponentlayoutType complayout : layouts) {
                if (!complayout.isActive()) continue;
                activeobjects.add(gobj);
                continue block0;
            }
        }
        AbslayoutType res = objectFactory.createAbslayoutType();
        res.setId("abs_default");
        int columns = (int)Math.round(Math.sqrt(activeobjects.size()));
        if (columns == 0) {
            columns = 1;
        }
        if ((rows = (int)Math.ceil((double)activeobjects.size() / (double)columns)) == 0) {
            rows = 1;
        }
        int index = 0;
        int rectwidth = width / columns;
        int rectheight = height / rows;
        for (GobjectType gobj : activeobjects) {
            ComponentType pos = objectFactory.createComponentType();
            pos.setGid(gobj.getId());
            pos.setW(BigInteger.valueOf(rectwidth));
            pos.setH(BigInteger.valueOf(rectheight));
            pos.setX(BigInteger.valueOf(index % columns * rectwidth));
            pos.setY(BigInteger.valueOf(index / columns * rectheight));
            res.getComp().add(pos);
            ++index;
        }
        return res;
    }

    public String[] getActiveNodedisplayLayoutGid() {
        ArrayList<String> nodedisplayID = new ArrayList<String>();
        List<NodedisplaylayoutType> nodedisplayLayouts = this.getNodedisplayLayouts();
        for (NodedisplaylayoutType nodedisplayLayout : nodedisplayLayouts) {
            if (!nodedisplayLayout.isActive()) continue;
            nodedisplayID.add(nodedisplayLayout.getGid());
        }
        return nodedisplayID.toArray(new String[nodedisplayID.size()]);
    }

    public String[] getActiveTableLayoutsGid() {
        ArrayList<String> tableLayoutsId = new ArrayList<String>();
        List<TablelayoutType> tableLayouts = this.getTableLayouts();
        for (TablelayoutType tableLayout : tableLayouts) {
            if (!tableLayout.isActive()) continue;
            tableLayoutsId.add(tableLayout.getGid());
        }
        return tableLayoutsId.toArray(new String[tableLayoutsId.size()]);
    }

    public ChartlayoutType getChartLayout(String chartID) {
        List<ChartlayoutType> chartLayouts = this.getChartLayouts();
        for (ChartlayoutType chartLayout : chartLayouts) {
            if (!chartLayout.getGid().equals(chartID)) continue;
            return chartLayout;
        }
        return this.defaultChart;
    }

    public List<ChartlayoutType> getChartLayouts() {
        LinkedList<ChartlayoutType> chartLayouts = new LinkedList<ChartlayoutType>();
        for (ComponentlayoutType tag : this.getComponentLayouts()) {
            if (!(tag instanceof ChartlayoutType)) continue;
            chartLayouts.add((ChartlayoutType)tag);
        }
        return chartLayouts;
    }

    public List<ComponentlayoutType> getComponentLayoutByGID(String gid) {
        List<ComponentlayoutType> complayouts = this.getComponentLayouts();
        ArrayList<ComponentlayoutType> res = new ArrayList<ComponentlayoutType>();
        for (ComponentlayoutType alayout : complayouts) {
            if (alayout.getGid() == null || !alayout.getGid().equals(gid)) continue;
            res.add(alayout);
        }
        return res;
    }

    public List<ComponentlayoutType> getComponentLayouts() {
        LinkedList<ComponentlayoutType> layouts = new LinkedList<ComponentlayoutType>();
        for (JAXBElement<?> tag : this.lgui.getObjectsAndRelationsAndInformation()) {
            if (!(tag.getValue() instanceof ComponentlayoutType)) continue;
            layouts.add((ComponentlayoutType)tag.getValue());
        }
        return layouts;
    }

    public TablelayoutType getDefaultTableLayout(String gid) {
        TablelayoutType tableLayout = this.getTableLayout(gid);
        if (tableLayout == null) {
            tableLayout = new TablelayoutType();
            tableLayout.setGid(gid);
            this.getTableLayouts().add(tableLayout);
        }
        if (tableLayout.getColumn().size() <= 0) {
            tableLayout.setId(String.valueOf(gid) + "_layout");
            tableLayout.setGid(gid);
            TableType table = this.lguiItem.getTableHandler().getTable(gid);
            if (table != null) {
                int i = 0;
                while (i < table.getColumn().size()) {
                    ColumnlayoutType column = new ColumnlayoutType();
                    column.setCid(BigInteger.valueOf(i + 1));
                    column.setPos(BigInteger.valueOf(i));
                    column.setWidth(1.0);
                    column.setActive(true);
                    column.setKey(table.getColumn().get(i).getName());
                    tableLayout.getColumn().add(column);
                    ++i;
                }
            }
        }
        return tableLayout;
    }

    public Map<String, String> getInactiveComponents() {
        List<ComponentlayoutType> objects = this.getComponentLayouts();
        ArrayList<String> inactive = new ArrayList<String>();
        HashMap<String, String> inactiveMap = new HashMap<String, String>();
        for (ComponentlayoutType object : objects) {
            if (object.isActive()) continue;
            if (object.getClass().getSimpleName().equals("TablelayoutType")) {
                TableType table = this.lguiItem.getTableHandler().getTable(object.getGid());
                if (table != null) {
                    inactiveMap.put(table.getTitle(), object.getGid());
                }
            } else if (object.getClass().getSimpleName().equals("NodedisplaylayoutType")) {
                inactiveMap.put(this.lguiItem.getNodedisplayAccess().getNodedisplayById(object.getGid()).getTitle(), object.getGid());
            }
            inactive.add(object.getGid());
        }
        return inactiveMap;
    }

    public InfoboxlayoutType getInfoboxLayout(String infoID) {
        List<InfoboxlayoutType> infoboxLayouts = this.getInfoboxLayout();
        for (InfoboxlayoutType infoboxLayout : infoboxLayouts) {
            if (!infoboxLayout.getGid().equals(infoID)) continue;
            return infoboxLayout;
        }
        return this.defaultInfobox;
    }

    public ColumnlayoutType[] getLayoutColumsToCids(BigInteger[] cids, String gid) {
        ColumnlayoutType[] columns = new ColumnlayoutType[cids.length];
        int i = 0;
        while (i < cids.length) {
            for (ColumnlayoutType column : this.getTableLayout(gid).getColumn()) {
                if (!column.getCid().equals(cids[i])) continue;
                columns[i] = column;
                break;
            }
            ++i;
        }
        return columns;
    }

    public LguiType getLayoutFromModel() {
        LguiType res = objectFactory.createLguiType();
        HashSet<String> neededComponents = new HashSet<String>();
        for (JAXBElement<?> tag : this.lgui.getObjectsAndRelationsAndInformation()) {
            Object value = tag.getValue();
            if (value instanceof LayoutType) {
                res.getObjectsAndRelationsAndInformation().add(tag);
                if (value instanceof SplitlayoutType) {
                    SplitlayoutType splitlayout = (SplitlayoutType)value;
                    if (splitlayout.getLeft() == null) continue;
                    LayoutAccess.collectComponents(splitlayout.getLeft(), neededComponents);
                    LayoutAccess.collectComponents(splitlayout.getRight(), neededComponents);
                    continue;
                }
                if (!(value instanceof AbslayoutType)) continue;
                AbslayoutType abslayout = (AbslayoutType)value;
                for (ComponentType comp : abslayout.getComp()) {
                    neededComponents.add(comp.getGid());
                }
                continue;
            }
            if (!(value instanceof ComponentlayoutType) || !((ComponentlayoutType)value).isActive()) continue;
            res.getObjectsAndRelationsAndInformation().add(tag);
            ComponentlayoutType complayout = (ComponentlayoutType)value;
            neededComponents.add(complayout.getGid());
            if (!(value instanceof NodedisplaylayoutType)) continue;
            NodedisplaylayoutType nlayout = (NodedisplaylayoutType)value;
            nlayout.setGid("__dummy_nd__");
        }
        HashMap<String, GobjectType> idtoGobject = new HashMap<String, GobjectType>();
        for (JAXBElement<?> tag : this.lgui.getObjectsAndRelationsAndInformation()) {
            GobjectType gobj;
            Object value = tag.getValue();
            if (!(value instanceof GobjectType) || !neededComponents.contains((gobj = (GobjectType)value).getId())) continue;
            idtoGobject.put(gobj.getId(), gobj);
        }
        for (GobjectType gobj : idtoGobject.values()) {
            JAXBElement<GobjectType> min = LayoutAccess.minimizeGobjectType(gobj);
            GobjectType newgobj = (GobjectType)min.getValue();
            if (newgobj instanceof Nodedisplay) {
                ((Nodedisplay)newgobj).setId("__dummy_nd__");
            }
            res.getObjectsAndRelationsAndInformation().add(min);
        }
        res.setLayout(true);
        return res;
    }

    public List<NodedisplaylayoutType> getNodedisplayLayouts() {
        LinkedList<NodedisplaylayoutType> nodedisplayLayouts = new LinkedList<NodedisplaylayoutType>();
        for (ComponentlayoutType tag : this.getComponentLayouts()) {
            if (!(tag instanceof NodedisplaylayoutType)) continue;
            nodedisplayLayouts.add((NodedisplaylayoutType)tag);
        }
        return nodedisplayLayouts;
    }

    public TablelayoutType getTableLayout(String tablelayoutID) {
        for (TablelayoutType tag : this.getTableLayouts()) {
            if (!tag.getGid().equals(tablelayoutID)) continue;
            return tag;
        }
        return this.defaultTable;
    }

    public List<TablelayoutType> getTableLayouts() {
        LinkedList<TablelayoutType> tableLayouts = new LinkedList<TablelayoutType>();
        for (ComponentlayoutType tag : this.getComponentLayouts()) {
            if (!(tag instanceof TablelayoutType)) continue;
            tableLayouts.add((TablelayoutType)tag);
        }
        return tableLayouts;
    }

    public InfoboxlayoutType getTextboxLayout(String textID) {
        return this.getInfoboxLayout(textID);
    }

    public UsagebarlayoutType getUsagebarLayout(String usagebarID) {
        List<UsagebarlayoutType> usagebarLayouts = this.getUsagebarLayouts();
        for (UsagebarlayoutType usagebarLayout : usagebarLayouts) {
            if (!usagebarLayout.getGid().equals(usagebarID)) continue;
            return usagebarLayout;
        }
        return this.defaultUsagebar;
    }

    public List<UsagebarlayoutType> getUsagebarLayouts() {
        LinkedList<UsagebarlayoutType> usagebarLayouts = new LinkedList<UsagebarlayoutType>();
        for (ComponentlayoutType tag : this.getComponentLayouts()) {
            if (!(tag instanceof UsagebarlayoutType)) continue;
            usagebarLayouts.add((UsagebarlayoutType)tag);
        }
        return usagebarLayouts;
    }

    public void replaceComponentLayout(ComponentlayoutType newlayout) {
        if (newlayout == null) {
            return;
        }
        String gid = newlayout.getGid();
        List<JAXBElement<?>> allobjects = this.lgui.getObjectsAndRelationsAndInformation();
        boolean replaced = false;
        int i = 0;
        while (i < allobjects.size()) {
            ComponentlayoutType alayout;
            JAXBElement<?> aobj = allobjects.get(i);
            if (aobj.getValue() instanceof ComponentlayoutType && (alayout = (ComponentlayoutType)aobj.getValue()).getGid() != null && alayout.getGid().equals(gid)) {
                if (!replaced) {
                    aobj.setValue((Object)newlayout);
                    this.lguiItem.notifyListeners();
                    replaced = true;
                } else {
                    allobjects.remove(aobj);
                    --i;
                }
            }
            ++i;
        }
        if (!replaced) {
            JAXBElement newel = null;
            if (newlayout instanceof TablelayoutType) {
                newel = new JAXBElement(new QName("tablelayout"), TablelayoutType.class, (Object)((TablelayoutType)newlayout));
            } else if (newlayout instanceof NodedisplaylayoutType) {
                newel = new JAXBElement(new QName("nodedisplaylayout"), NodedisplaylayoutType.class, (Object)((NodedisplaylayoutType)newlayout));
            }
            if (newel != null) {
                this.lgui.getObjectsAndRelationsAndInformation().add(newel);
                this.lguiItem.notifyListeners();
            }
        }
    }

    public void setChangesLayoutColumn() {
    }

    public String setComponentActive(String gid, boolean active) {
        String type = null;
        ComponentlayoutType component = this.getComponent(gid);
        if (component != null) {
            if (component instanceof TablelayoutType) {
                type = "table";
            } else if (component instanceof NodedisplaylayoutType) {
                type = "nodedisplay";
            }
            component.setActive(active);
        }
        return type;
    }

    private ComponentlayoutType getComponent(String gid) {
        List<ComponentlayoutType> objects = this.getComponentLayouts();
        for (ComponentlayoutType object : objects) {
            if (!object.getGid().equals(gid)) continue;
            return object;
        }
        return null;
    }

    private List<InfoboxlayoutType> getInfoboxLayout() {
        LinkedList<InfoboxlayoutType> infoboxLayouts = new LinkedList<InfoboxlayoutType>();
        for (ComponentlayoutType tag : this.getComponentLayouts()) {
            if (!(tag instanceof InfoboxlayoutType)) continue;
            infoboxLayouts.add((InfoboxlayoutType)tag);
        }
        return infoboxLayouts;
    }
}

