/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.IRemoteUIServicesDescriptor;
import org.eclipse.ptp.remote.ui.IRemoteUIServicesFactory;
import org.eclipse.ptp.remote.ui.messages.Messages;

public class RemoteUIServicesProxy
implements IRemoteUIServicesDescriptor {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASS = "class";
    private final IConfigurationElement configElement;
    private final String id;
    private final String name;
    private IRemoteUIServicesFactory fFactory = null;
    private IRemoteUIServices fDelegate = null;

    private static String getAttribute(IConfigurationElement configElement, String name, String defaultValue) {
        String value = configElement.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.RemoteUIServicesProxy_1, (Object)name));
    }

    public RemoteUIServicesProxy(IConfigurationElement configElement) {
        this.configElement = configElement;
        this.id = RemoteUIServicesProxy.getAttribute(configElement, ATTR_ID, null);
        this.name = RemoteUIServicesProxy.getAttribute(configElement, ATTR_NAME, this.id);
        RemoteUIServicesProxy.getAttribute(configElement, ATTR_CLASS, null);
    }

    public IRemoteUIServicesFactory getFactory() {
        if (this.fFactory != null) {
            return this.fFactory;
        }
        try {
            this.fFactory = (IRemoteUIServicesFactory)this.configElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception exception) {
            PTPRemoteCorePlugin.log((String)NLS.bind((String)Messages.RemoteUIServicesProxy_2, (Object[])new Object[]{this.configElement.getAttribute(ATTR_CLASS), this.id, this.configElement.getDeclaringExtension().getNamespaceIdentifier()}));
        }
        return this.fFactory;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public IRemoteUIServices getUIServices(IRemoteServices services) {
        this.loadServices(services);
        return this.fDelegate;
    }

    private void loadServices(IRemoteServices services) {
        IRemoteUIServicesFactory factory;
        if (this.fDelegate == null && (factory = this.getFactory()) != null) {
            this.fDelegate = factory.getServices(services);
        }
    }
}

