/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.serviceproviders;

import org.eclipse.ptp.internal.rdt.core.serviceproviders.AbstractRemoteCIndexServiceProvider;
import org.eclipse.ptp.internal.rdt.ui.contentassist.IContentAssistService;
import org.eclipse.ptp.internal.rdt.ui.contentassist.RemoteContentAssistService;
import org.eclipse.ptp.internal.rdt.ui.search.ISearchService;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchService;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.ptp.rdt.ui.serviceproviders.IIndexServiceProvider2;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.IConnectorService;

public class RSECIndexServiceProvider
extends AbstractRemoteCIndexServiceProvider
implements IIndexServiceProvider2 {
    public static final String ID = "org.eclipse.ptp.rdt.ui.RSECIndexServiceProvider";
    private RemoteSearchService fSearchService;
    private IContentAssistService fContentAssistService;

    public synchronized ISearchService getSearchService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fSearchService == null) {
            this.fSearchService = new RemoteSearchService(this.fConnectorService);
        }
        return this.fSearchService;
    }

    public synchronized IContentAssistService getContentAssistService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fContentAssistService == null) {
            this.fContentAssistService = new RemoteContentAssistService(this.fConnectorService);
        }
        return this.fContentAssistService;
    }

    public IHost getHost() {
        this.initializeHost();
        return super.getHost();
    }

    public boolean isConfigured() {
        this.initializeHost();
        return super.isConfigured();
    }

    private void initializeHost() {
        try {
            RSECorePlugin.waitForInitCompletion();
        }
        catch (InterruptedException e) {
            UIPlugin.log(e);
            return;
        }
        if (this.fHost == null && this.getHostName() != null) {
            IHost[] hosts;
            IHost[] iHostArray = hosts = SystemStartHere.getConnections();
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                IHost host = iHostArray[n2];
                if (host.getAliasName().equals(this.getHostName())) {
                    this.setConnection(host, RSECIndexServiceProvider.getDStoreConnectorService(host));
                }
                ++n2;
            }
        }
    }

    public static IConnectorService getDStoreConnectorService(IHost host) {
        IConnectorService[] connectorServices = host.getConnectorServices();
        int k = 0;
        while (k < connectorServices.length) {
            if (connectorServices[k] instanceof DStoreConnectorService) {
                return connectorServices[k];
            }
            ++k;
        }
        return null;
    }

    public String getConfigurationString() {
        if (this.isConfigured()) {
            return this.fHost.getName();
        }
        return null;
    }

    public String toString() {
        return "RSECIndexServiceProvider(" + this.getHostName() + "," + this.getIndexLocation() + ")";
    }
}

