/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTBaseDeclSpecifier;

public class CASTSimpleDeclSpecifier
extends CASTBaseDeclSpecifier
implements ICASTSimpleDeclSpecifier,
IASTAmbiguityParent {
    private int simpleType;
    private boolean isSigned;
    private boolean isUnsigned;
    private boolean isShort;
    private boolean isLong;
    private boolean longlong;
    private boolean complex = false;
    private boolean imaginary = false;
    private IASTExpression fDeclTypeExpression;

    public CASTSimpleDeclSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CASTSimpleDeclSpecifier copy(IASTNode.CopyStyle style) {
        CASTSimpleDeclSpecifier copy = new CASTSimpleDeclSpecifier();
        this.copySimpleDeclSpec(copy, style);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    protected void copySimpleDeclSpec(CASTSimpleDeclSpecifier copy, IASTNode.CopyStyle style) {
        this.copyBaseDeclSpec(copy);
        copy.simpleType = this.simpleType;
        copy.isSigned = this.isSigned;
        copy.isUnsigned = this.isUnsigned;
        copy.isShort = this.isShort;
        copy.isLong = this.isLong;
        copy.longlong = this.longlong;
        copy.complex = this.complex;
        copy.imaginary = this.imaginary;
        if (this.fDeclTypeExpression != null) {
            copy.setDeclTypeExpression(this.fDeclTypeExpression.copy(style));
        }
    }

    public int getType() {
        return this.simpleType;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public void setType(int type) {
        this.assertNotFrozen();
        this.simpleType = type;
    }

    public void setType(IBasicType.Kind kind) {
        this.setType(this.getType(kind));
    }

    private int getType(IBasicType.Kind kind) {
        switch (kind) {
            case eBoolean: {
                return 6;
            }
            case eChar: 
            case eWChar: 
            case eChar16: 
            case eChar32: {
                return 2;
            }
            case eDouble: {
                return 5;
            }
            case eFloat: {
                return 4;
            }
            case eInt: {
                return 3;
            }
            case eUnspecified: {
                return 0;
            }
            case eVoid: {
                return 1;
            }
        }
        return 0;
    }

    public void setShort(boolean value) {
        this.assertNotFrozen();
        this.isShort = value;
    }

    public void setLong(boolean value) {
        this.assertNotFrozen();
        this.isLong = value;
    }

    public void setUnsigned(boolean value) {
        this.assertNotFrozen();
        this.isUnsigned = value;
    }

    public void setSigned(boolean value) {
        this.assertNotFrozen();
        this.isSigned = value;
    }

    public boolean isLongLong() {
        return this.longlong;
    }

    public void setLongLong(boolean value) {
        this.assertNotFrozen();
        this.longlong = value;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fDeclTypeExpression != null && !this.fDeclTypeExpression.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public void setComplex(boolean value) {
        this.assertNotFrozen();
        this.complex = value;
    }

    public boolean isImaginary() {
        return this.imaginary;
    }

    public void setImaginary(boolean value) {
        this.assertNotFrozen();
        this.imaginary = value;
    }

    public IASTExpression getDeclTypeExpression() {
        return this.fDeclTypeExpression;
    }

    public void setDeclTypeExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fDeclTypeExpression = expression;
        if (expression != null) {
            expression.setPropertyInParent(DECLTYPE_EXPRESSION);
            expression.setParent(this);
        }
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fDeclTypeExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fDeclTypeExpression = (IASTExpression)other;
        }
    }
}

