/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public class CPPFunctionType
implements ICPPFunctionType,
ISerializableType {
    private final IType[] parameters;
    private final IType returnType;
    private final boolean isConst;
    private final boolean isVolatile;
    private final boolean takesVarargs;

    public CPPFunctionType(IType returnType, IType[] types) {
        this(returnType, types, false, false, false);
    }

    public CPPFunctionType(IType returnType, IType[] types, boolean isConst, boolean isVolatile, boolean takesVarargs) {
        this.returnType = returnType;
        this.parameters = types;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.takesVarargs = takesVarargs;
    }

    public boolean isSameType(IType o) {
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (o instanceof ICPPFunctionType) {
            ICPPFunctionType ft = (ICPPFunctionType)o;
            if (this.isConst() != ft.isConst() || this.isVolatile() != ft.isVolatile() || this.takesVarArgs() != ft.takesVarArgs()) {
                return false;
            }
            IType[] fps = ft.getParameterTypes();
            if (this.returnType == null ^ ft.getReturnType() == null) {
                return false;
            }
            if (this.returnType != null && !this.returnType.isSameType(ft.getReturnType())) {
                return false;
            }
            if (this.parameters.length == fps.length) {
                int i = 0;
                while (i < this.parameters.length) {
                    if (this.parameters[i] == null || !this.parameters[i].isSameType(fps[i])) {
                        return false;
                    }
                    ++i;
                }
            } else if (!SemanticUtil.isEmptyParameterList(this.parameters) || !SemanticUtil.isEmptyParameterList(fps)) {
                return false;
            }
            return true;
        }
        return false;
    }

    public IType getReturnType() {
        return this.returnType;
    }

    public IType[] getParameterTypes() {
        return this.parameters;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    @Deprecated
    public IPointerType getThisType() {
        return null;
    }

    public final boolean isConst() {
        return this.isConst;
    }

    public final boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean takesVarArgs() {
        return this.takesVarargs;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int len;
        int firstByte = 5;
        if (this.isConst()) {
            firstByte |= 0x10;
        }
        if (this.isVolatile()) {
            firstByte |= 0x20;
        }
        if (this.takesVarArgs()) {
            firstByte |= 0x40;
        }
        if ((len = this.parameters.length & 0xFFFF) > 255) {
            buffer.putByte((byte)(firstByte |= 0x80));
            buffer.putShort((short)len);
        } else {
            buffer.putByte((byte)firstByte);
            buffer.putByte((byte)len);
        }
        buffer.marshalType(this.returnType);
        int i = 0;
        while (i < len) {
            buffer.marshalType(this.parameters[i]);
            ++i;
        }
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        int len = (firstByte & 0x80) != 0 ? buffer.getShort() : buffer.getByte();
        IType rt = buffer.unmarshalType();
        IType[] pars = new IType[len];
        int i = 0;
        while (i < pars.length) {
            pars[i] = buffer.unmarshalType();
            ++i;
        }
        return new CPPFunctionType(rt, pars, (firstByte & 0x10) != 0, (firstByte & 0x20) != 0, (firstByte & 0x40) != 0);
    }
}

