/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceModelManager;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveServiceConfigurationAction
implements IObjectActionDelegate {
    private IServiceModelManager fManager = ServiceModelManager.getInstance();
    private List<IServiceConfiguration> fConfigurations = new ArrayList<IServiceConfiguration>();
    private IWorkbenchPart fWorkbenchPart;

    public void run(IAction action) {
        String names = "";
        int i = 0;
        while (i < this.fConfigurations.size()) {
            if (i > 0) {
                names = String.valueOf(names) + ", ";
            }
            names = String.valueOf(names) + "\n\t" + this.fConfigurations.get(i).getName();
            ++i;
        }
        boolean remove = MessageDialog.openConfirm((Shell)this.fWorkbenchPart.getSite().getShell(), (String)Messages.RemoveServiceConfigurationAction_0, (String)(String.valueOf(Messages.RemoveServiceConfigurationAction_1) + names));
        if (remove) {
            for (IServiceConfiguration conf : this.fConfigurations) {
                this.fManager.remove(conf);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fConfigurations.clear();
        IStructuredSelection structSel = (IStructuredSelection)selection;
        Object[] objectArray = structSel.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            if (selected instanceof IServiceConfiguration) {
                this.fConfigurations.add((IServiceConfiguration)selected);
            }
            ++n2;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }
}

