/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.ui.messages.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ServiceSelectionDialog
extends TitleAreaDialog {
    protected static final String SERVICE_KEY = "service-id";
    private IService[] fSelectedServices = new IService[0];
    private Table fTable;
    private IService[] fServices;

    public ServiceSelectionDialog(Shell parentShell, IService[] services) {
        super(parentShell);
        this.fServices = services;
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    public IService[] getSelectedServices() {
        return this.fSelectedServices;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.setTitle(Messages.ServiceSelectionDialog_0);
        this.setMessage(Messages.ServiceSelectionDialog_1);
        this.fTable = new Table(container, 68354);
        this.fTable.setLinesVisible(false);
        this.fTable.setHeaderVisible(false);
        this.fTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = ServiceSelectionDialog.this.fTable.getSelection();
                if (items.length == 0) {
                    return;
                }
                ServiceSelectionDialog.this.fSelectedServices = new IService[items.length];
                int index = 0;
                while (index < items.length) {
                    ((ServiceSelectionDialog)ServiceSelectionDialog.this).fSelectedServices[index] = (IService)items[index].getData(ServiceSelectionDialog.SERVICE_KEY);
                    ++index;
                }
            }
        });
        this.createTableContent();
        this.fTable.setVisible(true);
        return container;
    }

    private void createTableContent() {
        this.fTable.removeAll();
        IService[] iServiceArray = this.fServices;
        int n = this.fServices.length;
        int n2 = 0;
        while (n2 < n) {
            IService service = iServiceArray[n2];
            TableItem item = new TableItem(this.fTable, 0);
            item.setText(0, service.getName());
            item.setData(SERVICE_KEY, (Object)service);
            ++n2;
        }
    }
}

