/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.wizards;

import org.eclipse.ptp.rm.ui.wizards.WizardPageDataSource;
import org.eclipse.ptp.rm.ui.wizards.WizardPageWidgetListener;
import org.eclipse.ptp.ui.wizards.IRMConfigurationWizard;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractConfigurationWizardPage
extends RMConfigurationWizardPage {
    private final WizardPageWidgetListener listener = this.createListener();
    private final WizardPageDataSource dataSource = this.createDataSource();

    public AbstractConfigurationWizardPage(IRMConfigurationWizard wizard, String pageName) {
        super(wizard, pageName);
    }

    public void createControl(Composite parent) {
        this.listener.disable();
        this.dataSource.setConfiguration(this.getConfiguration());
        Composite composite = this.doCreateContents(parent);
        this.setControl((Control)composite);
        this.listener.enable();
    }

    public WizardPageDataSource getDataSource() {
        return this.dataSource;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.resetErrorMessages();
            this.listener.disable();
            this.dataSource.loadAndUpdate();
            this.listener.enable();
            this.updateControls();
        }
        super.setVisible(visible);
    }

    public abstract void updateControls();

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected abstract WizardPageDataSource createDataSource();

    protected abstract WizardPageWidgetListener createListener();

    protected abstract Composite doCreateContents(Composite var1);

    protected WizardPageWidgetListener getWidgetListener() {
        return this.listener;
    }

    protected void resetErrorMessages() {
        this.setPageComplete(true);
        this.setErrorMessage(null);
        this.setMessage(null);
    }
}

