/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.messages.Messages;

public class RemoteServicesDelegate {
    private static final String COSP = ": ";
    private static final int UNDEFINED = -1;
    private static final int COPY_BUFFER_SIZE = 65536;
    private final String remoteServicesId;
    private final String remoteConnectionName;
    private IRemoteServices remoteServices;
    private IRemoteServices localServices;
    private IRemoteConnectionManager remoteConnectionManager;
    private IRemoteConnectionManager localConnectionManager;
    private IRemoteConnection remoteConnection;
    private IRemoteConnection localConnection;
    private IRemoteFileManager remoteFileManager;
    private IRemoteFileManager localFileManager;
    private URI localHome;
    private URI remoteHome;

    public RemoteServicesDelegate(String remoteServicesId, String remoteConnectionName) {
        this.remoteServicesId = remoteServicesId;
        this.remoteConnectionName = remoteConnectionName;
    }

    public IRemoteConnection getLocalConnection() {
        return this.localConnection;
    }

    public IRemoteConnectionManager getLocalConnectionManager() {
        return this.localConnectionManager;
    }

    public IRemoteFileManager getLocalFileManager() {
        return this.localFileManager;
    }

    public URI getLocalHome() {
        return this.localHome;
    }

    public IRemoteServices getLocalServices() {
        return this.localServices;
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public IRemoteConnectionManager getRemoteConnectionManager() {
        return this.remoteConnectionManager;
    }

    public IRemoteFileManager getRemoteFileManager() {
        return this.remoteFileManager;
    }

    public URI getRemoteHome() {
        return this.remoteHome;
    }

    public IRemoteServices getRemoteServices() {
        return this.remoteServices;
    }

    public void initialize(IProgressMonitor monitor) throws CoreException {
        if (PTPRemoteCorePlugin.getDefault() == null) {
            return;
        }
        try {
            this.localServices = PTPRemoteCorePlugin.getDefault().getDefaultServices();
            if (this.localServices != null) {
                this.localConnectionManager = this.localServices.getConnectionManager();
                if (this.localConnectionManager != null) {
                    this.localConnection = this.localConnectionManager.getConnection("Local");
                }
                if (this.localConnection != null) {
                    this.localFileManager = this.localServices.getFileManager(this.localConnection);
                }
            }
            if (this.remoteServicesId != null) {
                this.remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.remoteServicesId, monitor);
                if (this.remoteServices != null) {
                    this.remoteConnectionManager = this.remoteServices.getConnectionManager();
                    if (this.remoteConnectionManager != null) {
                        this.remoteConnection = this.remoteConnectionManager.getConnection(this.remoteConnectionName);
                        if (this.remoteConnection != null) {
                            this.remoteFileManager = this.remoteServices.getFileManager(this.remoteConnection);
                        }
                    }
                }
            } else {
                this.remoteServices = this.localServices;
                this.remoteConnectionManager = this.localConnectionManager;
                this.remoteConnection = this.localConnection;
                this.remoteFileManager = this.localFileManager;
            }
            if (this.localFileManager != null) {
                this.localHome = this.localFileManager.toURI(this.localConnection.getWorkingDirectory());
            }
            if (this.remoteFileManager != null) {
                this.remoteHome = this.remoteFileManager.toURI(this.remoteConnection.getWorkingDirectory());
            }
        }
        catch (Throwable t) {
            throw RemoteServicesDelegate.newException("RemoteServicesDelegate.initialize " + this.remoteServicesId + COSP + this.remoteConnection, t);
        }
    }

    public static void copy(IRemoteFileManager from, String source, IRemoteFileManager to, String target, int mkParent, IProgressMonitor progress) throws CoreException {
        if (from == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Copy_Operation_NullSourceFileManager, null);
        }
        if (to == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Copy_Operation_NullTargetFileManager, null);
        }
        if (source == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Copy_Operation_NullSource, null);
        }
        if (target == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Copy_Operation_NullTarget, null);
        }
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)15);
        IFileStore lres = from.getResource(source);
        if (!lres.fetchInfo(0, (IProgressMonitor)subProgress.newChild(5)).exists()) {
            throw RemoteServicesDelegate.newException(String.valueOf(Messages.RemoteServicesDelegate_Copy_Operation_Local_resource_does_not_exist) + COSP + lres.getName(), null);
        }
        if (mkParent != -1) {
            to.getResource(target).getParent().mkdir(mkParent, (IProgressMonitor)subProgress.newChild(5));
        }
        if (subProgress.isCanceled()) {
            return;
        }
        IFileStore rres = to.getResource(target);
        lres.copy(rres, 2, (IProgressMonitor)subProgress.newChild(5));
    }

    public static boolean isStable(IRemoteFileManager manager, String path, int intervalInSecs, IProgressMonitor progress) throws CoreException {
        if (manager == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Read_Operation_NullSourceFileManager, null);
        }
        if (path == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Read_Operation_NullPath, null);
        }
        IFileStore lres = manager.getResource(path);
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        IFileInfo info = lres.fetchInfo(0, (IProgressMonitor)subProgress.newChild(5));
        if (subProgress.isCanceled()) {
            return false;
        }
        if (!info.exists()) {
            return false;
        }
        long l0 = info.getLength();
        try {
            Thread.sleep(1000 * intervalInSecs);
        }
        catch (InterruptedException interruptedException) {}
        info = lres.fetchInfo(0, (IProgressMonitor)subProgress.newChild(5));
        if (subProgress.isCanceled()) {
            return false;
        }
        long l1 = info.getLength();
        return l0 == l1;
    }

    public static String read(IRemoteFileManager manager, String path, IProgressMonitor progress) throws CoreException {
        SubMonitor subProgress;
        if (manager == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Read_Operation_NullSourceFileManager, null);
        }
        if (path == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Read_Operation_NullPath, null);
        }
        IFileStore lres = manager.getResource(path);
        if (!lres.fetchInfo(0, (IProgressMonitor)(subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)100)).newChild(5)).exists()) {
            throw RemoteServicesDelegate.newException(String.valueOf(Messages.RemoteServicesDelegate_Read_Operation_resource_does_not_exist) + COSP + lres.getName(), null);
        }
        BufferedInputStream is = new BufferedInputStream(lres.openInputStream(0, progress));
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[65536];
        int rcvd = 0;
        try {
            try {
                do {
                    try {
                        rcvd = is.read(buffer, 0, 65536);
                    }
                    catch (EOFException eOFException) {
                        break;
                    }
                    if (rcvd == -1) {
                        break;
                    }
                    sb.append(new String(buffer, 0, rcvd));
                } while (!subProgress.isCanceled());
            }
            catch (IOException iOException) {
                throw RemoteServicesDelegate.newException(String.valueOf(Messages.RemoteServicesDelegate_Read_OperationFailed) + path, null);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                PTPRemoteCorePlugin.log(ioe);
            }
        }
        return sb.toString();
    }

    public static void write(IRemoteFileManager manager, String path, String contents, IProgressMonitor progress) throws CoreException {
        if (contents == null) {
            return;
        }
        if (manager == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Write_Operation_NullSourceFileManager, null);
        }
        if (path == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Write_Operation_NullPath, null);
        }
        IFileStore lres = manager.getResource(path);
        BufferedOutputStream os = new BufferedOutputStream(lres.openOutputStream(0, progress));
        if (!progress.isCanceled()) {
            try {
                try {
                    os.write(contents.getBytes());
                    os.flush();
                }
                catch (IOException ioe) {
                    throw RemoteServicesDelegate.newException(String.valueOf(Messages.RemoteServicesDelegate_Write_OperationFailed) + path, ioe);
                }
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException ioe) {
                    PTPRemoteCorePlugin.log(ioe);
                }
            }
        }
    }

    private static IStatus getErrorStatus(String message, Throwable t) {
        if (t != null) {
            PTPRemoteCorePlugin.log(t);
        }
        return new Status(4, PTPRemoteCorePlugin.getUniqueIdentifier(), 4, message, t);
    }

    private static CoreException newException(String message, Throwable t) {
        return new CoreException(RemoteServicesDelegate.getErrorStatus(message, t));
    }
}

