/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import org.eclipse.core.resources.IFile;
import org.eclipse.photran.internal.core.analysis.binding.BindingCollector;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTArraySpecNode;
import org.eclipse.photran.internal.core.parser.ASTAssociationNode;
import org.eclipse.photran.internal.core.parser.ASTBlockDataStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockNode;
import org.eclipse.photran.internal.core.parser.ASTCommonStmtNode;
import org.eclipse.photran.internal.core.parser.ASTComponentDeclNode;
import org.eclipse.photran.internal.core.parser.ASTDataComponentDefStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTEntryStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEnumeratorDefStmtNode;
import org.eclipse.photran.internal.core.parser.ASTEnumeratorNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTExternalNameListNode;
import org.eclipse.photran.internal.core.parser.ASTExternalStmtNode;
import org.eclipse.photran.internal.core.parser.ASTForallConstructStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTIfThenStmtNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBlockNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBodyNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceStmtNode;
import org.eclipse.photran.internal.core.parser.ASTIntrinsicListNode;
import org.eclipse.photran.internal.core.parser.ASTIntrinsicStmtNode;
import org.eclipse.photran.internal.core.parser.ASTLabelDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTModuleStmtNode;
import org.eclipse.photran.internal.core.parser.ASTNamelistGroupsNode;
import org.eclipse.photran.internal.core.parser.ASTNamelistStmtNode;
import org.eclipse.photran.internal.core.parser.ASTProgramStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSelectCaseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSelectTypeStmtNode;
import org.eclipse.photran.internal.core.parser.ASTStmtFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeAttrSpecNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeParamDeclNode;
import org.eclipse.photran.internal.core.parser.ASTTypeParamDefStmtNode;
import org.eclipse.photran.internal.core.parser.ASTWhereConstructStmtNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IInterfaceSpecification;
import org.eclipse.photran.internal.core.parser.IProgramUnit;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;

class DefinitionCollector
extends BindingCollector {
    protected IFile file;

    public DefinitionCollector(IFile file) {
        this.vpgProvider = PhotranVPG.getProvider();
        this.file = file;
    }

    public void visitASTDerivedTypeStmtNode(ASTDerivedTypeStmtNode node) {
        super.traverseChildren(node);
        Definition d = this.addDefinition(node.getTypeName(), Definition.Classification.DERIVED_TYPE, Type.VOID);
        ScopingNode enclosingScope = node.findNearestAncestor(ScopingNode.class);
        if (node.getTypeAttrSpecList() != null) {
            for (ASTTypeAttrSpecNode attrSpec : node.getTypeAttrSpecList()) {
                if (attrSpec.getAccessSpec() == null) continue;
                d.setVisibility(attrSpec.getAccessSpec(), enclosingScope);
            }
        }
    }

    public void visitASTDataComponentDefStmtNode(ASTDataComponentDefStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTComponentDeclNode> decls = node.getComponentDeclList();
        int i = 0;
        while (i < decls.size()) {
            this.addDefinition(((ASTComponentDeclNode)decls.get(i)).getComponentName().getComponentName(), Definition.Classification.DERIVED_TYPE_COMPONENT, Type.parse(node.getTypeSpec()));
            ++i;
        }
    }

    public void visitASTTypeDeclarationStmtNode(ASTTypeDeclarationStmtNode node) {
        super.traverseChildren(node);
        ScopingNode enclosingScope = node.findNearestAncestor(ScopingNode.class);
        IASTListNode<ASTEntityDeclNode> decls = node.getEntityDeclList();
        if (decls != null) {
            int i = 0;
            while (i < decls.size()) {
                ASTEntityDeclNode entityDecl = (ASTEntityDeclNode)decls.get(i);
                Token objectNameIdent = this.getObjectNameIdent(entityDecl);
                Definition def = this.addDefinition(objectNameIdent, Definition.Classification.VARIABLE_DECLARATION, Type.parse(node.getTypeSpec()));
                def.setAttributes(node.getAttrSpecSeq(), enclosingScope);
                def.setArraySpec(this.getArraySpec(entityDecl));
                this.setDefinition(objectNameIdent, def);
                ++i;
            }
        }
    }

    private Token getObjectNameIdent(ASTEntityDeclNode entityDecl) {
        super.traverseChildren(entityDecl);
        return entityDecl.getObjectName().getObjectName();
    }

    private ASTArraySpecNode getArraySpec(ASTEntityDeclNode entityDecl) {
        super.traverseChildren(entityDecl);
        return entityDecl.getArraySpec();
    }

    public void visitASTNamelistStmtNode(ASTNamelistStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTNamelistGroupsNode> groups = node.getNamelistGroups();
        int i = 0;
        while (i < groups.size()) {
            Token name = ((ASTNamelistGroupsNode)groups.get(i)).getNamelistGroupName();
            if (name != null) {
                this.addDefinition(name, Definition.Classification.NAMELIST);
            }
            ++i;
        }
    }

    public void visitASTCommonStmtNode(ASTCommonStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTCommonBlockNode> list = node.getCommonBlockList();
        int i = 0;
        while (i < list.size()) {
            if (((ASTCommonBlockNode)list.get(i)).getName() != null) {
                Token commonBlockName = ((ASTCommonBlockNode)list.get(i)).getName().getCommonBlockName();
                this.addDefinition(commonBlockName, Definition.Classification.COMMON_BLOCK);
                this.vpgProvider.markFileAsUsingCommonBlock(this.file, commonBlockName.getText());
            }
            ++i;
        }
    }

    public void visitASTWhereConstructStmtNode(ASTWhereConstructStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.addDefinition(node.getName(), Definition.Classification.WHERE, Type.VOID);
        }
    }

    public void visitASTForallConstructStmtNode(ASTForallConstructStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.addDefinition(node.getName(), Definition.Classification.FORALL);
        }
    }

    public void visitASTIfThenStmtNode(ASTIfThenStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.addDefinition(node.getName(), Definition.Classification.IF);
        }
    }

    public void visitASTSelectCaseStmtNode(ASTSelectCaseStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.addDefinition(node.getName(), Definition.Classification.SELECT);
        }
    }

    public void visitASTLabelDoStmtNode(ASTLabelDoStmtNode node) {
        super.traverseChildren(node);
        if (node.getName() != null) {
            this.addDefinition(node.getName(), Definition.Classification.DO);
        }
    }

    public void visitASTProgramStmtNode(ASTProgramStmtNode node) {
        super.traverseChildren(node);
        this.addDefinition(node.getProgramName().getProgramName(), Definition.Classification.MAIN_PROGRAM, Type.VOID);
    }

    public void visitASTModuleStmtNode(ASTModuleStmtNode node) {
        super.traverseChildren(node);
        this.addDefinition(node.getModuleName().getModuleName(), Definition.Classification.MODULE, Type.VOID);
        try {
            Token moduleNameToken = node.getModuleName().getModuleName();
            this.markModuleExport(this.file, moduleNameToken);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void visitASTBlockDataStmtNode(ASTBlockDataStmtNode node) {
        super.traverseChildren(node);
        Token token = node.getBlockDataName() == null ? null : node.getBlockDataName().getBlockDataName();
        this.addDefinition(token, Definition.Classification.BLOCK_DATA, Type.VOID);
    }

    public void visitASTInterfaceStmtNode(ASTInterfaceStmtNode node) {
        super.traverseChildren(node);
        if (node.getGenericName() != null) {
            this.addDefinition(node.getGenericName().getGenericName(), Definition.Classification.INTERFACE, Type.UNKNOWN);
        } else if (node.getGenericSpec() != null) {
            this.addDefinition(null, Definition.Classification.INTERFACE, Type.UNKNOWN);
        }
    }

    public void visitASTExternalStmtNode(ASTExternalStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTExternalNameListNode> list = node.getExternalNameList();
        int i = 0;
        while (i < list.size()) {
            this.addDefinition(((ASTExternalNameListNode)list.get(i)).getExternalName(), Definition.Classification.EXTERNAL, Type.UNKNOWN);
            this.markSubprogramImport(((ASTExternalNameListNode)list.get(i)).getExternalName());
            ++i;
        }
    }

    public void visitASTIntrinsicStmtNode(ASTIntrinsicStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTIntrinsicListNode> list = node.getIntrinsicList();
        int i = 0;
        while (i < list.size()) {
            this.addDefinition(((ASTIntrinsicListNode)list.get(i)).getIntrinsicProcedureName(), Definition.Classification.INTRINSIC, Type.UNKNOWN);
            ++i;
        }
    }

    public void visitASTFunctionStmtNode(ASTFunctionStmtNode node) {
        super.traverseChildren(node);
        this.addDefinition(node.getFunctionName().getFunctionName(), Definition.Classification.FUNCTION, Type.UNKNOWN);
    }

    public void visitASTSubroutineStmtNode(ASTSubroutineStmtNode node) {
        super.traverseChildren(node);
        this.addDefinition(node.getSubroutineName().getSubroutineName(), Definition.Classification.SUBROUTINE, Type.VOID);
    }

    public void visitASTEntryStmtNode(ASTEntryStmtNode node) {
        super.traverseChildren(node);
    }

    public void visitASTStmtFunctionStmtNode(ASTStmtFunctionStmtNode node) {
        super.traverseChildren(node);
    }

    public void visitASTExecutableProgramNode(ASTExecutableProgramNode node) {
        super.visitASTExecutableProgramNode(node);
        this.markExternalSubprogramExports(node);
    }

    public void visitASTTypeParamDefStmtNode(ASTTypeParamDefStmtNode node) {
        super.traverseChildren(node);
        IASTListNode<ASTTypeParamDeclNode> list = node.getTypeParamDeclList();
        int i = 0;
        while (i < list.size()) {
            this.bind(((ASTTypeParamDeclNode)list.get(i)).getTypeParamName());
            ++i;
        }
    }

    public void visitASTEnumeratorDefStmtNode(ASTEnumeratorDefStmtNode node) {
        super.traverseChildren(node);
        for (ASTEnumeratorNode enumNode : node.getEnumeratorList()) {
            this.addDefinition(enumNode.getNamedConstant().getNamedConstant(), Definition.Classification.ENUMERATOR, Type.INTEGER);
        }
    }

    public void visitASTAssociationNode(ASTAssociationNode node) {
        super.traverseChildren(node);
        this.addDefinition(node.getAssociateName(), Definition.Classification.VARIABLE_DECLARATION, Type.UNKNOWN);
    }

    public void visitASTSelectTypeStmtNode(ASTSelectTypeStmtNode node) {
        super.traverseChildren(node);
        if (node.getAssociateName() != null) {
            this.addDefinition(node.getAssociateName(), Definition.Classification.VARIABLE_DECLARATION, Type.UNKNOWN);
        }
    }

    private void markExternalSubprogramExports(ASTExecutableProgramNode node) {
        for (IProgramUnit pu : node.getProgramUnitList()) {
            if (pu instanceof ASTSubroutineSubprogramNode) {
                ASTSubroutineSubprogramNode subroutine = (ASTSubroutineSubprogramNode)pu;
                this.markSubprogramExport(subroutine.getSubroutineStmt().getSubroutineName().getSubroutineName());
                continue;
            }
            if (!(pu instanceof ASTFunctionSubprogramNode)) continue;
            ASTFunctionSubprogramNode function = (ASTFunctionSubprogramNode)pu;
            this.markSubprogramExport(function.getFunctionStmt().getFunctionName().getFunctionName());
        }
    }

    private void markSubprogramExport(Token subprogramNameToken) {
        try {
            this.markSubprogramExport(this.file, subprogramNameToken);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void visitASTInterfaceBlockNode(ASTInterfaceBlockNode node) {
        super.visitASTInterfaceBlockNode(node);
        this.markMatchingDeclarationsInInterfacesForExtSubprog(node);
    }

    private void markMatchingDeclarationsInInterfacesForExtSubprog(ASTInterfaceBlockNode node) {
        for (IInterfaceSpecification pu : node.getInterfaceBlockBody()) {
            if (!(pu instanceof ASTInterfaceBodyNode)) continue;
            ASTInterfaceBodyNode b = (ASTInterfaceBodyNode)pu;
            Token name = b.getFunctionStmt() != null ? b.getFunctionStmt().getFunctionName().getFunctionName() : b.getSubroutineStmt().getSubroutineName().getSubroutineName();
            this.markSubprogramImport(name);
        }
    }

    private void markSubprogramImport(Token subprogramNameToken) {
        try {
            this.markSubprogramImport(this.file, subprogramNameToken);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

