/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import org.eclipse.photran.internal.core.analysis.binding.BindingCollector;
import org.eclipse.photran.internal.core.parser.ASTAccessStmtNode;
import org.eclipse.photran.internal.core.parser.ASTPrivateSequenceStmtNode;

class PrivateCollector
extends BindingCollector {
    PrivateCollector() {
    }

    public void visitASTAccessStmtNode(ASTAccessStmtNode node) {
        super.traverseChildren(node);
        if (node.getAccessIdList() == null && node.getAccessSpec().isPrivate()) {
            try {
                this.setScopeDefaultVisibilityToPrivate(node.getAccessSpec().findFirstToken().getEnclosingScope());
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    public void visitASTPrivateSequenceStmtNode(ASTPrivateSequenceStmtNode node) {
        super.traverseChildren(node);
        if (node.isPrivate()) {
            try {
                this.setScopeDefaultVisibilityToPrivate(node.getPrivateToken().getEnclosingScope());
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

