/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.photran.internal.ui.views.vpgproblems.Messages;
import org.eclipse.photran.internal.ui.views.vpgproblems.VPGProblemView;
import org.eclipse.rephraserengine.ui.WorkbenchSelectionInfo;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class SelectedResourceFilterAction
extends Action
implements ISelectionListener {
    private VPGProblemView vpgView;

    public SelectedResourceFilterAction(VPGProblemView vpgView) {
        super(Messages.SelectedResourceFilterAction_FilterBySelection, 2);
        this.vpgView = vpgView;
        this.setToolTipText(Messages.SelectedResourceFilterAction_FilterBySelectionTooltip);
        this.setChecked(false);
        vpgView.getTableViewer().addFilter((ViewerFilter)new MarkerResourceFilter());
        vpgView.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    void dispose() {
        this.vpgView.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void run() {
        this.vpgView.setErrorWarningFilterButtonText();
        this.refreshTableViewer();
    }

    private void refreshTableViewer() {
        this.vpgView.getTableViewer().refresh();
    }

    public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
        if (!(sourcepart instanceof VPGProblemView)) {
            this.refreshTableViewer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MarkerResourceFilter
    extends ViewerFilter {
        private MarkerResourceFilter() {
        }

        public boolean select(Viewer viewer, Object parentElem, Object elem) {
            if (!SelectedResourceFilterAction.this.isChecked()) {
                return true;
            }
            IMarker marker = (IMarker)elem;
            IPath markerPath = marker.getResource().getFullPath();
            for (IResource iResource : this.getSelectedResources()) {
                if (!iResource.getFullPath().isPrefixOf(markerPath)) continue;
                return true;
            }
            return false;
        }

        private List<? extends IResource> getSelectedResources() {
            WorkbenchSelectionInfo selectionInfo = new WorkbenchSelectionInfo(SelectedResourceFilterAction.this.vpgView.getSite().getWorkbenchWindow());
            List<IFile> selectedResources = selectionInfo.getSelectedResources();
            if (selectedResources.isEmpty() && selectionInfo.editingAnIFile()) {
                selectedResources = Collections.singletonList(selectionInfo.getFileInEditor());
            }
            return selectedResources;
        }
    }
}

