/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.variables;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlCorePlugin;
import org.eclipse.ptp.rm.jaxb.control.internal.variables.RMVariableResolver;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMVariableMap
implements IVariableMap {
    private static final Object monitor = new Object();
    private final Map<String, Object> variables = Collections.synchronizedMap(new TreeMap());
    private final Map<String, Object> discovered = Collections.synchronizedMap(new TreeMap());
    private boolean initialized = false;

    public static Map<Object, Object> getValidAttributes(ILaunchConfiguration config) throws CoreException {
        String rmId = config.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", "temp");
        rmId = String.valueOf(rmId) + ".";
        int len = rmId.length();
        Map attr = config.getAttributes();
        TreeMap<Object, Object> current = new TreeMap<Object, Object>();
        HashMap rmAttr = new HashMap();
        HashSet<String> include = new HashSet<String>();
        for (String name : attr.keySet()) {
            Object value = attr.get(name);
            if (value == null || "".equals(value)) continue;
            if (name.startsWith(rmId)) {
                if (RMVariableMap.isFixedValid(name = name.substring(len))) {
                    current.put(name, value);
                    continue;
                }
                rmAttr.put(name, value);
                continue;
            }
            if (!RMVariableMap.isExternal(name)) continue;
            current.put(name, value);
        }
        String id = (String)rmAttr.get("current_controller");
        String valid = (String)rmAttr.get("valid_" + id);
        if (valid != null) {
            String[] split;
            String[] stringArray = split = valid.split(" ");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                include.add(s);
                ++n2;
            }
        }
        for (Object var : rmAttr.keySet()) {
            Object value = rmAttr.get(var);
            if (!include.contains(var)) continue;
            current.put(var, value);
        }
        return current;
    }

    public static boolean isExternal(String name) {
        return name.startsWith("org.eclipse.debug") || name.startsWith("org.eclipse.ptp");
    }

    public static boolean isFixedValid(String name) {
        return name.startsWith("control.") || name.equals("directory") || name.equals("executablePath") || name.equals("executableDirectory") || name.equals("progArgs") || name.equals("debuggerExecutablePath") || name.equals("debuggerArgs") || name.equals("stdout_remote_path") || name.equals("stderr_remote_path");
    }

    public void clear() {
        this.variables.clear();
        this.discovered.clear();
        this.initialized = false;
    }

    public Object get(String name) {
        if (name == null) {
            return null;
        }
        Object o = this.variables.get(name);
        if (o == null) {
            o = this.discovered.get(name);
        }
        return o;
    }

    public Map<String, Object> getDiscovered() {
        return this.discovered;
    }

    public String getString(String value) {
        return this.getString(null, value);
    }

    public String getString(String jobId, String value) {
        try {
            if (jobId != null) {
                value = value.replaceAll("@jobId", jobId);
            }
            return this.dereference(value);
        }
        catch (CoreException t) {
            JAXBControlCorePlugin.log(t);
            return value;
        }
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void maybeAddProperty(String name, Object value, boolean visible) {
        if (name == null) {
            return;
        }
        Object o = this.get(name);
        PropertyType p = null;
        AttributeType a = null;
        if (o == null && value != null) {
            p = new PropertyType();
            this.variables.put(name, p);
        } else if (o instanceof PropertyType) {
            if (value != null) {
                p = (PropertyType)o;
            } else {
                this.remove(name);
            }
        } else if (o instanceof AttributeType) {
            if (value != null) {
                a = (AttributeType)o;
            } else {
                this.remove(name);
            }
        }
        if (p != null) {
            p.setName(name);
            p.setValue(value);
            p.setVisible(Boolean.valueOf(visible));
        } else if (a != null) {
            a.setName(name);
            a.setValue(value);
            a.setVisible(Boolean.valueOf(visible));
        }
    }

    public void maybeOverwrite(String key1, String key2, Map<String, Object> map, boolean defaultOverride) throws CoreException {
        Object value1 = null;
        Object value2 = null;
        String dValue = null;
        PropertyType p = (PropertyType)this.get(key1);
        if (p != null) {
            value1 = p.getValue();
            dValue = p.getDefault();
        }
        if ((value2 = map.get(key2)) == null || "".equals(value2)) {
            if (defaultOverride) {
                this.maybeAddProperty(key1, dValue, false);
            } else {
                this.maybeAddProperty(key1, value1, false);
            }
        } else {
            this.maybeAddProperty(key1, value2, false);
        }
    }

    public void put(String name, Object value) {
        if (name == null) {
            return;
        }
        this.variables.put(name, value);
    }

    public Object remove(String name) {
        if (name == null) {
            return null;
        }
        Object o = this.variables.remove(name);
        if (o == null) {
            o = this.discovered.remove(name);
        }
        return o;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dereference(String expression) throws CoreException {
        if (expression == null) {
            return null;
        }
        Object object = monitor;
        synchronized (object) {
            RMVariableResolver.setActive(this);
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
        }
    }
}

