/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.gem.popup.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.gem.GemPlugin;
import org.eclipse.ptp.gem.messages.Messages;
import org.eclipse.ptp.gem.util.GemUtilities;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class HbvLogFilePopUpAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        if (this.selection.toString().equals("<empty selection>")) {
            GemUtilities.showErrorDialog(Messages.HbvLogFilePopUpAction_0);
        } else {
            IFile logFile = (IFile)this.selection.getFirstElement();
            String projectName = logFile.getProject().getName();
            IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            String hbv = GemPlugin.getDefault().getPreferenceStore().getString("hbvPath");
            if (logFile.getLocation() == null) {
                GemUtilities.showErrorDialog(Messages.HbvLogFilePopUpAction_2);
                return;
            }
            GemUtilities.refreshProject(currentProject);
            if (logFile.exists()) {
                if (hbv != "") {
                    hbv = String.valueOf(hbv) + "/";
                }
                hbv = String.valueOf(hbv) + "ispUI " + logFile.getLocationURI().getPath();
                GemUtilities.runCommandAsThread(hbv);
            } else {
                GemUtilities.showErrorDialog(Messages.HbvLogFilePopUpAction_1);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

