/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.LazyCharArray;

public class FileCharArray
extends LazyCharArray {
    private static final String UTF8_CHARSET_NAME = "UTF-8";
    private String fFileName;
    private String fCharSet;
    private FileChannel fChannel;
    private long fNextFileOffset = 0L;
    private int fNextCharOffset = 0;
    private boolean fReachedEOF = false;

    public static AbstractCharArray create(String fileName, String charSet, InputStream in) throws IOException {
        FileChannel channel;
        long lsize;
        if (!(in instanceof FileInputStream)) {
            return null;
        }
        FileInputStream fis = (FileInputStream)in;
        if (!Charset.isSupported(charSet)) {
            charSet = System.getProperty("file.encoding");
        }
        if ((lsize = (channel = fis.getChannel()).size()) < 65536L) {
            return FileCharArray.decodeSmallFile(channel, (int)lsize, charSet);
        }
        return new FileCharArray(fileName, charSet);
    }

    private static AbstractCharArray decodeSmallFile(FileChannel channel, int lsize, String charSet) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(lsize);
        channel.read(byteBuffer);
        byteBuffer.flip();
        FileCharArray.skipUTF8ByteOrderMark(byteBuffer, charSet);
        CharBuffer charBuffer = Charset.forName(charSet).decode(byteBuffer);
        char[] buf = FileCharArray.extractChars(charBuffer);
        return new CharArray(buf);
    }

    private static void skipUTF8ByteOrderMark(ByteBuffer buf, String charset) {
        int pos;
        if (charset.equals(UTF8_CHARSET_NAME) && buf.remaining() >= 3 && buf.get(pos = buf.position()) == -17 && buf.get(++pos) == -69 && buf.get(++pos) == -65) {
            buf.position(++pos);
        }
    }

    private static char[] extractChars(CharBuffer charBuffer) {
        char[] buf;
        if (charBuffer.hasArray() && charBuffer.arrayOffset() == 0 && (buf = charBuffer.array()).length == charBuffer.remaining()) {
            return buf;
        }
        buf = new char[charBuffer.remaining()];
        charBuffer.get(buf);
        return buf;
    }

    private FileCharArray(String fileName, String charSet) {
        this.fFileName = fileName;
        this.fCharSet = charSet;
    }

    protected LazyCharArray.Chunk createChunk(int chunkNumber) {
        LazyCharArray.Chunk chunk;
        FileInputStream fis;
        try {
            fis = new FileInputStream(this.fFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        this.fChannel = fis.getChannel();
        try {
            chunk = super.createChunk(chunkNumber);
            this.fChannel = null;
        }
        catch (Throwable throwable) {
            this.fChannel = null;
            try {
                fis.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fis.close();
        }
        catch (IOException iOException) {}
        return chunk;
    }

    protected LazyCharArray.Chunk nextChunk() {
        boolean eof;
        CoderResult result;
        long fileOffset;
        CharBuffer dest;
        block8: {
            if (this.fReachedEOF) {
                return null;
            }
            try {
                assert (this.fChannel != null);
                Charset charset = Charset.forName(this.fCharSet);
                CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                int needBytes = 3 + (int)(65536.0 * (double)decoder.averageCharsPerByte());
                ByteBuffer in = ByteBuffer.allocate(needBytes);
                dest = CharBuffer.allocate(65536);
                fileOffset = this.fNextFileOffset;
                do {
                    in.clear();
                    this.fChannel.position(fileOffset);
                    this.fChannel.read(in);
                    eof = in.remaining() > 0;
                    in.flip();
                    if (fileOffset == 0L) {
                        FileCharArray.skipUTF8ByteOrderMark(in, this.fCharSet);
                    }
                    result = decoder.decode(in, dest, eof);
                    fileOffset += (long)in.position();
                } while (result == CoderResult.UNDERFLOW && !eof);
                dest.flip();
                if (dest.remaining() != 0) break block8;
                this.fReachedEOF = true;
                return null;
            }
            catch (Exception e) {
                CCorePlugin.log((Throwable)e);
                this.fReachedEOF = true;
                return null;
            }
        }
        if (eof && result == CoderResult.UNDERFLOW) {
            this.fReachedEOF = true;
        }
        char[] chars = FileCharArray.extractChars(dest);
        LazyCharArray.Chunk chunk = this.newChunk(this.fNextFileOffset, fileOffset, this.fNextCharOffset, chars);
        this.fNextFileOffset = fileOffset;
        this.fNextCharOffset += chars.length;
        return chunk;
    }

    protected void rereadChunkData(LazyCharArray.Chunk chunk, char[] dest) {
        block13: {
            FileInputStream fis;
            try {
                fis = new FileInputStream(this.fFileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            try {
                try {
                    FileChannel channel = fis.getChannel();
                    this.decode(channel, chunk.fSourceOffset, chunk.fSourceEndOffset, CharBuffer.wrap(dest));
                }
                catch (IOException iOException) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException2) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void decode(FileChannel channel, long fileOffset, long fileEndOffset, CharBuffer dest) throws IOException {
        Charset charset = Charset.forName(this.fCharSet);
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteBuffer in = ByteBuffer.allocate((int)(fileEndOffset - fileOffset));
        in.clear();
        channel.position(fileOffset);
        channel.read(in);
        in.flip();
        if (fileOffset == 0L) {
            FileCharArray.skipUTF8ByteOrderMark(in, this.fCharSet);
        }
        decoder.decode(in, dest, true);
    }
}

