/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CPPReferenceType
implements ICPPReferenceType,
ITypeContainer,
ISerializableType {
    private IType fType = null;
    private boolean fIsRValue;

    public CPPReferenceType(IType type, boolean isRValue) {
        this.fIsRValue = isRValue;
        this.setType(type);
    }

    public IType getType() {
        return this.fType;
    }

    public boolean isRValueReference() {
        return this.fIsRValue;
    }

    public void setType(IType t) {
        if (t instanceof ICPPReferenceType) {
            ICPPReferenceType rt = (ICPPReferenceType)t;
            this.fIsRValue = this.fIsRValue && rt.isRValueReference();
            t = rt.getType();
        }
        assert (t != null);
        this.fType = t;
    }

    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return ((ITypedef)obj).isSameType(this);
        }
        if (obj instanceof ICPPReferenceType) {
            ICPPReferenceType rhs = (ICPPReferenceType)obj;
            IType t1 = this.getType();
            IType t2 = rhs.getType();
            boolean rv1 = this.isRValueReference();
            boolean rv2 = rhs.isRValueReference();
            while (true) {
                if (t1 instanceof ITypedef) {
                    t1 = ((ITypedef)t1).getType();
                    continue;
                }
                if (!(t1 instanceof ICPPReferenceType)) break;
                rv1 = rv1 && ((ICPPReferenceType)t1).isRValueReference();
                t1 = ((ICPPReferenceType)t1).getType();
            }
            while (true) {
                if (t2 instanceof ITypedef) {
                    t2 = ((ITypedef)t2).getType();
                    continue;
                }
                if (!(t2 instanceof ICPPReferenceType)) break;
                rv2 = rv2 && ((ICPPReferenceType)t2).isRValueReference();
                t2 = ((ICPPReferenceType)t2).getType();
            }
            if (t1 == null) {
                return false;
            }
            return rv1 == rv2 && t1.isSameType(t2);
        }
        return false;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int firstByte = 6;
        if (this.isRValueReference()) {
            firstByte |= 0x10;
        }
        buffer.putByte((byte)firstByte);
        buffer.marshalType(this.getType());
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        return new CPPReferenceType(nested, (firstByte & 0x10) != 0);
    }
}

