/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPParameterSpecialization
extends PDOMCPPSpecialization
implements ICPPParameter {
    private static final int NEXT_PARAM = 40;
    private static final int RECORD_SIZE = 44;
    private final IType fType;

    public PDOMCPPParameterSpecialization(PDOMLinkage linkage, long record, IType t) {
        super(linkage, record);
        this.fType = t;
    }

    public PDOMCPPParameterSpecialization(PDOMLinkage linkage, PDOMCPPFunctionSpecialization parent, ICPPParameter astParam, PDOMCPPParameter original, PDOMCPPParameterSpecialization next) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)astParam), original);
        this.fType = null;
        Database db = this.getDB();
        db.putRecPtr(this.record + 40L, next == null ? 0L : next.getRecord());
    }

    protected int getRecordSize() {
        return 44;
    }

    public int getNodeType() {
        return 32;
    }

    long getNextPtr() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 40L);
        return rec;
    }

    public IType getType() {
        return this.fType;
    }

    protected IPDOMBinding loadSpecializedBinding(long record) throws CoreException {
        if (record == 0L) {
            return null;
        }
        IType type = null;
        IBinding parent = this.getParentBinding();
        if (parent instanceof ICPPSpecialization && parent instanceof ICPPFunction) {
            IType[] ptypes;
            ICPPFunctionType ftype;
            ICPPParameter[] pars = ((ICPPFunction)parent).getParameters();
            int parPos = -1;
            parPos = 0;
            while (parPos < pars.length) {
                ICPPParameter par = pars[parPos];
                if (this.equals(par)) break;
                ++parPos;
            }
            if (parPos < pars.length && (parent = ((ICPPSpecialization)parent).getSpecializedBinding()) instanceof ICPPFunction && (ftype = ((ICPPFunction)parent).getType()) != null && parPos < (ptypes = ftype.getParameterTypes()).length) {
                type = ptypes[parPos];
            }
        }
        return new PDOMCPPParameter((PDOMLinkage)this.getLinkage(), record, type);
    }

    private ICPPParameter getParameter() {
        return (ICPPParameter)this.getSpecializedBinding();
    }

    public boolean hasDefaultValue() {
        return this.getParameter().hasDefaultValue();
    }

    public boolean isParameterPack() {
        return this.getType() instanceof ICPPParameterPackType;
    }

    public boolean isAuto() {
        return this.getParameter().isAuto();
    }

    public boolean isRegister() {
        return this.getParameter().isRegister();
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public IValue getInitialValue() {
        return null;
    }
}

