/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.aif;

import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFactory;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeReference;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueNamed;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueReference;
import org.eclipse.ptp.debug.core.pdi.model.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.pdi.aif.ValueParent;

public class AIFValueReference
extends ValueParent
implements IAIFValueReference {
    private String name = null;

    public AIFValueReference(IValueParent parent, IAIFTypeReference type, AIFFactory.SimpleByteBuffer buffer) {
        super(parent, type);
        this.parse(buffer);
        this.name = type.getName();
    }

    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        this.setSize(this.getType().sizeof());
    }

    public String getName() {
        return this.name;
    }

    public String getValueString() throws AIFException {
        return this.getParent() == null ? Messages.AIFValueReference_0 : String.valueOf(Messages.AIFValueReference_1) + this.getName();
    }

    public IValueParent getParent() {
        if (this.parent instanceof IAIFValueNamed && ((IAIFValueNamed)this.parent).getName().equals(this.getName())) {
            return this.parent.getParent();
        }
        if (this.parent == null) {
            return null;
        }
        this.parent = this.parent.getParent();
        return this.getParent();
    }
}

