/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTConditionalExpression
extends ASTNode
implements IASTConditionalExpression,
IASTAmbiguityParent {
    private IASTExpression fCondition;
    private IASTExpression fPositive;
    private IASTExpression fNegative;
    private IType fType;
    private IASTExpression.ValueCategory fValueCategory;

    public CPPASTConditionalExpression() {
    }

    public CPPASTConditionalExpression(IASTExpression condition, IASTExpression postive, IASTExpression negative) {
        this.setLogicalConditionExpression(condition);
        this.setPositiveResultExpression(postive);
        this.setNegativeResultExpression(negative);
    }

    public CPPASTConditionalExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTConditionalExpression copy(IASTNode.CopyStyle style) {
        CPPASTConditionalExpression copy = new CPPASTConditionalExpression();
        copy.setLogicalConditionExpression(this.fCondition == null ? null : this.fCondition.copy(style));
        copy.setPositiveResultExpression(this.fPositive == null ? null : this.fPositive.copy(style));
        copy.setNegativeResultExpression(this.fNegative == null ? null : this.fNegative.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTExpression getLogicalConditionExpression() {
        return this.fCondition;
    }

    public void setLogicalConditionExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fCondition = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(LOGICAL_CONDITION);
        }
    }

    public IASTExpression getPositiveResultExpression() {
        return this.fPositive;
    }

    public void setPositiveResultExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fPositive = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(POSITIVE_RESULT);
        }
    }

    public IASTExpression getNegativeResultExpression() {
        return this.fNegative;
    }

    public void setNegativeResultExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fNegative = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NEGATIVE_RESULT);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fCondition != null && !this.fCondition.accept(action)) {
            return false;
        }
        if (this.fPositive != null && !this.fPositive.accept(action)) {
            return false;
        }
        if (this.fNegative != null && !this.fNegative.accept(action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fCondition) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fCondition = (IASTExpression)other;
        }
        if (child == this.fPositive) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fPositive = (IASTExpression)other;
        }
        if (child == this.fNegative) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fNegative = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        this.evaluate();
        return this.fType;
    }

    public IASTExpression.ValueCategory getValueCategory() {
        this.evaluate();
        return this.fValueCategory;
    }

    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    private void evaluate() {
        if (this.fValueCategory != null) {
            return;
        }
        this.fValueCategory = IASTExpression.ValueCategory.PRVALUE;
        IASTExpression expr2 = this.getPositiveResultExpression();
        IASTExpression expr3 = this.getNegativeResultExpression();
        if (expr2 == null) {
            expr2 = this.getLogicalConditionExpression();
        }
        IType t2 = expr2.getExpressionType();
        IType t3 = expr3.getExpressionType();
        if (t2 == null || t3 == null) {
            this.fType = new ProblemType(10004);
            return;
        }
        IType uqt2 = SemanticUtil.getNestedType(t2, 7);
        IType uqt3 = SemanticUtil.getNestedType(t3, 7);
        if (uqt2 instanceof ISemanticProblem || uqt2 instanceof ICPPUnknownType) {
            this.fType = uqt2;
            return;
        }
        if (uqt3 instanceof ISemanticProblem || uqt3 instanceof ICPPUnknownType) {
            this.fType = uqt3;
            return;
        }
        boolean void2 = this.isVoidType(uqt2);
        boolean void3 = this.isVoidType(uqt3);
        if (void2 || void3) {
            this.fType = this.isThrowExpression(expr2) ? Conversions.lvalue_to_rvalue(t3) : (this.isThrowExpression(expr3) ? Conversions.lvalue_to_rvalue(t2) : (void2 && void3 ? uqt2 : new ProblemType(10004)));
            return;
        }
        IASTExpression.ValueCategory vcat2 = expr2.getValueCategory();
        IASTExpression.ValueCategory vcat3 = expr3.getValueCategory();
        if (t2.isSameType(t3)) {
            if (vcat2 == vcat3) {
                this.fType = t2;
                this.fValueCategory = vcat2;
            } else {
                this.fType = ExpressionTypes.prvalueType(t2);
                this.fValueCategory = IASTExpression.ValueCategory.PRVALUE;
            }
            return;
        }
        boolean isClassType2 = uqt2 instanceof ICPPClassType;
        boolean isClassType3 = uqt3 instanceof ICPPClassType;
        if (isClassType2 || isClassType3) {
            Cost cost2 = this.convertToMatch(t2, vcat2, uqt2, t3, vcat3, uqt3);
            Cost cost3 = this.convertToMatch(t3, vcat3, uqt3, t2, vcat2, uqt2);
            if (cost2.converts() || cost3.converts()) {
                if (cost2.converts()) {
                    if (cost3.converts() || cost2.isAmbiguousUDC()) {
                        this.fType = new ProblemType(10004);
                    }
                } else if (cost3.isAmbiguousUDC()) {
                    this.fType = new ProblemType(10004);
                }
                return;
            }
        } else if (vcat2 == vcat3 && vcat2.isGLValue() && uqt2.isSameType(uqt3)) {
            CVQualifier cv3;
            CVQualifier cv2 = SemanticUtil.getCVQualifier(t2);
            if (cv2.isAtLeastAsQualifiedAs(cv3 = SemanticUtil.getCVQualifier(t3))) {
                this.fType = t2;
                this.fValueCategory = vcat2;
            } else if (cv3.isAtLeastAsQualifiedAs(cv2)) {
                this.fType = t3;
                this.fValueCategory = vcat3;
            } else {
                this.fType = new ProblemType(10004);
            }
            return;
        }
        if (isClassType2 || isClassType3) {
            ICPPFunction builtin = CPPSemantics.findOverloadedConditionalOperator(expr2, expr3);
            this.fType = builtin != null ? ExpressionTypes.typeFromFunctionCall(builtin) : new ProblemType(10004);
            return;
        }
        if ((t2 = Conversions.lvalue_to_rvalue(t2)).isSameType(t3 = Conversions.lvalue_to_rvalue(t3))) {
            this.fType = t2;
        } else {
            this.fType = CPPArithmeticConversion.convertCppOperandTypes(4, t2, t3);
            if (this.fType == null) {
                this.fType = Conversions.compositePointerType(t2, t3);
                if (this.fType == null) {
                    this.fType = new ProblemType(10004);
                }
            }
        }
    }

    private boolean isThrowExpression(IASTExpression expr) {
        while (expr instanceof IASTUnaryExpression) {
            IASTUnaryExpression unaryExpr = (IASTUnaryExpression)expr;
            int op = unaryExpr.getOperator();
            if (op == 12) {
                return true;
            }
            if (op == 11) {
                expr = unaryExpr.getOperand();
                continue;
            }
            return false;
        }
        return false;
    }

    private Cost convertToMatch(IType t1, IASTExpression.ValueCategory vcat1, IType uqt1, IType t2, IASTExpression.ValueCategory vcat2, IType uqt2) {
        try {
            Cost c;
            CPPReferenceType target;
            Cost c2;
            if (vcat2.isGLValue() && (c2 = Conversions.checkImplicitConversionSequence(target = new CPPReferenceType(t2, vcat2 == IASTExpression.ValueCategory.XVALUE), t1, vcat1, Conversions.UDCMode.ALLOWED, Conversions.Context.REQUIRE_DIRECT_BINDING)).converts()) {
                this.fType = t2;
                this.fValueCategory = vcat2;
                return c2;
            }
            if (uqt1 instanceof ICPPClassType && uqt2 instanceof ICPPClassType) {
                int dist = SemanticUtil.calculateInheritanceDepth(uqt1, uqt2);
                if (dist >= 0) {
                    CVQualifier cv1 = SemanticUtil.getCVQualifier(t1);
                    CVQualifier cv2 = SemanticUtil.getCVQualifier(t2);
                    if (cv2.isAtLeastAsQualifiedAs(cv1)) {
                        this.fType = t2;
                        this.fValueCategory = IASTExpression.ValueCategory.PRVALUE;
                        return new Cost(t1, t2, Cost.Rank.IDENTITY);
                    }
                    return Cost.NO_CONVERSION;
                }
                if (SemanticUtil.calculateInheritanceDepth(uqt2, uqt1) >= 0) {
                    return Cost.NO_CONVERSION;
                }
            }
            if (vcat2 != IASTExpression.ValueCategory.PRVALUE) {
                t2 = Conversions.lvalue_to_rvalue(t2);
            }
            if ((c = Conversions.checkImplicitConversionSequence(t2, t1, vcat1, Conversions.UDCMode.ALLOWED, Conversions.Context.ORDINARY)).converts()) {
                this.fType = t2;
                this.fValueCategory = IASTExpression.ValueCategory.PRVALUE;
                return c;
            }
        }
        catch (DOMException dOMException) {}
        return Cost.NO_CONVERSION;
    }

    private boolean isVoidType(IType t) {
        return t instanceof ICPPBasicType && ((ICPPBasicType)t).getKind() == IBasicType.Kind.eVoid;
    }
}

