/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTExpressionStatement
extends ASTNode
implements IASTExpressionStatement,
IASTAmbiguityParent {
    private IASTExpression expression;

    public CPPASTExpressionStatement() {
    }

    public CPPASTExpressionStatement(IASTExpression expression) {
        this.setExpression(expression);
    }

    public CPPASTExpressionStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTExpressionStatement copy(IASTNode.CopyStyle style) {
        CPPASTExpressionStatement copy = new CPPASTExpressionStatement();
        copy.setExpression(this.expression == null ? null : this.expression.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTExpression getExpression() {
        return this.expression;
    }

    public void setExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.expression = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(EXPRESSION);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.expression != null && !this.expression.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.expression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.expression = (IASTExpression)other;
        }
    }
}

