/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.Serializable;
import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;

public class RemoteIndexFileLocation
implements IIndexFileLocation,
Serializable {
    private static final long serialVersionUID = 1L;
    URI fURI;
    String fPath;

    public RemoteIndexFileLocation(String path, URI uri) {
        this.fURI = uri;
        this.fPath = null;
    }

    public RemoteIndexFileLocation(IIndexFileLocation location) {
        if (location != null) {
            this.fURI = location.getURI();
            this.fPath = location.getFullPath();
        }
    }

    public String getFullPath() {
        return this.fPath;
    }

    public URI getURI() {
        return this.fURI;
    }

    public String toString() {
        if (this.fURI != null) {
            return this.fURI.toString();
        }
        if (this.fPath != null) {
            return this.fPath.toString();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (!(o instanceof IIndexFileLocation)) {
            return false;
        }
        IIndexFileLocation other = (IIndexFileLocation)o;
        String fullPath = other.getFullPath();
        URI uri = other.getURI();
        if (this.fPath == null && fullPath != null) {
            return false;
        }
        if (this.fURI == null && this.fURI != null) {
            return false;
        }
        if (this.fPath != null && !this.fPath.equals(fullPath)) {
            return false;
        }
        return this.fURI == null || this.fURI.equals(uri);
    }

    public int hashCode() {
        int pathHash = this.fPath != null ? this.fPath.hashCode() : 0;
        int uriHash = this.fURI != null ? this.fURI.hashCode() : 0;
        return pathHash * 31 + uriHash;
    }
}

