/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.SyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceModelManager;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.core.ServicesCorePlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncManager {
    private static final IServiceModelManager serviceModel = ServiceModelManager.getInstance();
    private static final IService syncService = serviceModel.getService("org.eclipse.ptp.rdt.sync.core.SyncService");
    private static final String DEFAULT_SAVE_FILE_NAME = "SyncManagerData.xml";
    private static final String SYNC_MANAGER_ELEMENT_NAME = "sync-manager-data";
    private static final String SYNC_MODE_ELEMENT_NAME = "project-to-sync-mode";
    private static final String SHOW_ERROR_ELEMENT_NAME = "project-to-show-error";
    private static final String ATTR_PROJECT_NAME = "project";
    private static final String ATTR_SYNC_MODE = "sync-mode";
    private static final String ATTR_SHOW_ERROR = "show-error";
    private static final String ATTR_AUTO_SYNC = "auto-sync";
    private static boolean fSyncAuto = true;
    private static final Map<IProject, SYNC_MODE> fProjectToSyncModeMap = Collections.synchronizedMap(new HashMap());
    private static final Map<IProject, Boolean> fProjectToShowErrorMap = Collections.synchronizedMap(new HashMap());

    static {
        try {
            SyncManager.loadConfigurationData();
        }
        catch (WorkbenchException e) {
            SyncManager.handleInitError(e);
        }
        catch (IOException e) {
            SyncManager.handleInitError(e);
        }
    }

    private static void handleInitError(Throwable e) {
        RDTSyncCorePlugin.log(Messages.SyncManager_1, e);
    }

    public static SYNC_MODE getSyncMode(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        if (!fProjectToSyncModeMap.containsKey(project)) {
            fProjectToSyncModeMap.put(project, SYNC_MODE.ACTIVE);
            try {
                SyncManager.saveConfigurationData();
            }
            catch (IOException e) {
                RDTSyncCorePlugin.log(Messages.SyncManager_2, e);
            }
        }
        return fProjectToSyncModeMap.get(project);
    }

    public static boolean getSyncAuto() {
        return fSyncAuto;
    }

    public static boolean getShowErrors(IProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        if (!fProjectToShowErrorMap.containsKey(project)) {
            fProjectToShowErrorMap.put(project, true);
            try {
                SyncManager.saveConfigurationData();
            }
            catch (IOException e) {
                RDTSyncCorePlugin.log(Messages.SyncManager_2, e);
            }
        }
        return fProjectToShowErrorMap.get(project);
    }

    public static void setSyncMode(IProject project, SYNC_MODE mode) {
        fProjectToSyncModeMap.put(project, mode);
        try {
            SyncManager.saveConfigurationData();
        }
        catch (IOException e) {
            RDTSyncCorePlugin.log(Messages.SyncManager_2, e);
        }
    }

    public static void setSyncAuto(boolean isSyncAutomatic) {
        fSyncAuto = isSyncAutomatic;
        try {
            SyncManager.saveConfigurationData();
        }
        catch (IOException e) {
            RDTSyncCorePlugin.log(Messages.SyncManager_2, e);
        }
    }

    public static void setShowErrors(IProject project, boolean shouldBeDisplayed) {
        fProjectToShowErrorMap.put(project, shouldBeDisplayed);
        try {
            SyncManager.saveConfigurationData();
        }
        catch (IOException e) {
            RDTSyncCorePlugin.log(Messages.SyncManager_2, e);
        }
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public static Job sync(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, SyncExceptionHandler seHandler) throws CoreException {
        return SyncManager.sync(delta, project, syncFlags, false, seHandler, null);
    }

    public static Job syncBlocking(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, IProgressMonitor monitor) throws CoreException {
        return SyncManager.sync(delta, project, syncFlags, true, null, monitor);
    }

    private static Job sync(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, boolean isBlocking, SyncExceptionHandler seHandler, IProgressMonitor monitor) throws CoreException {
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        if (!bcm.isInitialized(project)) {
            return null;
        }
        IConfiguration[] buildConfigurations = new IConfiguration[]{ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration()};
        Job[] syncJobs = SyncManager.scheduleSyncJobs(delta, project, syncFlags, buildConfigurations, isBlocking, seHandler, monitor);
        return syncJobs[0];
    }

    public static Job[] syncAll(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, SyncExceptionHandler seHandler) throws CoreException {
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        if (!bcm.isInitialized(project)) {
            return new Job[0];
        }
        return SyncManager.scheduleSyncJobs(delta, project, syncFlags, ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations(), false, seHandler, null);
    }

    private static Job[] scheduleSyncJobs(IResourceDelta delta, IProject project, EnumSet<SyncFlag> syncFlags, IConfiguration[] buildConfigurations, boolean isBlocking, SyncExceptionHandler seHandler, IProgressMonitor monitor) throws CoreException {
        int jobNum = 0;
        Job[] syncJobs = new Job[buildConfigurations.length];
        BuildConfigurationManager bcm = BuildConfigurationManager.getInstance();
        IConfiguration[] iConfigurationArray = buildConfigurations;
        int n = buildConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration buildConfig = iConfigurationArray[n2];
            SynchronizeJob job = null;
            IServiceConfiguration serviceConfig = bcm.getConfigurationForBuildConfiguration(buildConfig);
            if (serviceConfig != null) {
                ISyncServiceProvider provider = (ISyncServiceProvider)serviceConfig.getServiceProvider(syncService);
                if (provider != null) {
                    if (isBlocking) {
                        provider.synchronize(delta, monitor, syncFlags);
                    } else {
                        job = new SynchronizeJob(delta, provider, syncFlags, seHandler);
                        job.schedule();
                    }
                }
            } else {
                RDTSyncCorePlugin.log(String.valueOf(Messages.SyncManager_7) + buildConfig.getName());
            }
            syncJobs[jobNum] = job;
            ++jobNum;
            ++n2;
        }
        return syncJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void saveConfigurationData() throws IOException {
        XMLMemento rootMemento = XMLMemento.createWriteRoot((String)SYNC_MANAGER_ELEMENT_NAME);
        Map<IProject, Object> map = fProjectToSyncModeMap;
        synchronized (map) {
            for (IProject project : fProjectToSyncModeMap.keySet()) {
                IMemento modeMemento = rootMemento.createChild(SYNC_MODE_ELEMENT_NAME);
                modeMemento.putString(ATTR_PROJECT_NAME, project.getName());
                modeMemento.putString(ATTR_SYNC_MODE, fProjectToSyncModeMap.get(project).name());
            }
        }
        map = fProjectToShowErrorMap;
        synchronized (map) {
            for (IProject project : fProjectToShowErrorMap.keySet()) {
                IMemento showErrorMemento = rootMemento.createChild(SHOW_ERROR_ELEMENT_NAME);
                showErrorMemento.putString(ATTR_PROJECT_NAME, project.getName());
                showErrorMemento.putBoolean(ATTR_SHOW_ERROR, fProjectToShowErrorMap.get(project).booleanValue());
            }
        }
        rootMemento.putBoolean(ATTR_AUTO_SYNC, fSyncAuto);
        IPath savePath = ServicesCorePlugin.getDefault().getStateLocation().append(DEFAULT_SAVE_FILE_NAME);
        File saveFile = savePath.toFile();
        rootMemento.save((Writer)new FileWriter(saveFile));
    }

    private static void loadConfigurationData() throws IOException, WorkbenchException {
        IProject project;
        String projectName;
        IPath loadPath = ServicesCorePlugin.getDefault().getStateLocation().append(DEFAULT_SAVE_FILE_NAME);
        File loadFile = loadPath.toFile();
        if (!loadFile.exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(loadFile));
        XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)reader);
        fProjectToSyncModeMap.clear();
        IMemento[] iMementoArray = rootMemento.getChildren(SYNC_MODE_ELEMENT_NAME);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento modeMemento = iMementoArray[n2];
            projectName = modeMemento.getString(ATTR_PROJECT_NAME);
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                throw new RuntimeException(String.valueOf(Messages.SyncManager_0) + project);
            }
            String syncModeString = modeMemento.getString(ATTR_SYNC_MODE);
            SYNC_MODE syncMode = SYNC_MODE.valueOf(syncModeString);
            fProjectToSyncModeMap.put(project, syncMode);
            ++n2;
        }
        fProjectToShowErrorMap.clear();
        iMementoArray = rootMemento.getChildren(SHOW_ERROR_ELEMENT_NAME);
        n = iMementoArray.length;
        n2 = 0;
        while (n2 < n) {
            IMemento showErrorMemento = iMementoArray[n2];
            projectName = showErrorMemento.getString(ATTR_PROJECT_NAME);
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                throw new RuntimeException(String.valueOf(Messages.SyncManager_0) + project);
            }
            fProjectToShowErrorMap.put(project, showErrorMemento.getBoolean(ATTR_SHOW_ERROR));
            ++n2;
        }
        fSyncAuto = rootMemento.getBoolean(ATTR_AUTO_SYNC);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SYNC_MODE {
        ACTIVE,
        ALL,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizeJob
    extends Job {
        private final ISyncServiceProvider fSyncProvider;
        private final IResourceDelta fDelta;
        private final EnumSet<SyncFlag> fSyncFlags;
        private final SyncExceptionHandler fSyncExceptionHandler;

        public SynchronizeJob(IResourceDelta delta, ISyncServiceProvider provider, EnumSet<SyncFlag> syncFlags, SyncExceptionHandler seHandler) {
            super(Messages.SyncManager_4);
            this.fDelta = delta;
            this.fSyncProvider = provider;
            this.fSyncFlags = syncFlags;
            this.fSyncExceptionHandler = seHandler;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                try {
                    this.fSyncProvider.synchronize(this.fDelta, (IProgressMonitor)progress.newChild(100), this.fSyncFlags);
                }
                catch (CoreException e) {
                    if (this.fSyncExceptionHandler == null) {
                        System.out.println(String.valueOf(Messages.SyncManager_8) + e.getLocalizedMessage());
                    } else {
                        this.fSyncExceptionHandler.handle(e);
                    }
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

