/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ptp.internal.rdt.ui.RSEUtils;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.serviceproviders.IRemoteToolsIndexServiceProvider;
import org.eclipse.ptp.rdt.ui.serviceproviders.RSECIndexServiceProvider;
import org.eclipse.ptp.rdt.ui.serviceproviders.RemoteBuildServiceProvider;
import org.eclipse.ptp.rdt.ui.wizards.NewRemoteProjectCreationPage;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.widgets.AddServiceConfigurationWidget;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceModelWizardPage
extends MBSCustomPage {
    public static final String SERVICE_MODEL_WIZARD_PAGE_ID = "org.eclipse.ptp.rdt.ui.serviceModelWizardPage";
    public static final String DEFAULT_CONFIG = Messages.getString("ConfigureRemoteServices.0");
    public static final String CONFIG_PROPERTY = "org.eclipse.ptp.rdt.ui.ServiceModelWizardPage.serviceConfig";
    boolean fbVisited;
    private String fTitle;
    private String fDescription;
    private ImageDescriptor fImageDescriptor;
    private Image fImage;
    private IServiceConfiguration fNewConfig;
    private Control pageControl;
    private AddServiceConfigurationWidget serviceConfigWidget;

    public ServiceModelWizardPage(String pageID) {
        super(pageID);
    }

    protected Set<IService> getContributedServices() {
        ServiceModelManager smm = ServiceModelManager.getInstance();
        Set cppServices = smm.getServices("org.eclipse.cdt.core.ccnature");
        Set cServices = smm.getServices("org.eclipse.cdt.core.cnature");
        LinkedHashSet<IService> allApplicableServices = new LinkedHashSet<IService>();
        allApplicableServices.addAll(cppServices);
        allApplicableServices.addAll(cServices);
        return allApplicableServices;
    }

    public ServiceModelWizardPage() {
        this(SERVICE_MODEL_WIZARD_PAGE_ID);
    }

    protected boolean isCustomPageComplete() {
        return this.fbVisited;
    }

    public String getName() {
        return Messages.getString("ServiceModelWizardPage_0");
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(1808));
        this.pageControl = comp;
        this.serviceConfigWidget = new AddServiceConfigurationWidget(comp, 0);
        GridData data = new GridData(1808);
        this.serviceConfigWidget.setLayoutData((Object)data);
        this.serviceConfigWidget.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServiceModelWizardPage.this.updateConfigPageProperty();
            }
        });
        this.serviceConfigWidget.setDefaultConfiguration(this.getNewConfiguration());
        this.serviceConfigWidget.setSelection(true);
        this.updateConfigPageProperty();
    }

    private void updateConfigPageProperty() {
        IServiceConfiguration config = this.serviceConfigWidget.getServiceConfiguration();
        MBSCustomPageManager.addPageProperty((String)SERVICE_MODEL_WIZARD_PAGE_ID, (String)CONFIG_PROPERTY, (Object)config);
    }

    private String getDefaultConfigName() {
        String candidateName = DEFAULT_CONFIG;
        IWizardPage page = this.getWizard().getStartingPage();
        if (page instanceof NewRemoteProjectCreationPage) {
            NewRemoteProjectCreationPage cdtPage = (NewRemoteProjectCreationPage)page;
            candidateName = cdtPage.getRemoteConnection().getName();
        }
        Set configs = ServiceModelManager.getInstance().getConfigurations();
        HashSet<String> existingNames = new HashSet<String>();
        for (IServiceConfiguration config : configs) {
            existingNames.add(config.getName());
        }
        int i = 2;
        String newConfigName = candidateName;
        while (existingNames.contains(newConfigName)) {
            newConfigName = String.valueOf(candidateName) + " (" + i++ + ")";
        }
        return newConfigName;
    }

    private IServiceConfiguration getNewConfiguration() {
        if (this.fNewConfig == null) {
            ServiceModelManager smm = ServiceModelManager.getInstance();
            this.fNewConfig = smm.newServiceConfiguration(this.getDefaultConfigName());
            IWizardPage page = this.getWizard().getStartingPage();
            if (page instanceof NewRemoteProjectCreationPage) {
                IRemoteToolsIndexServiceProvider provider;
                NewRemoteProjectCreationPage cdtPage = (NewRemoteProjectCreationPage)page;
                IRemoteServices remoteServices = cdtPage.getRemoteServices();
                IRemoteConnection remoteConnection = cdtPage.getRemoteConnection();
                IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
                IServiceProviderDescriptor descriptor = buildService.getProviderDescriptor("org.eclipse.ptp.rdt.ui.RemoteBuildServiceProvider");
                RemoteBuildServiceProvider rbsp = (RemoteBuildServiceProvider)smm.getServiceProvider(descriptor);
                if (rbsp != null) {
                    rbsp.setRemoteToolsConnection(remoteConnection);
                    this.fNewConfig.setServiceProvider(buildService, (IServiceProvider)rbsp);
                }
                IService indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService");
                if (remoteServices.getId().equals("org.eclipse.ptp.remote.RSERemoteServices")) {
                    descriptor = indexingService.getProviderDescriptor("org.eclipse.ptp.rdt.ui.RSECIndexServiceProvider");
                    RSECIndexServiceProvider provider2 = (RSECIndexServiceProvider)smm.getServiceProvider(descriptor);
                    if (provider2 != null) {
                        String hostName = remoteConnection.getAddress();
                        IHost host = RSEUtils.getConnection(hostName);
                        String configPath = RSEUtils.getDefaultConfigDirectory(host);
                        provider2.setConnection(host, this.getDStoreConnectorService(host));
                        provider2.setIndexLocation(configPath);
                        provider2.setConfigured(true);
                        this.fNewConfig.setServiceProvider(indexingService, (IServiceProvider)provider2);
                    }
                } else if (remoteServices.getId().equals("org.eclipse.ptp.remote.RemoteTools") && (provider = (IRemoteToolsIndexServiceProvider)smm.getServiceProvider(descriptor = indexingService.getProviderDescriptor("org.eclipse.ptp.rdt.server.dstore.RemoteToolsCIndexServiceProvider"))) != null) {
                    provider.setConnection(remoteConnection);
                    this.fNewConfig.setServiceProvider(indexingService, (IServiceProvider)provider);
                }
            }
        }
        return this.fNewConfig;
    }

    private IConnectorService getDStoreConnectorService(IHost host) {
        IConnectorService[] iConnectorServiceArray = host.getConnectorServices();
        int n = iConnectorServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService cs = iConnectorServiceArray[n2];
            if (cs instanceof DStoreConnectorService) {
                return cs;
            }
            ++n2;
        }
        return null;
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.pageControl;
    }

    public String getDescription() {
        if (this.fDescription == null) {
            this.fDescription = Messages.getString("ServiceModelWizardPage_description");
        }
        return this.fDescription;
    }

    public String getErrorMessage() {
        return null;
    }

    public Image getImage() {
        if (this.fImage == null && this.fImageDescriptor != null) {
            this.fImage = this.fImageDescriptor.createImage();
        }
        if (this.fImage == null && this.wizard != null) {
            this.fImage = this.wizard.getDefaultPageImage();
        }
        return this.fImage;
    }

    public String getMessage() {
        return null;
    }

    public String getTitle() {
        if (this.fTitle == null) {
            this.fTitle = Messages.getString("ServiceModelWizardPage_0");
        }
        return this.fTitle;
    }

    public void performHelp() {
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public void setImageDescriptor(ImageDescriptor image) {
        this.fImageDescriptor = image;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fbVisited = true;
        }
    }
}

