/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rtsystem.events;

import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.attributes.MessageAttributes;
import org.eclipse.ptp.rtsystem.events.IRuntimeMessageEvent;

public class RuntimeMessageEvent
implements IRuntimeMessageEvent {
    AttributeManager attributes;

    public RuntimeMessageEvent(AttributeManager attrs) {
        if (attrs.getAttribute(MessageAttributes.getLevelAttributeDefinition()) == null) {
            attrs.addAttribute(MessageAttributes.getLevelAttributeDefinition().create());
        }
        if (attrs.getAttribute(MessageAttributes.getCodeAttributeDefinition()) == null) {
            try {
                attrs.addAttribute(MessageAttributes.getCodeAttributeDefinition().create());
            }
            catch (IllegalValueException illegalValueException) {}
        }
        if (attrs.getAttribute(MessageAttributes.getTextAttributeDefinition()) == null) {
            attrs.addAttribute(MessageAttributes.getTextAttributeDefinition().create());
        }
        this.attributes = attrs;
    }

    public RuntimeMessageEvent(MessageAttributes.Level level, String text) {
        AttributeManager attrs = new AttributeManager();
        attrs.addAttribute(MessageAttributes.getLevelAttributeDefinition().create(level));
        attrs.addAttribute(MessageAttributes.getTextAttributeDefinition().create(text));
        try {
            attrs.addAttribute(MessageAttributes.getCodeAttributeDefinition().create());
        }
        catch (IllegalValueException illegalValueException) {}
        this.attributes = attrs;
    }

    public AttributeManager getAttributes() {
        return this.attributes;
    }

    public int getCode() {
        IntegerAttribute code = (IntegerAttribute)this.attributes.getAttribute(MessageAttributes.getCodeAttributeDefinition());
        return code.getValue();
    }

    public MessageAttributes.Level getLevel() {
        EnumeratedAttribute level = (EnumeratedAttribute)this.attributes.getAttribute(MessageAttributes.getLevelAttributeDefinition());
        return (MessageAttributes.Level)((Object)level.getValue());
    }

    public String getText() {
        StringAttribute text = (StringAttribute)this.attributes.getAttribute(MessageAttributes.getTextAttributeDefinition());
        return text.getValue();
    }
}

