/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipantDescriptor;
import org.eclipse.ptp.rdt.sync.ui.SynchronizeParticipantRegistry;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRemoteSyncProjectWizardPage
extends MBSCustomPage {
    public static final String REMOTE_SYNC_WIZARD_PAGE_ID = "org.eclipse.ptp.rdt.sync.ui.remoteSyncWizardPage";
    public static final String SERVICE_PROVIDER_PROPERTY = "org.eclipse.ptp.rdt.sync.ui.remoteSyncWizardPage.serviceProvider";
    private boolean fbVisited;
    private String fTitle;
    private String fDescription;
    private ImageDescriptor fImageDescriptor;
    private Image fImage;
    private ISynchronizeParticipantDescriptor fSelectedProvider;
    private Control pageControl;
    private Combo fProviderCombo;
    private Composite fProviderArea;
    private StackLayout fProviderStack;
    private final List<Composite> fProviderControls = new ArrayList<Composite>();
    private final Map<Integer, ISynchronizeParticipantDescriptor> fComboIndexToDescriptorMap = new HashMap<Integer, ISynchronizeParticipantDescriptor>();

    public NewRemoteSyncProjectWizardPage() {
        this(REMOTE_SYNC_WIZARD_PAGE_ID);
    }

    public NewRemoteSyncProjectWizardPage(String pageID) {
        super(pageID);
    }

    private void addProviderControl(ISynchronizeParticipantDescriptor desc) {
        Composite comp = null;
        ISynchronizeParticipant part = desc.getParticipant();
        if (part != null) {
            comp = new Composite(this.fProviderArea, 0);
            comp.setLayout((Layout)new GridLayout(1, false));
            comp.setLayoutData((Object)new GridData(4, 4, true, true));
            part.createConfigurationArea(comp, (IRunnableContext)this.getWizard().getContainer());
        }
        this.fProviderControls.add(comp);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.pageControl = comp;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        comp.setLayoutData((Object)gd);
        Label providerLabel = new Label(comp, 16384);
        providerLabel.setText(Messages.NewRemoteSyncProjectWizardPage_syncProvider);
        this.fProviderCombo = new Combo(comp, 12);
        this.fProviderCombo.setLayoutData((Object)new GridData(1, 1, false, false));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProviderCombo.setLayoutData((Object)gd);
        this.fProviderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRemoteSyncProjectWizardPage.this.handleProviderSelected();
            }
        });
        this.fProviderArea = new Group(comp, 16);
        this.fProviderStack = new StackLayout();
        this.fProviderArea.setLayout((Layout)this.fProviderStack);
        GridData providerAreaData = new GridData(4, 4, true, true);
        providerAreaData.horizontalSpan = 3;
        this.fProviderArea.setLayoutData((Object)providerAreaData);
        ISynchronizeParticipantDescriptor[] providers = SynchronizeParticipantRegistry.getDescriptors();
        int k = 0;
        while (k < providers.length) {
            this.fProviderCombo.add(providers[k].getName(), k);
            this.fComboIndexToDescriptorMap.put(k, providers[k]);
            this.addProviderControl(providers[k]);
            ++k;
        }
        this.fProviderCombo.select(0);
        this.handleProviderSelected();
    }

    public void dispose() {
    }

    protected Set<IService> getContributedServices() {
        ServiceModelManager smm = ServiceModelManager.getInstance();
        Set cppServices = smm.getServices("org.eclipse.cdt.core.ccnature");
        Set cServices = smm.getServices("org.eclipse.cdt.core.cnature");
        LinkedHashSet<IService> allApplicableServices = new LinkedHashSet<IService>();
        allApplicableServices.addAll(cppServices);
        allApplicableServices.addAll(cServices);
        return allApplicableServices;
    }

    public Control getControl() {
        return this.pageControl;
    }

    public String getDescription() {
        if (this.fDescription == null) {
            this.fDescription = Messages.RemoteSyncWizardPage_description;
        }
        return this.fDescription;
    }

    public String getErrorMessage() {
        if (this.fSelectedProvider == null) {
            return Messages.ConvertToSyncProjectWizardPage_0;
        }
        return this.fSelectedProvider.getParticipant().getErrorMessage();
    }

    public Image getImage() {
        if (this.fImage == null && this.fImageDescriptor != null) {
            this.fImage = this.fImageDescriptor.createImage();
        }
        if (this.fImage == null && this.wizard != null) {
            this.fImage = this.wizard.getDefaultPageImage();
        }
        return this.fImage;
    }

    public String getMessage() {
        return null;
    }

    public String getName() {
        return Messages.RemoteSyncWizardPage_0;
    }

    public String getTitle() {
        if (this.fTitle == null) {
            this.fTitle = Messages.RemoteSyncWizardPage_0;
        }
        return this.fTitle;
    }

    private void handleProviderSelected() {
        int index = this.fProviderCombo.getSelectionIndex();
        this.fProviderStack.topControl = (Control)this.fProviderControls.get(index);
        this.fSelectedProvider = this.fComboIndexToDescriptorMap.get(index);
        this.fProviderArea.layout();
        this.update();
        if (this.fSelectedProvider != null) {
            MBSCustomPageManager.addPageProperty((String)REMOTE_SYNC_WIZARD_PAGE_ID, (String)SERVICE_PROVIDER_PROPERTY, (Object)this.fSelectedProvider.getParticipant());
        } else {
            MBSCustomPageManager.addPageProperty((String)REMOTE_SYNC_WIZARD_PAGE_ID, (String)SERVICE_PROVIDER_PROPERTY, null);
        }
    }

    protected boolean isCustomPageComplete() {
        return this.fbVisited && this.getErrorMessage() == null && this.fSelectedProvider.getParticipant().isConfigComplete();
    }

    public void performHelp() {
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public void setImageDescriptor(ImageDescriptor image) {
        this.fImageDescriptor = image;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fbVisited = true;
        }
    }

    private void update() {
        this.getWizard().getContainer().updateMessage();
        this.getWizard().getContainer().updateButtons();
    }
}

