/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICPPASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPASTNamedTypeSpecifier
extends CPPASTBaseDeclSpecifier
implements ICPPASTNamedTypeSpecifier,
ICPPASTCompletionContext {
    private boolean typename;
    private IASTName name;

    public CPPASTNamedTypeSpecifier() {
    }

    public CPPASTNamedTypeSpecifier(IASTName name) {
        this.setName(name);
    }

    public CPPASTNamedTypeSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTNamedTypeSpecifier copy(IASTNode.CopyStyle style) {
        CPPASTNamedTypeSpecifier copy = new CPPASTNamedTypeSpecifier(this.name == null ? null : this.name.copy(style));
        this.copyBaseDeclSpec(copy);
        copy.typename = this.typename;
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public boolean isTypename() {
        return this.typename;
    }

    public void setIsTypename(boolean value) {
        this.assertNotFrozen();
        this.typename = value;
    }

    public IASTName getName() {
        return this.name;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(NAME);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 1;
        }
        return 3;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix, String[] namespaces) {
        IBinding[] bindings = CPPSemantics.findBindingsForContentAssist(n, isPrefix, namespaces);
        ArrayList<IBinding> filtered = new ArrayList<IBinding>();
        IBinding[] iBindingArray = bindings;
        int n2 = bindings.length;
        int n3 = 0;
        while (n3 < n2) {
            IBinding binding = iBindingArray[n3];
            if (binding instanceof ICPPClassType || binding instanceof IEnumeration || binding instanceof ICPPNamespace || binding instanceof ITypedef || binding instanceof ICPPTemplateTypeParameter) {
                filtered.add(binding);
            }
            ++n3;
        }
        return filtered.toArray(new IBinding[filtered.size()]);
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return this.findBindings(n, isPrefix, null);
    }
}

