/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.search;

import java.io.Serializable;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.browser.IndexModelUtil;
import org.eclipse.ptp.internal.rdt.core.search.RemoteTypeInfo;

public class RemoteSearchMatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ITypeInfo fTypeInfo;
    private IIndexName fName;
    private int fOffset;
    private int fLength;
    private boolean fIsPolymorphicCall;

    public RemoteSearchMatch(IIndex index, IIndexBinding binding, IIndexName name, int nodeOffset, int nodeLength) {
        try {
            String[] qualifiedNameParts;
            int elementType = IndexModelUtil.getElementType((IBinding)binding);
            if (binding instanceof ICPPBinding) {
                qualifiedNameParts = ((ICPPBinding)binding).getQualifiedName();
            } else if (binding instanceof IField) {
                IField field = (IField)binding;
                ICompositeType owner = field.getCompositeTypeOwner();
                qualifiedNameParts = new String[]{owner.getName(), field.getName()};
            } else {
                qualifiedNameParts = new String[]{binding.getName()};
            }
            QualifiedTypeName qualifiedName = new QualifiedTypeName(qualifiedNameParts);
            this.fTypeInfo = new RemoteTypeInfo(null, elementType, (IQualifiedTypeName)qualifiedName);
        }
        catch (DOMException dOMException) {}
        this.fName = name;
        this.fOffset = nodeOffset;
        this.fLength = nodeLength;
    }

    public RemoteSearchMatch(IIndexName name, ITypeInfo typeInfo, int offset, int length) {
        this.fName = name;
        this.fTypeInfo = new RemoteTypeInfo(null, typeInfo.getCElementType(), typeInfo.getQualifiedTypeName());
        this.fOffset = offset;
        this.fLength = length;
    }

    public IIndexName getName() {
        return this.fName;
    }

    public ITypeInfo getTypeInfo() {
        return this.fTypeInfo;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setIsPolymorphicCall() {
        this.fIsPolymorphicCall = true;
    }

    public boolean isPolymorphicCall() {
        return this.fIsPolymorphicCall;
    }
}

