#!/usr/bin/perl -w
#*******************************************************************************
# Copyright (c) 2005, 2007 IBM Corporation and others.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# IBM Corporation - initial API and implementation
#*******************************************************************************

# Arguments:
# ARGV[0] is the port number for the daemon to listen on. Default is 4075.
# ARGV[1] is the directory that contains RSE DStore server jar files and 
# installation supplied miner class files. The default is the working 
# directory.
#
# Environment Variables:
# CLASSPATH - used to form the tail of the classpath for the daemon and server execution.
# DSTORE_TRACING_ON - 0 means to not trace, 1 means to trace.
# DSTORE_DEBUG_ON - 0 means to start in normal mode, 1 means to start in debug mode.
#
# Results:
# Returns 1 if there is a startup error of some sort.
# Does not return if the daemon starts successfully. Terminate the
# daemon with a signal such as TERM or INT.

$port = $ARGV[0] || "4075";
$plugin_dir = $ARGV[1] || $ENV{PWD};
$trace = $ENV{DSTORE_TRACING_ON} || "0";
$debug = $ENV{DSTORE_DEBUG_ON} || "0";

$user=`whoami`; chomp($user); 
if ($user ne "root") {
	print "The root user must run the RSE DStore server daemon.\n";
	exit 1;
}

if ($debug) {
	$debug_options = "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=8000";
} else {
	$debug_options = "";
}

$classpath_old = $ENV{CLASSPATH};
$classpath = "$plugin_dir:$plugins_dir/cdtminer.jar:$plugins_dir/cdtmodel.jar:$plugins_dir/cdtparser.jar:$plugins_dir/org.eclipse.core.runtime_3.7.0.v20110110.jar:$plugins_dir/org.eclipse.equinox.common_3.6.0.v20110523.jar:$plugins_dir/org.eclipse.core.filesystem_1.3.100.v20110423-0524.jar:$plugins_dir/com.ibm.icu.base_4.4.2.v20110208.jar:$plugins_dir/stubs.jar:$plugins_dir/lrparser.jar:$plugins_dir/upcparser.jar:$plugins_dir/xlcparser.jar:$plugins_dir/spawner.jar:$plugins_dir/net.sourceforge.lpg.lpgjavaruntime_1.1.0.v200803061910.jar";
$classpath .= ":$plugin_dir/dstore_extra_server.jar";
$classpath .= ":$plugin_dir/dstore_core.jar";
$classpath .= ":$plugin_dir/dstore_miners.jar";
$classpath .= ":$plugin_dir/clientserver.jar";
if ($classpath_old) {
	$classpath .= ":$classpath_old";
}


$ENV{CLASSPATH} = $classpath;
$launcher = "org.eclipse.dstore.core.server.ServerLauncher";
$command = "java -Xms64m -Xmx128m -Xss2m $debug_options -DA_PLUGIN_PATH=$plugin_dir -DDSTORE_TRACING_ON=$trace $launcher $port";
print "$command\n";
system($command);
