/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.dstore.core.client.ConnectionStatus;
import org.eclipse.dstore.core.model.CommandHandler;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreCompatibilityHandler;
import org.eclipse.dstore.core.model.IExternalLoader;
import org.eclipse.dstore.core.model.ISSLProperties;
import org.eclipse.dstore.core.server.ServerLauncher;
import org.eclipse.dstore.core.util.ssl.IDataStoreTrustManager;
import org.eclipse.dstore.extra.IDomainNotifier;
import org.eclipse.dstore.internal.core.client.ClientAttributes;
import org.eclipse.dstore.internal.core.client.ClientCommandHandler;
import org.eclipse.dstore.internal.core.client.ClientReceiver;
import org.eclipse.dstore.internal.core.client.ClientUpdateHandler;
import org.eclipse.dstore.internal.core.server.ServerCommandHandler;
import org.eclipse.dstore.internal.core.util.ExternalLoader;
import org.eclipse.dstore.internal.core.util.Sender;
import org.eclipse.dstore.internal.core.util.ssl.DStoreSSLContext;
import org.eclipse.dstore.internal.core.util.ssl.DataStoreTrustManager;
import org.eclipse.dstore.internal.extra.DomainNotifier;

public class ClientConnection {
    private ClientAttributes _clientAttributes;
    private Socket _theSocket;
    private boolean _isConnected = false;
    private boolean _isRemote = false;
    private DataStore _dataStore;
    private IDomainNotifier _domainNotifier;
    private Sender _sender;
    private ClientReceiver _receiver;
    private ClientUpdateHandler _updateHandler;
    private CommandHandler _commandHandler;
    private int _clientVersion;
    private int _clientMinor;
    private String _name;
    private String _host;
    private String _port;
    private String _hostDirectory;
    private Socket _launchSocket;
    private DataStoreTrustManager _trustManager;
    private ArrayList _loaders;
    public static final String INCOMPATIBLE_SERVER_UPDATE = "Incompatible DataStore.";
    public static final String INCOMPATIBLE_CLIENT_UPDATE = "Incompatible DataStore.";
    public static final String SERVER_OLDER = "Older DataStore Server.";
    public static final String CLIENT_OLDER = "Older DataStore Client.";
    public static final String INCOMPATIBLE_PROTOCOL = "Incompatible Protocol.";
    public static final String CANNOT_CONNECT = "Cannot connect to server.";
    private static final String INVALID_DAEMON_PORT_NUMBER = "Invalid daemon port number.";

    public ClientConnection(String name) {
        this._domainNotifier = new DomainNotifier();
        this._name = name;
        this.init();
    }

    public ClientConnection(String name, int initialSize) {
        this._domainNotifier = new DomainNotifier();
        this._name = name;
        this.init(initialSize);
    }

    public ClientConnection(String name, IDomainNotifier notifier) {
        this._domainNotifier = notifier;
        this._name = name;
        this.init();
    }

    public ClientConnection(String name, IDomainNotifier notifier, int initialSize) {
        this._domainNotifier = notifier;
        this._name = name;
        this.init(initialSize);
    }

    public int getClientVersion() {
        return this._clientVersion;
    }

    public int getClientMinor() {
        return this._clientMinor;
    }

    public int getServerVersion() {
        return this._dataStore.getServerVersion();
    }

    public int getServerMinor() {
        return this._dataStore.getServerMinor();
    }

    public void setSSLProperties(ISSLProperties properties) {
        this._dataStore.setSSLProperties(properties);
    }

    public void setCompatibilityHandler(IDataStoreCompatibilityHandler handler) {
        this._dataStore.setCompatibilityHandler(handler);
    }

    public IDataStoreCompatibilityHandler getCompatibilityHandler() {
        return this._dataStore.getCompatibilityHandler();
    }

    public void setLoaders(ArrayList loaders) {
        this._loaders = loaders;
    }

    public void addLoader(IExternalLoader loader) {
        if (this._loaders == null) {
            this._loaders = new ArrayList();
        }
        this._loaders.add(loader);
    }

    public void setHost(String host) {
        this._host = host;
        this._clientAttributes.setAttribute(3, this._host);
    }

    public void setPort(String port) {
        if (port == null || port.length() == 0) {
            port = "0";
        }
        this._port = port;
        this._clientAttributes.setAttribute(5, this._port);
    }

    public void setHostDirectory(String directory) {
        this._hostDirectory = directory;
        this._clientAttributes.setAttribute(4, this._hostDirectory);
    }

    public String getHost() {
        return this._host;
    }

    public String getPort() {
        return this._port;
    }

    public String getHostDirectory() {
        return this._hostDirectory;
    }

    public boolean isConnected() {
        if (this._isConnected) {
            return this._dataStore.isConnected();
        }
        return this._isConnected;
    }

    public void disconnect() {
        if (this._isConnected) {
            this._dataStore.removeDataStorePreferenceListener(this._receiver);
            this._dataStore.setConnected(false);
            if (this._isRemote) {
                this._commandHandler.command(this._dataStore.find(this._dataStore.getRoot(), 2, "Exit"), this._dataStore.getHostRoot(), false);
                this._receiver.finish();
            }
            this._commandHandler.finish();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
            this._updateHandler.finish();
            this._dataStore.finish();
            this._isConnected = false;
        }
    }

    public ConnectionStatus localConnect() {
        this._updateHandler = new ClientUpdateHandler();
        this._updateHandler.start();
        if (this._loaders == null) {
            this._loaders = new ArrayList();
            this._loaders.add(new ExternalLoader(this.getClass().getClassLoader(), "*"));
        }
        this._commandHandler = new ServerCommandHandler(this._loaders);
        this._commandHandler.start();
        this._dataStore.setCommandHandler(this._commandHandler);
        this._dataStore.setUpdateHandler(this._updateHandler);
        this._dataStore.setConnected(true);
        this._dataStore.setLoaders(this._loaders);
        this._dataStore.getDomainNotifier().enable(true);
        this._commandHandler.setDataStore(this._dataStore);
        this._updateHandler.setDataStore(this._dataStore);
        ((ServerCommandHandler)this._commandHandler).loadMiners();
        this._clientAttributes.setAttribute(6, this._clientAttributes.getAttribute(3));
        this._clientAttributes.setAttribute(7, this._clientAttributes.getAttribute(4));
        this._isConnected = true;
        DataElement ticket = this._dataStore.getTicket();
        ticket.setAttribute(2, "null");
        ConnectionStatus result = new ConnectionStatus(this._isConnected);
        result.setTicket(ticket.getName());
        return result;
    }

    public ConnectionStatus connect(boolean launchServer, String user, String password) {
        ConnectionStatus launchStatus = null;
        if (launchServer) {
            launchStatus = this.launchServer(user, password);
            if (!launchStatus.isConnected()) {
                return launchStatus;
            }
        } else {
            launchStatus = new ConnectionStatus(true);
            launchStatus.setTicket("null");
        }
        return this.connect(launchStatus.getTicket());
    }

    public IDataStoreTrustManager getTrustManager() {
        if (this._trustManager == null) {
            this._trustManager = new DataStoreTrustManager();
        }
        return this._trustManager;
    }

    public ConnectionStatus connect(String ticket) {
        return this.connect(ticket, 0);
    }

    public ConnectionStatus connect(String ticket, int timeout) {
        boolean doTimeOut = timeout > 0;
        ConnectionStatus result = null;
        try {
            int port = 0;
            if (this._port != null && this._port.length() > 0) {
                port = Integer.parseInt(this._port);
            }
            if (!this._dataStore.usingSSL()) {
                this._theSocket = new Socket(this._host, port);
                if (doTimeOut && this._theSocket != null) {
                    this._theSocket.setSoTimeout(timeout);
                }
            } else {
                String location = this._dataStore.getKeyStoreLocation();
                String pw = this._dataStore.getKeyStorePassword();
                IDataStoreTrustManager mgr = this.getTrustManager();
                SSLContext context = DStoreSSLContext.getClientSSLContext(location, pw, mgr);
                SSLSocketFactory factory = context.getSocketFactory();
                this._theSocket = factory.createSocket(this._host, port);
                if (doTimeOut && this._theSocket != null) {
                    this._theSocket.setSoTimeout(timeout);
                }
                try {
                    ((SSLSocket)this._theSocket).startHandshake();
                    ((SSLSocket)this._theSocket).getSession();
                }
                catch (SSLHandshakeException e) {
                    result = new ConnectionStatus(false, e, true, mgr.getUntrustedCerts());
                    this.setPort(this._clientAttributes.getAttribute(5));
                    return result;
                }
                catch (SSLException e) {
                    this._theSocket.close();
                    this.setPort(this._clientAttributes.getAttribute(5));
                    result = new ConnectionStatus(false, e, true, null);
                    return result;
                }
                catch (Exception e) {
                    this._theSocket.close();
                    this.setPort(this._clientAttributes.getAttribute(5));
                    result = new ConnectionStatus(false, e);
                    return result;
                }
            }
            String msg = null;
            int handshakeResult = this.doHandShake();
            switch (handshakeResult) {
                case 2: {
                    result = this.doConnect(ticket);
                    break;
                }
                case 6: {
                    result = this.doConnect(ticket);
                    result.setMessage(CLIENT_OLDER);
                    break;
                }
                case 5: {
                    result = this.doConnect(ticket);
                    result.setMessage(SERVER_OLDER);
                    break;
                }
                case 4: {
                    msg = "Incompatible DataStore.";
                    msg = String.valueOf(msg) + "\nThe server running on " + this._host + " under port " + this._port + " is a newer DataStore server.";
                    break;
                }
                case 1: {
                    msg = "Incompatible DataStore.";
                    msg = String.valueOf(msg) + "\nThe server running on " + this._host + " under port " + this._port + " is an older DataStore server.";
                    break;
                }
                case 0: {
                    msg = CANNOT_CONNECT;
                    msg = String.valueOf(msg) + INCOMPATIBLE_PROTOCOL;
                    msg = String.valueOf(msg) + "\nThe server running on " + this._host + " under port " + this._port + " is not a valid DataStore server.";
                    break;
                }
                case 3: {
                    msg = CANNOT_CONNECT;
                    msg = String.valueOf(msg) + "Unexpected exception.";
                    break;
                }
                case 7: {
                    msg = CANNOT_CONNECT;
                    msg = String.valueOf(msg) + "Timeout waiting for socket activity.";
                    break;
                }
            }
            if (result == null && msg != null) {
                result = new ConnectionStatus(false, msg);
                this._isConnected = false;
                this.setPort(this._clientAttributes.getAttribute(5));
                this._theSocket.close();
            }
        }
        catch (ConnectException connectException) {
            String msg = "Connection Refused.";
            this.setPort(this._clientAttributes.getAttribute(5));
            msg = String.valueOf(msg) + "\nMake sure that the DataStore server is running on " + this._host + " under port " + this._port + ".";
            result = new ConnectionStatus(false, msg);
        }
        catch (UnknownHostException uhe) {
            this.setPort(this._clientAttributes.getAttribute(5));
            this._isConnected = false;
            result = new ConnectionStatus(this._isConnected, uhe);
        }
        catch (IOException ioe) {
            this.setPort(this._clientAttributes.getAttribute(5));
            this._isConnected = false;
            result = new ConnectionStatus(this._isConnected, ioe);
        }
        return result;
    }

    protected ConnectionStatus doConnect(String ticket) {
        this._sender = new Sender(this._theSocket, this._dataStore);
        this._updateHandler = new ClientUpdateHandler();
        this._updateHandler.start();
        this._commandHandler = new ClientCommandHandler(this._sender);
        this._commandHandler.start();
        this._dataStore.setCommandHandler(this._commandHandler);
        this._dataStore.setUpdateHandler(this._updateHandler);
        this._dataStore.setConnected(true);
        this._dataStore.getDomainNotifier().enable(true);
        this._commandHandler.setDataStore(this._dataStore);
        this._updateHandler.setDataStore(this._dataStore);
        this._receiver = new ClientReceiver(this._theSocket, this._dataStore);
        this._dataStore.addDataStorePreferenceListener(this._receiver);
        this._receiver.start();
        this._isConnected = true;
        this._isRemote = true;
        ConnectionStatus result = new ConnectionStatus(this._isConnected);
        result.setTicket(ticket);
        return result;
    }

    public ConnectionStatus launchServer(String user, String password) {
        return this.launchServer(user, password, ServerLauncher.DEFAULT_DAEMON_PORT);
    }

    public ConnectionStatus launchServer(String user, String password, int daemonPort) {
        return this.launchServer(user, password, daemonPort, 0);
    }

    public ConnectionStatus launchServer(String user, String password, int daemonPort, int timeout) {
        ConnectionStatus result;
        if (timeout <= 0) {
            timeout = 10000;
        }
        if (!(result = this.connectDaemon(daemonPort, timeout)).isConnected()) {
            return result;
        }
        try {
            PrintWriter writer = null;
            BufferedReader reader = null;
            try {
                writer = new PrintWriter(new OutputStreamWriter(this._launchSocket.getOutputStream(), "UTF-8"));
                writer.println(user);
                writer.println(password);
                writer.println(this._port);
                writer.flush();
                reader = new BufferedReader(new InputStreamReader(this._launchSocket.getInputStream(), "UTF-8"));
                String status = null;
                try {
                    status = reader.readLine();
                }
                catch (InterruptedIOException e) {
                    result = new ConnectionStatus(false, e);
                }
                if (status != null && !status.equals("connected")) {
                    result = new ConnectionStatus(false, status);
                } else if (status == null) {
                    Exception e = new Exception("no status returned");
                    result = new ConnectionStatus(false, e);
                } else {
                    result = new ConnectionStatus(true);
                    this._port = reader.readLine();
                    String ticket = reader.readLine();
                    result.setTicket(ticket);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = new ConnectionStatus(false, e);
            }
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
            this._launchSocket.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            result = new ConnectionStatus(false, ioe);
        }
        return result;
    }

    public ConnectionStatus connectDaemon(int daemonPort, int timeout) {
        ConnectionStatus result;
        block15: {
            result = new ConnectionStatus(true);
            try {
                this._launchSocket = null;
                if (this._dataStore.usingSSL()) {
                    try {
                        String location = this._dataStore.getKeyStoreLocation();
                        String pw = this._dataStore.getKeyStorePassword();
                        IDataStoreTrustManager mgr = this.getTrustManager();
                        SSLContext context = DStoreSSLContext.getClientSSLContext(location, pw, mgr);
                        try {
                            SSLSocketFactory factory = context.getSocketFactory();
                            SSLSocket lSocket = (SSLSocket)factory.createSocket(this._host, daemonPort);
                            this._launchSocket = lSocket;
                            if (timeout > 0) {
                                this._launchSocket.setSoTimeout(timeout);
                            }
                            lSocket.startHandshake();
                            SSLSession session = lSocket.getSession();
                            if (session == null) {
                                lSocket.close();
                            }
                            break block15;
                        }
                        catch (SSLHandshakeException e) {
                            result = new ConnectionStatus(false, e, true, mgr.getUntrustedCerts());
                            return result;
                        }
                        catch (Exception e) {
                            if (this._launchSocket != null) {
                                this._launchSocket.close();
                            }
                            result = daemonPort <= 0 || daemonPort > 65535 ? new ConnectionStatus(false, INVALID_DAEMON_PORT_NUMBER) : new ConnectionStatus(false, e);
                            return result;
                        }
                    }
                    catch (Exception e) {
                        result = new ConnectionStatus(false, e);
                        return result;
                    }
                }
                this._launchSocket = new Socket(this._host, daemonPort);
                if (timeout > 0) {
                    this._launchSocket.setSoTimeout(timeout);
                }
            }
            catch (ConnectException connectException) {
                String msg = "Connection Refused.";
                msg = String.valueOf(msg) + "\nMake sure that the DataStore daemon is running on " + this._host + ".";
                result = new ConnectionStatus(false, msg);
            }
            catch (UnknownHostException uhe) {
                result = new ConnectionStatus(false, uhe);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                result = new ConnectionStatus(false, INVALID_DAEMON_PORT_NUMBER);
            }
            catch (IOException ioe) {
                result = new ConnectionStatus(false, ioe);
            }
        }
        return result;
    }

    public Socket getLaunchSocket() {
        return this._launchSocket;
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    private void init() {
        this.init(10000);
    }

    private void init(int initialSize) {
        this._clientAttributes = new ClientAttributes();
        this._clientAttributes.setAttribute(1, this._name);
        this._dataStore = new DataStore(this._clientAttributes, initialSize);
        this._dataStore.setDomainNotifier(this._domainNotifier);
        this._dataStore.createRoot();
        this._host = this._clientAttributes.getAttribute(3);
        this._hostDirectory = this._clientAttributes.getAttribute(4);
        this._port = this._clientAttributes.getAttribute(5);
    }

    private int doHandShake() {
        String handshake;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this._theSocket.getInputStream(), "UTF-8"));
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(this._theSocket.getOutputStream(), "UTF-8"));
            writer.println("");
            writer.println("");
            writer.println("");
            writer.flush();
            handshake = null;
            try {
                handshake = reader.readLine();
            }
            catch (InterruptedIOException interruptedIOException) {
                return 7;
            }
        }
        catch (Exception exception) {
            return 3;
        }
        this._theSocket.setSoTimeout(0);
        String[] serverVersionStr = handshake.split("\\.");
        int serverVersion = Integer.parseInt(serverVersionStr[1]);
        this._dataStore.setServerVersion(serverVersion);
        this._dataStore.setServerMinor(Integer.parseInt(serverVersionStr[2]));
        return this.getCompatibilityHandler().checkCompatibility(handshake);
    }

    public boolean isKnownStatus(String status) {
        boolean known;
        boolean bl = known = status.equals("connected") || status.equals("Authentification Failed") || status.equals("unknown problem connecting to server") || status.startsWith("server failure: ") || status.equals("password expired") || status.equals("new password not valid");
        if (!known) {
            known = status.startsWith("Error binding socket");
        }
        return known;
    }
}

