/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.feedback;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.etfw.feedback.Activator;
import org.eclipse.ptp.etfw.feedback.messages.Messages;
import org.eclipse.ptp.etfw.feedback.obj.IFeedbackItem;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerManager {
    private static final boolean traceOn = false;
    static String path;
    static String filename;
    Map<String, IResource> fileMap = new HashMap<String, IResource>();
    private static final String SLASH;
    private static int counter;

    static {
        SLASH = System.getProperty("file.separator");
        counter = 0;
    }

    public void removeMarkers(IResource res, String markerID) {
        try {
            res.deleteMarkers(markerID, true, 2);
        }
        catch (CoreException coreException) {
            System.out.println("Error deleting markers on " + res.getName() + " - probably can ignore this.");
        }
    }

    public String getSrcPath(File file) {
        String docpath = null;
        try {
            docpath = file.getAbsolutePath();
            int indx = docpath.lastIndexOf(SLASH);
            String pathname = docpath.substring(0, indx);
            indx = pathname.lastIndexOf(SLASH);
            pathname = pathname.substring(0, indx);
            pathname = String.valueOf(pathname) + SLASH + "src";
            return pathname;
        }
        catch (Exception exception) {
            System.out.println("Exception parsing src path from " + docpath);
            return null;
        }
    }

    public String stripFileNameOnly(String filename) {
        int indx = filename.lastIndexOf(SLASH);
        if (indx >= 0) {
            filename = filename.substring(indx + 1);
        } else {
            String otherSlash = "/";
            if (SLASH.equals(otherSlash)) {
                otherSlash = "\\";
            }
            StringBuffer newf = new StringBuffer();
            int len = filename.length();
            try {
                int i = 0;
                while (i < len) {
                    String next = filename.substring(i, i + 1);
                    if (next.equals(otherSlash)) {
                        newf.append(SLASH);
                    } else {
                        newf.append(next);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            indx = newf.lastIndexOf(SLASH);
            if (indx >= 0) {
                filename = newf.substring(indx + 1);
            }
        }
        return filename;
    }

    String getStrAttr(NamedNodeMap attribs, String attrName) {
        Node node = attribs.getNamedItem(attrName);
        if (node == null) {
            return "";
        }
        String val = node.getNodeValue();
        return val;
    }

    int getIntAttr(NamedNodeMap attribs, String attrName) {
        Node node = attribs.getNamedItem(attrName);
        String val = node.getNodeValue();
        int intVal = this.toInt(val);
        return intVal;
    }

    public int toInt(String str) {
        int value = 0;
        try {
            value = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            System.out.println("NumberFormatException(" + str + "): " + e.getMessage());
            value = 0;
        }
        return value;
    }

    public IResource getResource(String pathname, String filename) {
        ResourcesPlugin.getWorkspace();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFileForLocation((IPath)new Path(String.valueOf(pathname) + SLASH + filename));
        return file;
    }

    public IResource getResource(String filename) {
        ResourcesPlugin.getWorkspace();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFileForLocation((IPath)new Path(filename));
        file = root.getFile((IPath)new Path(filename));
        return file;
    }

    public IResource getResource(URI location) {
        ResourcesPlugin.getWorkspace();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile[] files = root.findFilesForLocationURI(location);
        IFile file = files[0];
        return file;
    }

    public static IResource getResourceInProject(String projName, String filename) {
        ResourcesPlugin.getWorkspace();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject proj = root.getProject(projName);
        IResource res = proj.findMember(filename);
        return res;
    }

    public Map<String, Object> createCommonMarkers(IFeedbackItem item, String itemID, String name, String parentID, String filename, String pathname, int lineNo, String desc) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("itemID", itemID);
        attrs.put("priority", new Integer(1));
        attrs.put("name", name);
        attrs.put("filename", filename);
        attrs.put("parent", parentID);
        attrs.put("pathname", pathname);
        attrs.put("lineNumber", new Integer(lineNo));
        attrs.put("item", item);
        attrs.put("description", desc);
        attrs.put("LoopId", "");
        return attrs;
    }

    public void createMarker(IResource resource, Map<String, Object> attrs, String markerID) {
        try {
            MarkerUtilities.createMarker((IResource)resource, attrs, (String)markerID);
        }
        catch (CoreException e) {
            System.out.println("Error creating Xform marker: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void createMarkers(final List<IFeedbackItem> itemlist, final String markerID) {
        long firstStart = System.currentTimeMillis();
        if (itemlist.size() == 0) {
            this.showNoItemsFound();
            return;
        }
        this.fileMap = new HashMap<String, IResource>();
        for (IFeedbackItem item : itemlist) {
            String filename = item.getFile();
            if (filename == null || this.fileMap.containsKey(filename)) continue;
            IFile ifile = item.getIFile();
            this.fileMap.put(filename, (IResource)ifile);
        }
        IResource res = null;
        for (String filename : this.fileMap.keySet()) {
            res = this.fileMap.get(filename);
            try {
                this.removeMarkers(res, markerID);
            }
            catch (Exception exception) {
                System.out.println("Error deleting markers on file: " + res);
            }
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                MarkerManager.this.loopItemsCreateMarkers(itemlist, markerID);
            }
        };
        IProgressMonitor monitor = null;
        try {
            workspace.run(operation, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void loopItemsCreateMarkers(List<IFeedbackItem> itemlist, String markerID) {
        for (IFeedbackItem item : itemlist) {
            String filename = item.getFile();
            String name = item.getName();
            int lineNo = item.getLineNoStart();
            String desc = item.getDescription();
            String itemID = item.getID();
            String parentID = item.getParentID();
            String pathname = "";
            IResource resource = this.fileMap.get(filename);
            if (filename != null && filename.contains("/")) {
                Path path = new Path(filename);
                pathname = path.removeLastSegments(1).toString();
                filename = path.segment(path.segmentCount() - 1);
            }
            Map<String, Object> attrs = this.createCommonMarkers(item, itemID, name, parentID, filename, pathname, lineNo, desc);
            if (resource != null) {
                this.createMarker(resource, attrs, markerID);
            } else {
                System.out.println("Feedback MarkerManager: Null resource for pathname=" + pathname + "; filename=" + filename + "; no markers created.  item.getFile()=" + item.getFile());
            }
            if (!item.hasChildren()) continue;
            List<IFeedbackItem> kids = item.getChildren();
            for (IFeedbackItem kid : kids) {
                int uid;
                String parentid = item.getID();
                String namePrefix = "";
                String kname = kid.getName();
                ++counter;
                String uidStr = Integer.toString(uid);
                attrs = this.createCommonMarkers(kid, uidStr, kname, parentid, filename, pathname, lineNo, kid.getDescription());
                this.createMarker(resource, attrs, markerID);
                boolean gkids = kid.hasChildren();
                if (!gkids) continue;
                List<IFeedbackItem> gkidItems = kid.getChildren();
                Iterator<IFeedbackItem> iterator = gkidItems.iterator();
                while (iterator.hasNext()) {
                    IFeedbackItem gkid;
                    IFeedbackItem gki = gkid = iterator.next();
                    String gkNamePrefix = Messages.MarkerManager_solution;
                    attrs = this.createCommonMarkers(gki, gki.getID(), String.valueOf(gkNamePrefix) + gki.getName(), uidStr, filename, pathname, lineNo, gki.getDescription());
                    this.createMarker(resource, attrs, markerID);
                }
            }
        }
    }

    private void showNoItemsFound() {
        IPreferenceStore pf = Activator.getDefault().getPreferenceStore();
        boolean showDialog = pf.getBoolean("showNoItemsFoundDialog");
        if (showDialog) {
            String title = Messages.MarkerManager_noFeedbackItemsFoundTitle;
            String msg = Messages.MarkerManager_noFeedbackItemsFoundMessage;
            String togMsg = Messages.MarkerManager_dontShowMeThisAgain;
            MessageDialogWithToggle.openInformation(null, (String)title, (String)msg.toString(), (String)togMsg, (boolean)false, (IPreferenceStore)pf, (String)"showNoItemsFoundDialog");
        }
    }
}

