/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.core;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.remotetools.environment.control.ITargetConfig;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.ptp.remotetools.environment.extension.ITargetTypeExtension;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetElement
implements ITargetElement {
    private TargetTypeElement type;
    private ControlAttributes attributes;
    private String name;
    private final String id;
    private ITargetControl control;
    private int status = 1;
    private boolean dirty = false;

    public TargetElement(TargetTypeElement type, String id) {
        this.type = type;
        this.id = id;
    }

    public TargetElement(TargetTypeElement type, String name, ControlAttributes attrs, String id) {
        this(type, id);
        this.attributes = attrs;
        this.name = name;
        this.type = type;
    }

    public TargetElement(TargetTypeElement type, String name, Map<String, String> attrs, String id) {
        this(type, id);
        this.attributes = new ControlAttributes(attrs);
        this.name = name;
        this.type = type;
    }

    public TargetElement(TargetTypeElement type, String name, String id) {
        this(type, id);
        this.name = name;
        this.type = type;
    }

    @Override
    public ControlAttributes getAttributes() {
        try {
            return this.getControl().getConfig().getAttributes();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public ITargetControl getControl() throws CoreException {
        if (this.control == null) {
            ITargetTypeExtension ext = this.type.getExtension();
            ITargetConfig config = ext.createConfig(this.attributes);
            this.control = ext.createControl(config);
        }
        return this.control;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public TargetTypeElement getType() {
        return this.type;
    }

    @Override
    public void setAttributes(ControlAttributes attributes) {
        this.attributes = attributes;
        if (this.getStatus() == 1) {
            this.update();
        } else {
            this.dirty = true;
        }
    }

    public void setControl(ITargetControl control) {
        this.control = control;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(int status) {
        this.status = status;
        if (status == 1 && this.dirty) {
            this.update();
        }
    }

    public void setType(TargetTypeElement type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return this.getName() != null ? this.getName() : super.toString();
    }

    private void update() {
        try {
            ITargetControl ctrl = this.getControl();
            ctrl.updateConfiguration();
            this.dirty = false;
        }
        catch (CoreException coreException) {
            this.dirty = true;
        }
    }
}

